/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.optimizer.rules.InlineAndRemoveRedundantBooleanExpressionsRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.FDsAndEquivClassesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveRedundantBooleanExpressionsInJoinRule
extends InlineAndRemoveRedundantBooleanExpressionsRule {
    private final FDsAndEquivClassesVisitor visitor = new FDsAndEquivClassesVisitor();
    private final Map<LogicalVariable, LogicalVariable> normalizedVariables = new HashMap<LogicalVariable, LogicalVariable>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    @Override
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        LogicalOperatorTag opTag = op.getOperatorTag();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        if (opTag != LogicalOperatorTag.INNERJOIN && opTag != LogicalOperatorTag.LEFTOUTERJOIN) {
            if (op.getOperatorTag() != LogicalOperatorTag.DISTINCT) {
                op.accept((ILogicalOperatorVisitor)this.visitor, (Object)context);
            }
            context.addToDontApplySet((IAlgebraicRewriteRule)this, op);
            return false;
        }
        boolean changed = this.normalize(context, op);
        op.accept((ILogicalOperatorVisitor)this.visitor, (Object)context);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, op);
        return changed;
    }

    private boolean normalize(IOptimizationContext context, ILogicalOperator op) {
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        ILogicalOperator leftOp = (ILogicalOperator)((Mutable)joinOp.getInputs().get(0)).getValue();
        ILogicalOperator rightOp = (ILogicalOperator)((Mutable)joinOp.getInputs().get(1)).getValue();
        Map leftEqMap = context.getEquivalenceClassMap(leftOp);
        Map rightEqMap = context.getEquivalenceClassMap(rightOp);
        this.normalizedVariables.clear();
        Mutable joinCondRef = joinOp.getCondition();
        MutableObject clonedCondition = new MutableObject((Object)((ILogicalExpression)joinCondRef.getValue()).cloneExpression());
        if (this.normalizeVariables(leftEqMap, rightEqMap, (Mutable<ILogicalExpression>)clonedCondition) && this.transform((Mutable<ILogicalExpression>)clonedCondition)) {
            joinCondRef.setValue((Object)((ILogicalExpression)clonedCondition.getValue()));
            return true;
        }
        return false;
    }

    private boolean normalizeVariables(Map<LogicalVariable, EquivalenceClass> leftEqMap, Map<LogicalVariable, EquivalenceClass> rightEqMap, Mutable<ILogicalExpression> exprRef) {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            return this.processFunction(leftEqMap, rightEqMap, (AbstractFunctionCallExpression)expr);
        }
        if (expr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            return false;
        }
        LogicalVariable toNormalizeVariable = VariableUtilities.getVariable((ILogicalExpression)expr);
        LogicalVariable normalized = this.getNormalizedVariableAndSetEquivalentsIfAny(leftEqMap, rightEqMap, toNormalizeVariable);
        if (normalized == toNormalizeVariable) {
            return false;
        }
        exprRef.setValue((Object)new VariableReferenceExpression(normalized));
        return true;
    }

    private LogicalVariable getNormalizedVariableAndSetEquivalentsIfAny(Map<LogicalVariable, EquivalenceClass> leftEqMap, Map<LogicalVariable, EquivalenceClass> rightEqMap, LogicalVariable toNormalizeVariable) {
        if (this.normalizedVariables.containsKey(toNormalizeVariable)) {
            return this.normalizedVariables.get(toNormalizeVariable);
        }
        if (leftEqMap != null && leftEqMap.containsKey(toNormalizeVariable)) {
            this.setNormalizedVariables(toNormalizeVariable, leftEqMap.get(toNormalizeVariable));
        } else if (rightEqMap != null && rightEqMap.containsKey(toNormalizeVariable)) {
            this.setNormalizedVariables(toNormalizeVariable, rightEqMap.get(toNormalizeVariable));
        }
        return toNormalizeVariable;
    }

    private void setNormalizedVariables(LogicalVariable toNormalizeVariable, EquivalenceClass equivalenceClass) {
        for (LogicalVariable eqVar : equivalenceClass.getMembers()) {
            this.normalizedVariables.put(eqVar, toNormalizeVariable);
        }
    }

    private boolean processFunction(Map<LogicalVariable, EquivalenceClass> leftEqMap, Map<LogicalVariable, EquivalenceClass> rightEqMap, AbstractFunctionCallExpression funcExpr) {
        boolean changed = false;
        for (Mutable argRef : funcExpr.getArguments()) {
            changed |= this.normalizeVariables(leftEqMap, rightEqMap, (Mutable<ILogicalExpression>)argRef);
        }
        return changed;
    }
}

