/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BufferedReadableByteChannelSession;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

final class LazyReadChannel<T> {
    private final Supplier<BufferedReadableByteChannelSession<T>> sessionSupplier;
    private volatile @MonotonicNonNull BufferedReadableByteChannelSession<T> session;
    private volatile @MonotonicNonNull BufferedReadableByteChannelSession.BufferedReadableByteChannel channel;
    private boolean open = false;

    LazyReadChannel(Supplier<BufferedReadableByteChannelSession<T>> sessionSupplier) {
        this.sessionSupplier = sessionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull BufferedReadableByteChannelSession.BufferedReadableByteChannel getChannel() {
        if (this.channel != null) {
            return this.channel;
        }
        LazyReadChannel lazyReadChannel = this;
        synchronized (lazyReadChannel) {
            if (this.channel == null) {
                this.open = true;
                this.channel = (BufferedReadableByteChannelSession.BufferedReadableByteChannel)this.getSession().open();
            }
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull BufferedReadableByteChannelSession<T> getSession() {
        if (this.session != null) {
            return this.session;
        }
        LazyReadChannel lazyReadChannel = this;
        synchronized (lazyReadChannel) {
            if (this.session == null) {
                this.session = this.sessionSupplier.get();
            }
            return this.session;
        }
    }

    boolean isOpen() {
        return this.open && this.getChannel().isOpen();
    }
}

