/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.io.Serializable;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestNonMapOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.api.exceptions.ErrorCode;

public class LeftOuterUnnestOperator
extends AbstractUnnestNonMapOperator {
    private IAlgebricksConstantValue missingValue;

    public LeftOuterUnnestOperator(LogicalVariable variable, Mutable<ILogicalExpression> expression, IAlgebricksConstantValue missingValue) {
        super(variable, expression);
        this.setMissingValue(missingValue);
    }

    public LeftOuterUnnestOperator(LogicalVariable variable, Mutable<ILogicalExpression> expression, LogicalVariable positionalVariable, Object positionalVariableType, IAlgebricksConstantValue missingValue) {
        super(variable, expression, positionalVariable, positionalVariableType);
        this.setMissingValue(missingValue);
    }

    public IAlgebricksConstantValue getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(IAlgebricksConstantValue missingValue) {
        this.missingValue = LeftOuterUnnestOperator.validateMissingValue(missingValue);
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitLeftOuterUnnestOperator(this, arg);
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        Object outVarType;
        PropagatingTypeEnvironment env = this.createPropagatingAllInputsTypeEnvironment(ctx);
        Object outPositionalVarType = null;
        Object t = env.getType((ILogicalExpression)this.expression.getValue());
        IMissableTypeComputer tc = ctx.getMissableTypeComputer();
        if (this.missingValue.isMissing()) {
            outVarType = tc.makeMissableType(t);
            if (this.positionalVariable != null) {
                outPositionalVarType = tc.makeMissableType(this.positionalVariableType);
            }
        } else if (this.missingValue.isNull()) {
            outVarType = tc.makeNullableType(t);
            if (this.positionalVariable != null) {
                outPositionalVarType = tc.makeNullableType(this.positionalVariableType);
            }
        } else {
            throw new AlgebricksException(ErrorCode.ILLEGAL_STATE, this.getSourceLocation(), new Serializable[]{""});
        }
        env.setVarType((LogicalVariable)this.variables.get(0), outVarType);
        if (this.positionalVariable != null) {
            env.setVarType(this.positionalVariable, outPositionalVarType);
        }
        return env;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.LEFT_OUTER_UNNEST;
    }

    private static IAlgebricksConstantValue validateMissingValue(IAlgebricksConstantValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.isMissing()) {
            return ConstantExpression.MISSING.getValue();
        }
        if (value.isNull()) {
            return ConstantExpression.NULL.getValue();
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }
}

