/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.bloomfilter.impls;

import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class MurmurHash128Bit {
    private static final int DUMMY_FIELD = 0;

    public static long rotl64(long v, int n) {
        return v << n | v >>> 64 - n;
    }

    public static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static void hash3_x64_128(ITupleReference tuple, int[] keyFields, long seed, long[] hashes) {
        int length = 0;
        for (int i = 0; i < keyFields.length; ++i) {
            length += tuple.getFieldLength(keyFields[i]);
        }
        int nblocks = length >> 4;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int currentFieldIndex = 0;
        int bytePos = 0;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = 0L;
            for (int j = 0; j < 8; ++j) {
                k1 += ((long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] & 0xFFL) << (j << 3);
                if (tuple.getFieldLength(keyFields[currentFieldIndex]) != ++bytePos) continue;
                ++currentFieldIndex;
                bytePos = 0;
            }
            long k2 = 0L;
            for (int j = 0; j < 8; ++j) {
                k2 += ((long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] & 0xFFL) << (j << 3);
                if (tuple.getFieldLength(keyFields[currentFieldIndex]) != ++bytePos) continue;
                ++currentFieldIndex;
                bytePos = 0;
            }
            k1 *= c1;
            k1 = MurmurHash128Bit.rotl64(k1, 31);
            h1 ^= (k1 *= c2);
            h1 = MurmurHash128Bit.rotl64(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= c2;
            k2 = MurmurHash128Bit.rotl64(k2, 33);
            h2 ^= (k2 *= c1);
            h2 = MurmurHash128Bit.rotl64(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        long k1 = 0L;
        long k2 = 0L;
        currentFieldIndex = keyFields.length - 1;
        bytePos = tuple.getFieldLength(keyFields[currentFieldIndex]) - 1;
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 48;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 14: {
                k2 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 40;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 13: {
                k2 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 32;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 12: {
                k2 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 24;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 11: {
                k2 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 16;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 10: {
                k2 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 8;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 9: {
                k2 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos];
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
                k2 *= c2;
                k2 = MurmurHash128Bit.rotl64(k2, 33);
                h2 ^= (k2 *= c1);
            }
            case 8: {
                k1 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 56;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 7: {
                k1 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 48;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 6: {
                k1 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 40;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 5: {
                k1 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 32;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 4: {
                k1 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 24;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 3: {
                k1 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 16;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 2: {
                k1 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos] << 8;
                if (--bytePos == -1) {
                    bytePos = tuple.getFieldLength(keyFields[--currentFieldIndex]) - 1;
                }
            }
            case 1: {
                k1 ^= (long)tuple.getFieldData(0)[tuple.getFieldStart(keyFields[currentFieldIndex]) + bytePos];
                k1 *= c1;
                k1 = MurmurHash128Bit.rotl64(k1, 31);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = MurmurHash128Bit.fmix(h1);
        h2 = MurmurHash128Bit.fmix(h2);
        h1 += h2;
        hashes[0] = h1;
        hashes[1] = h2 += h1;
    }
}

