/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.api.IExtensionMetadataEntity;
import org.apache.asterix.metadata.api.IExtensionMetadataSearchKey;
import org.apache.asterix.metadata.api.IMetadataManager;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MetadataManager
implements IMetadataManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MetadataCache cache = new MetadataCache();
    protected final Collection<IAsterixStateProxy> proxies;
    protected IMetadataNode metadataNode;
    protected boolean rebindMetadataNode = false;
    public static IMetadataManager INSTANCE;

    private MetadataManager(Collection<IAsterixStateProxy> proxies, MetadataNode metadataNode) {
        this(proxies);
        if (metadataNode == null) {
            throw new IllegalArgumentException("Null metadataNode given to MetadataManager");
        }
        this.metadataNode = metadataNode;
    }

    private MetadataManager(Collection<IAsterixStateProxy> proxies) {
        if (proxies == null || proxies.isEmpty()) {
            throw new IllegalArgumentException("Null / empty list of proxies given to MetadataManager");
        }
        this.proxies = proxies;
    }

    protected abstract TxnId createTxnId();

    public void init() throws HyracksDataException {
    }

    @Override
    public MetadataTransactionContext beginTransaction() throws RemoteException {
        try {
            INSTANCE.init();
        }
        catch (HyracksDataException e) {
            throw new ACIDException((Throwable)e);
        }
        TxnId txnId = this.createTxnId();
        this.metadataNode.beginTransaction(txnId);
        return new MetadataTransactionContext(txnId);
    }

    @Override
    public void commitTransaction(MetadataTransactionContext ctx) {
        try {
            this.metadataNode.commitTransaction(ctx.getTxnId());
            this.cache.commit(ctx);
        }
        catch (Throwable th) {
            LOGGER.fatal("Failure committing a metadata transaction", th);
            ExitUtil.halt((int)6);
        }
    }

    @Override
    public void abortTransaction(MetadataTransactionContext ctx) {
        try {
            this.metadataNode.abortTransaction(ctx.getTxnId());
        }
        catch (Throwable th) {
            LOGGER.fatal("Failure aborting a metadata transaction", th);
            ExitUtil.halt((int)7);
        }
    }

    @Override
    public void addDataverse(MetadataTransactionContext ctx, Dataverse dataverse) throws AlgebricksException {
        try {
            this.metadataNode.addDataverse(ctx.getTxnId(), dataverse);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addDataverse(dataverse);
    }

    @Override
    public void dropDataverse(MetadataTransactionContext ctx, DataverseName dataverseName) throws AlgebricksException {
        try {
            this.metadataNode.dropDataverse(ctx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataverse(dataverseName);
    }

    @Override
    public boolean isDataverseNotEmpty(MetadataTransactionContext ctx, DataverseName dataverseName) throws AlgebricksException {
        try {
            return this.metadataNode.isDataverseNotEmpty(ctx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<Dataverse> getDataverses(MetadataTransactionContext ctx) throws AlgebricksException {
        try {
            return this.metadataNode.getDataverses(ctx.getTxnId());
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public Dataverse getDataverse(MetadataTransactionContext ctx, DataverseName dataverseName) throws AlgebricksException {
        Dataverse dataverse = ctx.getDataverse(dataverseName);
        if (dataverse != null) {
            return dataverse;
        }
        if (ctx.dataverseIsDropped(dataverseName)) {
            return null;
        }
        dataverse = this.cache.getDataverse(dataverseName);
        if (dataverse != null) {
            return dataverse;
        }
        try {
            dataverse = this.metadataNode.getDataverse(ctx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (dataverse != null) {
            ctx.addDataverse(dataverse);
        }
        return dataverse;
    }

    @Override
    public List<Dataset> getDataverseDatasets(MetadataTransactionContext ctx, DataverseName dataverseName) throws AlgebricksException {
        List<Dataset> dataverseDatasets;
        try {
            dataverseDatasets = this.metadataNode.getDataverseDatasets(ctx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return dataverseDatasets;
    }

    @Override
    public void addDataset(MetadataTransactionContext ctx, Dataset dataset) throws AlgebricksException {
        try {
            this.metadataNode.addDataset(ctx.getTxnId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addDataset(dataset);
    }

    @Override
    public void dropDataset(MetadataTransactionContext ctx, DataverseName dataverseName, String datasetName, boolean force) throws AlgebricksException {
        try {
            this.metadataNode.dropDataset(ctx.getTxnId(), dataverseName, datasetName, force);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataset(dataverseName, datasetName);
    }

    @Override
    public Dataset getDataset(MetadataTransactionContext ctx, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        Dataset dataset = ctx.getDataset(dataverseName, datasetName);
        if (dataset != null) {
            return dataset;
        }
        if (ctx.datasetIsDropped(dataverseName, datasetName)) {
            return null;
        }
        dataset = this.cache.getDataset(dataverseName, datasetName);
        if (dataset != null) {
            return dataset;
        }
        try {
            dataset = this.metadataNode.getDataset(ctx.getTxnId(), dataverseName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (dataset != null) {
            ctx.addDataset(dataset);
        }
        return dataset;
    }

    @Override
    public List<Index> getDatasetIndexes(MetadataTransactionContext ctx, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        List<Index> datasetIndexes;
        Dataset dataset = this.getDataset(ctx, dataverseName, datasetName);
        if (dataset == null) {
            return Collections.emptyList();
        }
        try {
            datasetIndexes = this.metadataNode.getDatasetIndexes(ctx.getTxnId(), dataverseName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return datasetIndexes;
    }

    @Override
    public void addCompactionPolicy(MetadataTransactionContext mdTxnCtx, CompactionPolicy compactionPolicy) throws AlgebricksException {
        try {
            this.metadataNode.addCompactionPolicy(mdTxnCtx.getTxnId(), compactionPolicy);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addCompactionPolicy(compactionPolicy);
    }

    @Override
    public CompactionPolicy getCompactionPolicy(MetadataTransactionContext ctx, DataverseName dataverse, String policyName) throws AlgebricksException {
        CompactionPolicy compactionPolicy;
        try {
            compactionPolicy = this.metadataNode.getCompactionPolicy(ctx.getTxnId(), dataverse, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return compactionPolicy;
    }

    @Override
    public void addDatatype(MetadataTransactionContext ctx, Datatype datatype) throws AlgebricksException {
        try {
            this.metadataNode.addDatatype(ctx.getTxnId(), datatype);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        try {
            ctx.addDatatype(this.metadataNode.getDatatype(ctx.getTxnId(), datatype.getDataverseName(), datatype.getDatatypeName()));
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropDatatype(MetadataTransactionContext ctx, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        try {
            this.metadataNode.dropDatatype(ctx.getTxnId(), dataverseName, datatypeName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataDatatype(dataverseName, datatypeName);
    }

    @Override
    public Datatype getDatatype(MetadataTransactionContext ctx, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        Datatype datatype = ctx.getDatatype(dataverseName, datatypeName);
        if (datatype != null) {
            return datatype;
        }
        if (ctx.datatypeIsDropped(dataverseName, datatypeName)) {
            return null;
        }
        datatype = this.cache.getDatatype(dataverseName, datatypeName);
        if (datatype != null) {
            return datatype;
        }
        try {
            datatype = this.metadataNode.getDatatype(ctx.getTxnId(), dataverseName, datatypeName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (datatype != null) {
            ctx.addDatatype(datatype);
        }
        return datatype;
    }

    @Override
    public void addIndex(MetadataTransactionContext ctx, Index index) throws AlgebricksException {
        try {
            this.metadataNode.addIndex(ctx.getTxnId(), index);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addIndex(index);
    }

    @Override
    public void addAdapter(MetadataTransactionContext mdTxnCtx, DatasourceAdapter adapter) throws AlgebricksException {
        try {
            this.metadataNode.addAdapter(mdTxnCtx.getTxnId(), adapter);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addAdapter(adapter);
    }

    @Override
    public void dropIndex(MetadataTransactionContext ctx, DataverseName dataverseName, String datasetName, String indexName) throws AlgebricksException {
        try {
            this.metadataNode.dropIndex(ctx.getTxnId(), dataverseName, datasetName, indexName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropIndex(dataverseName, datasetName, indexName);
    }

    @Override
    public Index getIndex(MetadataTransactionContext ctx, DataverseName dataverseName, String datasetName, String indexName) throws AlgebricksException {
        Index index = ctx.getIndex(dataverseName, datasetName, indexName);
        if (index != null) {
            return index;
        }
        if (ctx.indexIsDropped(dataverseName, datasetName, indexName)) {
            return null;
        }
        index = this.cache.getIndex(dataverseName, datasetName, indexName);
        if (index != null) {
            return index;
        }
        try {
            index = this.metadataNode.getIndex(ctx.getTxnId(), dataverseName, datasetName, indexName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (index != null) {
            ctx.addIndex(index);
        }
        return index;
    }

    @Override
    public void addNode(MetadataTransactionContext ctx, Node node) throws AlgebricksException {
        try {
            this.metadataNode.addNode(ctx.getTxnId(), node);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void addNodegroup(MetadataTransactionContext ctx, NodeGroup nodeGroup) throws AlgebricksException {
        this.modifyNodegroup(ctx, nodeGroup, AbstractIndexModificationOperationCallback.Operation.INSERT);
    }

    @Override
    public void upsertNodegroup(MetadataTransactionContext ctx, NodeGroup nodeGroup) throws AlgebricksException {
        this.modifyNodegroup(ctx, nodeGroup, AbstractIndexModificationOperationCallback.Operation.UPSERT);
    }

    private void modifyNodegroup(MetadataTransactionContext ctx, NodeGroup nodeGroup, AbstractIndexModificationOperationCallback.Operation op) throws AlgebricksException {
        try {
            this.metadataNode.modifyNodeGroup(ctx.getTxnId(), nodeGroup, op);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addNodeGroup(nodeGroup);
    }

    @Override
    public void dropNodegroup(MetadataTransactionContext ctx, String nodeGroupName, boolean failSilently) throws AlgebricksException {
        boolean dropped;
        try {
            dropped = this.metadataNode.dropNodegroup(ctx.getTxnId(), nodeGroupName, failSilently);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (dropped) {
            ctx.dropNodeGroup(nodeGroupName);
        }
    }

    @Override
    public NodeGroup getNodegroup(MetadataTransactionContext ctx, String nodeGroupName) throws AlgebricksException {
        NodeGroup nodeGroup = ctx.getNodeGroup(nodeGroupName);
        if (nodeGroup != null) {
            return nodeGroup;
        }
        if (ctx.nodeGroupIsDropped(nodeGroupName)) {
            return null;
        }
        nodeGroup = this.cache.getNodeGroup(nodeGroupName);
        if (nodeGroup != null) {
            return nodeGroup;
        }
        try {
            nodeGroup = this.metadataNode.getNodeGroup(ctx.getTxnId(), nodeGroupName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (nodeGroup != null) {
            ctx.addNodeGroup(nodeGroup);
        }
        return nodeGroup;
    }

    @Override
    public void addFunction(MetadataTransactionContext mdTxnCtx, Function function) throws AlgebricksException {
        try {
            this.metadataNode.addFunction(mdTxnCtx.getTxnId(), function);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFunction(function);
    }

    @Override
    public void dropFunction(MetadataTransactionContext ctx, FunctionSignature functionSignature) throws AlgebricksException {
        try {
            this.metadataNode.dropFunction(ctx.getTxnId(), functionSignature);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFunction(functionSignature);
    }

    @Override
    public Function getFunction(MetadataTransactionContext ctx, FunctionSignature functionSignature) throws AlgebricksException {
        Function function = ctx.getFunction(functionSignature);
        if (function != null) {
            return function;
        }
        if (ctx.functionIsDropped(functionSignature)) {
            return null;
        }
        if (ctx.getDataverse(functionSignature.getDataverseName()) != null) {
            return null;
        }
        function = this.cache.getFunction(functionSignature);
        if (function != null) {
            return function;
        }
        try {
            function = this.metadataNode.getFunction(ctx.getTxnId(), functionSignature);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (function != null) {
            ctx.addFunction(function);
        }
        return function;
    }

    @Override
    public List<Function> getDataverseFunctions(MetadataTransactionContext ctx, DataverseName dataverseName) throws AlgebricksException {
        try {
            return this.metadataNode.getDataverseFunctions(ctx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void addFullTextFilter(MetadataTransactionContext mdTxnCtx, FullTextFilterMetadataEntity filter) throws AlgebricksException {
        try {
            this.metadataNode.addFullTextFilter(mdTxnCtx.getTxnId(), filter);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFullTextFilter(filter);
    }

    @Override
    public void dropFullTextFilter(MetadataTransactionContext mdTxnCtx, DataverseName dataverseName, String filterName) throws AlgebricksException {
        try {
            this.metadataNode.dropFullTextFilter(mdTxnCtx.getTxnId(), dataverseName, filterName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.dropFullTextFilter(dataverseName, filterName);
    }

    @Override
    public FullTextFilterMetadataEntity getFullTextFilter(MetadataTransactionContext ctx, DataverseName dataverseName, String filterName) throws AlgebricksException {
        FullTextFilterMetadataEntity filter = ctx.getFullTextFilter(dataverseName, filterName);
        if (filter != null) {
            return filter;
        }
        if (ctx.fullTextFilterIsDropped(dataverseName, filterName)) {
            return null;
        }
        if (ctx.getDataverse(dataverseName) != null) {
            return null;
        }
        filter = this.cache.getFullTextFilter(dataverseName, filterName);
        if (filter != null) {
            return filter;
        }
        try {
            filter = this.metadataNode.getFullTextFilter(ctx.getTxnId(), dataverseName, filterName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (filter != null) {
            ctx.addFullTextFilter(filter);
        }
        return filter;
    }

    @Override
    public void addFullTextConfig(MetadataTransactionContext mdTxnCtx, FullTextConfigMetadataEntity configMetadataEntity) throws AlgebricksException {
        if (Strings.isNullOrEmpty((String)configMetadataEntity.getFullTextConfig().getName())) {
            throw new MetadataException(ErrorCode.FULL_TEXT_CONFIG_ALREADY_EXISTS, new Serializable[0]);
        }
        try {
            this.metadataNode.addFullTextConfig(mdTxnCtx.getTxnId(), configMetadataEntity);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFullTextConfig(configMetadataEntity);
    }

    @Override
    public FullTextConfigMetadataEntity getFullTextConfig(MetadataTransactionContext ctx, DataverseName dataverseName, String configName) throws AlgebricksException {
        FullTextConfigMetadataEntity configMetadataEntity = ctx.getFullTextConfig(dataverseName, configName);
        if (configMetadataEntity != null) {
            return configMetadataEntity;
        }
        if (ctx.fullTextConfigIsDropped(dataverseName, configName)) {
            return null;
        }
        if (ctx.getDataverse(dataverseName) != null) {
            return null;
        }
        configMetadataEntity = this.cache.getFullTextConfig(dataverseName, configName);
        if (configMetadataEntity != null) {
            return configMetadataEntity;
        }
        try {
            configMetadataEntity = this.metadataNode.getFullTextConfig(ctx.getTxnId(), dataverseName, configName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (configMetadataEntity != null) {
            ctx.addFullTextConfig(configMetadataEntity);
        }
        return configMetadataEntity;
    }

    @Override
    public void dropFullTextConfig(MetadataTransactionContext mdTxnCtx, DataverseName dataverseName, String configName) throws AlgebricksException {
        try {
            this.metadataNode.dropFullTextConfig(mdTxnCtx.getTxnId(), dataverseName, configName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.dropFullTextConfig(dataverseName, configName);
    }

    @Override
    public void addFeedPolicy(MetadataTransactionContext mdTxnCtx, FeedPolicyEntity feedPolicy) throws AlgebricksException {
        try {
            this.metadataNode.addFeedPolicy(mdTxnCtx.getTxnId(), feedPolicy);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFeedPolicy(feedPolicy);
    }

    @Override
    public void initializeDatasetIdFactory(MetadataTransactionContext ctx) throws AlgebricksException {
        try {
            this.metadataNode.initializeDatasetIdFactory(ctx.getTxnId());
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public int getMostRecentDatasetId() throws AlgebricksException {
        try {
            return this.metadataNode.getMostRecentDatasetId();
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropAdapter(MetadataTransactionContext ctx, DataverseName dataverseName, String name) throws AlgebricksException {
        try {
            this.metadataNode.dropAdapter(ctx.getTxnId(), dataverseName, name);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropAdapter(dataverseName, name);
    }

    @Override
    public DatasourceAdapter getAdapter(MetadataTransactionContext ctx, DataverseName dataverseName, String name) throws AlgebricksException {
        DatasourceAdapter adapter;
        try {
            adapter = this.metadataNode.getAdapter(ctx.getTxnId(), dataverseName, name);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return adapter;
    }

    @Override
    public void dropLibrary(MetadataTransactionContext ctx, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        try {
            this.metadataNode.dropLibrary(ctx.getTxnId(), dataverseName, libraryName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropLibrary(dataverseName, libraryName);
    }

    @Override
    public List<Library> getDataverseLibraries(MetadataTransactionContext ctx, DataverseName dataverseName) throws AlgebricksException {
        List<Library> dataverseLibaries;
        try {
            dataverseLibaries = this.metadataNode.getDataverseLibraries(ctx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return dataverseLibaries;
    }

    @Override
    public void addLibrary(MetadataTransactionContext ctx, Library library) throws AlgebricksException {
        try {
            this.metadataNode.addLibrary(ctx.getTxnId(), library);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addLibrary(library);
    }

    @Override
    public Library getLibrary(MetadataTransactionContext ctx, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        Library library;
        try {
            library = this.metadataNode.getLibrary(ctx.getTxnId(), dataverseName, libraryName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return library;
    }

    @Override
    public FeedPolicyEntity getFeedPolicy(MetadataTransactionContext ctx, DataverseName dataverseName, String policyName) throws AlgebricksException {
        FeedPolicyEntity feedPolicy;
        try {
            feedPolicy = this.metadataNode.getFeedPolicy(ctx.getTxnId(), dataverseName, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return feedPolicy;
    }

    @Override
    public Feed getFeed(MetadataTransactionContext ctx, DataverseName dataverseName, String feedName) throws AlgebricksException {
        Feed feed;
        try {
            feed = this.metadataNode.getFeed(ctx.getTxnId(), dataverseName, feedName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return feed;
    }

    @Override
    public List<Feed> getFeeds(MetadataTransactionContext ctx, DataverseName dataverseName) throws AlgebricksException {
        List<Feed> feeds;
        try {
            feeds = this.metadataNode.getFeeds(ctx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return feeds;
    }

    @Override
    public void dropFeed(MetadataTransactionContext ctx, DataverseName dataverseName, String feedName) throws AlgebricksException {
        Feed feed;
        try {
            feed = this.metadataNode.getFeed(ctx.getTxnId(), dataverseName, feedName);
            List<FeedConnection> feedConnections = this.metadataNode.getFeedConnections(ctx.getTxnId(), dataverseName, feedName);
            this.metadataNode.dropFeed(ctx.getTxnId(), dataverseName, feedName);
            for (FeedConnection feedConnection : feedConnections) {
                this.metadataNode.dropFeedConnection(ctx.getTxnId(), dataverseName, feedName, feedConnection.getDatasetName());
                ctx.dropFeedConnection(dataverseName, feedName, feedConnection.getDatasetName());
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFeed(feed);
    }

    @Override
    public void addFeed(MetadataTransactionContext ctx, Feed feed) throws AlgebricksException {
        try {
            this.metadataNode.addFeed(ctx.getTxnId(), feed);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addFeed(feed);
    }

    @Override
    public void addFeedConnection(MetadataTransactionContext ctx, FeedConnection feedConnection) throws AlgebricksException {
        try {
            this.metadataNode.addFeedConnection(ctx.getTxnId(), feedConnection);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addFeedConnection(feedConnection);
    }

    @Override
    public void dropFeedConnection(MetadataTransactionContext ctx, DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        try {
            this.metadataNode.dropFeedConnection(ctx.getTxnId(), dataverseName, feedName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFeedConnection(dataverseName, feedName, datasetName);
    }

    @Override
    public FeedConnection getFeedConnection(MetadataTransactionContext ctx, DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        try {
            return this.metadataNode.getFeedConnection(ctx.getTxnId(), dataverseName, feedName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<FeedConnection> getFeedConections(MetadataTransactionContext ctx, DataverseName dataverseName, String feedName) throws AlgebricksException {
        try {
            return this.metadataNode.getFeedConnections(ctx.getTxnId(), dataverseName, feedName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<DatasourceAdapter> getDataverseAdapters(MetadataTransactionContext mdTxnCtx, DataverseName dataverseName) throws AlgebricksException {
        List<DatasourceAdapter> dataverseAdapters;
        try {
            dataverseAdapters = this.metadataNode.getDataverseAdapters(mdTxnCtx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return dataverseAdapters;
    }

    @Override
    public void dropFeedPolicy(MetadataTransactionContext mdTxnCtx, DataverseName dataverseName, String policyName) throws AlgebricksException {
        FeedPolicyEntity feedPolicy;
        try {
            feedPolicy = this.metadataNode.getFeedPolicy(mdTxnCtx.getTxnId(), dataverseName, policyName);
            this.metadataNode.dropFeedPolicy(mdTxnCtx.getTxnId(), dataverseName, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.dropFeedPolicy(feedPolicy);
    }

    @Override
    public List<FeedPolicyEntity> getDataverseFeedPolicies(MetadataTransactionContext mdTxnCtx, DataverseName dataverseName) throws AlgebricksException {
        List<FeedPolicyEntity> dataverseFeedPolicies;
        try {
            dataverseFeedPolicies = this.metadataNode.getDataverseFeedPolicies(mdTxnCtx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return dataverseFeedPolicies;
    }

    @Override
    public List<ExternalFile> getDatasetExternalFiles(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws AlgebricksException {
        List<ExternalFile> externalFiles;
        try {
            externalFiles = this.metadataNode.getExternalFiles(mdTxnCtx.getTxnId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return externalFiles;
    }

    @Override
    public void addExternalFile(MetadataTransactionContext ctx, ExternalFile externalFile) throws AlgebricksException {
        try {
            this.metadataNode.addExternalFile(ctx.getTxnId(), externalFile);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropExternalFile(MetadataTransactionContext ctx, ExternalFile externalFile) throws AlgebricksException {
        try {
            this.metadataNode.dropExternalFile(ctx.getTxnId(), externalFile.getDataverseName(), externalFile.getDatasetName(), externalFile.getFileNumber());
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public ExternalFile getExternalFile(MetadataTransactionContext ctx, DataverseName dataverseName, String datasetName, Integer fileNumber) throws AlgebricksException {
        ExternalFile file;
        try {
            file = this.metadataNode.getExternalFile(ctx.getTxnId(), dataverseName, datasetName, fileNumber);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return file;
    }

    @Override
    public void addSynonym(MetadataTransactionContext ctx, Synonym synonym) throws AlgebricksException {
        try {
            this.metadataNode.addSynonym(ctx.getTxnId(), synonym);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropSynonym(MetadataTransactionContext ctx, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        try {
            this.metadataNode.dropSynonym(ctx.getTxnId(), dataverseName, synonymName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public Synonym getSynonym(MetadataTransactionContext ctx, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        try {
            return this.metadataNode.getSynonym(ctx.getTxnId(), dataverseName, synonymName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<Synonym> getDataverseSynonyms(MetadataTransactionContext ctx, DataverseName dataverseName) throws AlgebricksException {
        try {
            return this.metadataNode.getDataverseSynonyms(ctx.getTxnId(), dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropDatasetExternalFiles(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws AlgebricksException {
        try {
            this.metadataNode.dropExternalFiles(mdTxnCtx.getTxnId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void updateDataset(MetadataTransactionContext ctx, Dataset dataset) throws AlgebricksException {
        try {
            this.metadataNode.updateDataset(ctx.getTxnId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataset(dataset.getDataverseName(), dataset.getDatasetName());
        ctx.addDataset(dataset);
    }

    @Override
    public void updateLibrary(MetadataTransactionContext ctx, Library library) throws AlgebricksException {
        try {
            this.metadataNode.updateLibrary(ctx.getTxnId(), library);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropLibrary(library.getDataverseName(), library.getName());
        ctx.addLibrary(library);
    }

    @Override
    public void updateFunction(MetadataTransactionContext ctx, Function function) throws AlgebricksException {
        try {
            this.metadataNode.updateFunction(ctx.getTxnId(), function);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFunction(function.getSignature());
        ctx.addFunction(function);
    }

    @Override
    public void updateDatatype(MetadataTransactionContext ctx, Datatype datatype) throws AlgebricksException {
        try {
            this.metadataNode.updateDatatype(ctx.getTxnId(), datatype);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataDatatype(datatype.getDataverseName(), datatype.getDatatypeName());
        ctx.addDatatype(datatype);
    }

    @Override
    public <T extends IExtensionMetadataEntity> void addEntity(MetadataTransactionContext mdTxnCtx, T entity) throws AlgebricksException {
        try {
            this.metadataNode.addEntity(mdTxnCtx.getTxnId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void upsertEntity(MetadataTransactionContext mdTxnCtx, T entity) throws AlgebricksException {
        try {
            this.metadataNode.upsertEntity(mdTxnCtx.getTxnId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void deleteEntity(MetadataTransactionContext mdTxnCtx, T entity) throws AlgebricksException {
        try {
            this.metadataNode.deleteEntity(mdTxnCtx.getTxnId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> List<T> getEntities(MetadataTransactionContext mdTxnCtx, IExtensionMetadataSearchKey searchKey) throws AlgebricksException {
        try {
            return this.metadataNode.getEntities(mdTxnCtx.getTxnId(), searchKey);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void rebindMetadataNode() {
        this.rebindMetadataNode = true;
    }

    public static void initialize(IAsterixStateProxy proxy, MetadataProperties metadataProperties, ICcApplicationContext appCtx) {
        INSTANCE = new CCMetadataManagerImpl(proxy, metadataProperties, appCtx);
    }

    public static void initialize(Collection<IAsterixStateProxy> proxies, MetadataNode metadataNode) {
        INSTANCE = new NCMetadataManagerImpl(proxies, metadataNode);
    }

    private static class CCMetadataManagerImpl
    extends MetadataManager {
        private final MetadataProperties metadataProperties;
        private final ICcApplicationContext appCtx;

        CCMetadataManagerImpl(IAsterixStateProxy proxy, MetadataProperties metadataProperties, ICcApplicationContext appCtx) {
            super(Collections.singleton(proxy));
            this.metadataProperties = metadataProperties;
            this.appCtx = appCtx;
        }

        @Override
        protected TxnId createTxnId() {
            TxnId txnId;
            try {
                txnId = this.appCtx.getTxnIdFactory().create();
            }
            catch (AlgebricksException e) {
                throw new ACIDException((Throwable)e);
            }
            return txnId;
        }

        @Override
        public long getMaxTxnId() {
            return this.appCtx.getTxnIdFactory().getMaxTxnId();
        }

        @Override
        public synchronized void init() throws HyracksDataException {
            if (this.metadataNode != null && !this.rebindMetadataNode) {
                return;
            }
            try {
                this.metadataNode = ((IAsterixStateProxy)this.proxies.iterator().next()).waitForMetadataNode(this.metadataProperties.getRegistrationTimeoutSecs(), TimeUnit.SECONDS);
                if (this.metadataNode == null) {
                    throw new HyracksDataException("The MetadataNode failed to bind before the configured timeout (" + this.metadataProperties.getRegistrationTimeoutSecs() + " seconds); the MetadataNode was configured to run on NC: " + this.metadataProperties.getMetadataNodeName());
                }
                this.rebindMetadataNode = false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
            catch (RemoteException e) {
                throw new RuntimeDataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
            }
            super.init();
        }
    }

    private static class NCMetadataManagerImpl
    extends MetadataManager {
        private final ITxnIdFactory txnIdFactory;

        NCMetadataManagerImpl(Collection<IAsterixStateProxy> proxies, MetadataNode metadataNode) {
            super(proxies, metadataNode);
            this.txnIdFactory = metadataNode.getTxnIdFactory();
        }

        @Override
        protected TxnId createTxnId() {
            try {
                return this.txnIdFactory.create();
            }
            catch (AlgebricksException e) {
                throw new ACIDException((Throwable)e);
            }
        }

        @Override
        public long getMaxTxnId() {
            return this.txnIdFactory.getMaxTxnId();
        }
    }
}

