/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.AbstractNumericArithmeticEval;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;

@MissingNullInOutFunction
public class NumericMultiplyDescriptor
extends AbstractNumericArithmeticEval {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new NumericMultiplyDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_MULTIPLY;
    }

    @Override
    protected boolean evaluateInteger(long lhs, long rhs, AMutableInt64 result) throws HyracksDataException {
        try {
            long res = Math.multiplyExact(lhs, rhs);
            result.setValue(res);
            return true;
        }
        catch (ArithmeticException e) {
            throw new OverflowException(this.sourceLoc, this.getIdentifier());
        }
    }

    @Override
    protected boolean evaluateDouble(double lhs, double rhs, AMutableDouble result) throws HyracksDataException {
        double res = lhs * rhs;
        result.setValue(res);
        return true;
    }

    @Override
    protected boolean evaluateTimeDurationArithmetic(long chronon, int yearMonth, long dayTime, boolean isTimeOnly, AMutableInt64 result, IEvaluatorContext ctx) throws HyracksDataException {
        ExceptionUtil.warnUnsupportedType((IEvaluatorContext)ctx, (SourceLocation)this.sourceLoc, (String)this.getIdentifier().getName(), (ATypeTag)ATypeTag.DURATION);
        return false;
    }

    @Override
    protected boolean evaluateTimeInstanceArithmetic(long chronon0, long chronon1, AMutableInt64 result, IEvaluatorContext ctx) throws HyracksDataException {
        ExceptionUtil.warnUnsupportedType((IEvaluatorContext)ctx, (SourceLocation)this.sourceLoc, (String)this.getIdentifier().getName(), (ATypeTag)ATypeTag.TIME);
        return false;
    }
}

