/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.aggregates;

import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AGeometrySerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AGeometry;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class STUnionAggregateFunction
extends AbstractAggregateFunction {
    public static final SpatialReference DEFAULT_CRS = SpatialReference.create((int)4326);
    private ISerializerDeserializer<AGeometry> geometrySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AGEOMETRY);
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;
    protected OGCGeometry geometry;
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();

    public STUnionAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, SourceLocation sourceLoc) throws HyracksDataException {
        super(sourceLoc);
        this.eval = args[0].createScalarEvaluator(context);
    }

    public void init() throws HyracksDataException {
        this.geometry = new OGCPoint(new Point(), DEFAULT_CRS);
    }

    public void step(IFrameTupleReference tuple) throws HyracksDataException {
        this.eval.evaluate(tuple, this.inputVal);
        byte[] data = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        int len = this.inputVal.getLength();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.inputVal.getByteArray()[this.inputVal.getStartOffset()]);
        if (typeTag == ATypeTag.NULL || typeTag == ATypeTag.MISSING) {
            this.processNull();
        } else if (typeTag == ATypeTag.GEOMETRY) {
            DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(data, offset + 1, len - 1));
            OGCGeometry geometry1 = AGeometrySerializerDeserializer.INSTANCE.deserialize((DataInput)dataIn).getGeometry();
            this.geometry = this.geometry.union(geometry1);
        }
    }

    public void finish(IPointable resultPointable) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            this.geometrySerde.serialize((Object)new AGeometry(this.geometry), this.resultStorage.getDataOutput());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        resultPointable.set((IValueReference)this.resultStorage);
    }

    public void finishPartial(IPointable resultPointable) throws HyracksDataException {
        this.finish(resultPointable);
    }

    protected void processNull() throws UnsupportedItemTypeException {
        throw new UnsupportedItemTypeException(this.sourceLoc, BuiltinFunctions.ST_UNION, ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
    }
}

