/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.VariableCheckAndRewriteVisitor;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

class Sql92AggregateFunctionVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    private final LangRewritingContext context;
    private final Expression groupVar;
    private final Map<VariableExpr, Identifier> groupVarFieldMap;
    private final Collection<VariableExpr> preGroupContextVars;
    private final Collection<VariableExpr> preGroupUnmappedVars;
    private final Collection<VariableExpr> outerVars;

    Sql92AggregateFunctionVisitor(LangRewritingContext context, VariableExpr groupVar, Map<VariableExpr, Identifier> groupVarFieldMap, Collection<VariableExpr> preGroupContextVars, Collection<VariableExpr> preGroupUnmappedVars, Collection<VariableExpr> outerVars) {
        this.context = context;
        this.groupVar = groupVar;
        this.groupVarFieldMap = groupVarFieldMap;
        this.preGroupContextVars = preGroupContextVars;
        this.preGroupUnmappedVars = preGroupUnmappedVars;
        this.outerVars = outerVars;
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature signature = callExpr.getFunctionSignature();
        if (FunctionMapUtil.isSql92AggregateFunction(signature)) {
            this.rewriteSql92AggregateFunction(callExpr, arg);
            return callExpr;
        }
        return super.visit(callExpr, arg);
    }

    private void rewriteSql92AggregateFunction(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature signature = callExpr.getFunctionSignature();
        List argList = callExpr.getExprList();
        if (argList.size() != 1) {
            throw new CompilationException(ErrorCode.COMPILATION_INVALID_PARAMETER_NUMBER, callExpr.getSourceLocation(), new Serializable[]{signature.getName(), Integer.valueOf(argList.size())});
        }
        Expression filterExpr = callExpr.getAggregateFilterExpr();
        Expression expr = (Expression)argList.get(0);
        Expression newExpr = Sql92AggregateFunctionVisitor.wrapAggregationArgument(expr, filterExpr, this.groupVar, this.groupVarFieldMap, this.preGroupContextVars, this.preGroupUnmappedVars, this.outerVars, this.context);
        ArrayList<Expression> newExprList = new ArrayList<Expression>(1);
        newExprList.add((Expression)newExpr.accept((ILangVisitor)this, (Object)arg));
        callExpr.setFunctionSignature(FunctionMapUtil.sql92ToCoreAggregateFunction(signature));
        callExpr.setExprList(newExprList);
        callExpr.setAggregateFilterExpr(null);
    }

    static Expression wrapAggregationArgument(Expression expr, Expression filterExpr, Expression groupVar, Map<VariableExpr, Identifier> groupVarFieldMap, Collection<VariableExpr> preGroupContextVars, Collection<VariableExpr> preGroupUnmappedVars, Collection<VariableExpr> outerVars, LangRewritingContext context) throws CompilationException {
        SourceLocation sourceLoc = expr.getSourceLocation();
        VariableExpr groupItemVar = new VariableExpr(context.newVariable());
        groupItemVar.setSourceLocation(sourceLoc);
        FromTerm fromTerm = new FromTerm(groupVar, groupItemVar, null, null);
        fromTerm.setSourceLocation(sourceLoc);
        FromClause fromClause = new FromClause(Collections.singletonList(fromTerm));
        fromClause.setSourceLocation(sourceLoc);
        ArrayList<AbstractClause> whereClauseList = null;
        if (filterExpr != null) {
            Expression newFilterExpr = Sql92AggregateFunctionVisitor.rewriteAggregationArgumentExpr(filterExpr, groupItemVar, groupVarFieldMap, preGroupContextVars, preGroupUnmappedVars, outerVars, context);
            WhereClause whereClause = new WhereClause(newFilterExpr);
            whereClause.setSourceLocation(sourceLoc);
            whereClauseList = new ArrayList<AbstractClause>(1);
            whereClauseList.add((AbstractClause)whereClause);
        }
        Expression newExpr = Sql92AggregateFunctionVisitor.rewriteAggregationArgumentExpr(expr, groupItemVar, groupVarFieldMap, preGroupContextVars, preGroupUnmappedVars, outerVars, context);
        SelectElement selectElement = new SelectElement(newExpr);
        selectElement.setSourceLocation(sourceLoc);
        SelectClause selectClause = new SelectClause(selectElement, null, false);
        selectClause.setSourceLocation(sourceLoc);
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, whereClauseList, null, null);
        selectBlock.setSourceLocation(sourceLoc);
        SelectSetOperation selectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
        selectSetOperation.setSourceLocation(sourceLoc);
        SelectExpression selectExpr = new SelectExpression(null, selectSetOperation, null, null, true);
        selectExpr.setSourceLocation(sourceLoc);
        return selectExpr;
    }

    private static Expression rewriteAggregationArgumentExpr(Expression expr, VariableExpr groupItemVar, Map<VariableExpr, Identifier> groupVarFieldMap, Collection<VariableExpr> preGroupContextVars, Collection<VariableExpr> preGroupUnmappedVars, Collection<VariableExpr> outerVars, LangRewritingContext context) throws CompilationException {
        Set<VariableExpr> freeVars = SqlppRewriteUtil.getFreeVariable(expr);
        HashMap<VariableExpr, FieldAccessor> varExprMap = new HashMap<VariableExpr, FieldAccessor>();
        for (VariableExpr usedVar : freeVars) {
            if (groupVarFieldMap.containsKey(usedVar)) {
                FieldAccessor fa = new FieldAccessor((Expression)groupItemVar, (Identifier)new VarIdentifier(groupVarFieldMap.get(usedVar).getValue()));
                fa.setSourceLocation(usedVar.getSourceLocation());
                varExprMap.put(usedVar, fa);
                continue;
            }
            if (outerVars.contains(usedVar)) continue;
            if (preGroupUnmappedVars != null && preGroupUnmappedVars.contains(usedVar)) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_USE_OF_IDENTIFIER, expr.getSourceLocation(), new Serializable[]{SqlppVariableUtil.toUserDefinedVariableName(usedVar.getVar().getValue()).getValue()});
            }
            VariableExpr preGroupVar = VariableCheckAndRewriteVisitor.pickContextVar(preGroupContextVars, usedVar);
            Identifier groupVarField = groupVarFieldMap.get(preGroupVar);
            if (groupVarField == null) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, expr.getSourceLocation(), new Serializable[0]);
            }
            FieldAccessor faInner = new FieldAccessor((Expression)groupItemVar, groupVarField);
            faInner.setSourceLocation(usedVar.getSourceLocation());
            FieldAccessor faOuter = VariableCheckAndRewriteVisitor.generateFieldAccess((Expression)faInner, usedVar.getVar(), usedVar.getSourceLocation());
            varExprMap.put(usedVar, faOuter);
        }
        return SqlppRewriteUtil.substituteExpression(expr, varExprMap, context);
    }
}

