/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;
import org.apache.hyracks.data.std.util.DataUtils;

public final class ShortPointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    private static final int SIZE = 2;
    public static final ITypeTraits TYPE_TRAITS = new FixedLengthTypeTrait(2);
    public static final IPointableFactory FACTORY = new ShortPointableFactory();

    public static short getShort(byte[] bytes, int start) {
        return (short)(((bytes[start] & 0xFF) << 8) + (bytes[start + 1] & 0xFF));
    }

    public static void setShort(byte[] bytes, int start, short value) {
        bytes[start] = (byte)(value >>> 8 & 0xFF);
        bytes[start + 1] = (byte)(value >>> 0 & 0xFF);
    }

    public short getShort() {
        return ShortPointable.getShort(this.bytes, this.start);
    }

    public void setShort(short value) {
        ShortPointable.setShort(this.bytes, this.start, value);
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        return ShortPointable.compare(this.bytes, this.start, this.length, bytes, start, length);
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        DataUtils.ensureLengths(2, l1, l2);
        return Short.compare(ShortPointable.getShort(b1, s1), ShortPointable.getShort(b2, s2));
    }

    @Override
    public int hash() {
        return this.getShort();
    }

    @Override
    public byte byteValue() {
        return (byte)this.getShort();
    }

    @Override
    public short shortValue() {
        return this.getShort();
    }

    @Override
    public int intValue() {
        return this.getShort();
    }

    @Override
    public long longValue() {
        return this.getShort();
    }

    @Override
    public float floatValue() {
        return this.getShort();
    }

    @Override
    public double doubleValue() {
        return this.getShort();
    }

    public static final class ShortPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new ShortPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

