/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.collectors;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.collectors.NonDeterministicChannelReader;

public class NonDeterministicFrameReader
implements IFrameReader {
    private final NonDeterministicChannelReader channelReader;

    public NonDeterministicFrameReader(NonDeterministicChannelReader channelReader) {
        this.channelReader = channelReader;
    }

    public void open() throws HyracksDataException {
        this.channelReader.open();
    }

    public boolean nextFrame(IFrame frame) throws HyracksDataException {
        int index = this.channelReader.findNextSender();
        if (index < 0) {
            return false;
        }
        frame.reset();
        ByteBuffer srcFrame = this.channelReader.getNextBuffer(index);
        int nBlocks = FrameHelper.deserializeNumOfMinFrame((ByteBuffer)srcFrame);
        frame.ensureFrameSize(frame.getMinSize() * nBlocks);
        FrameUtils.copyWholeFrame((ByteBuffer)srcFrame, (ByteBuffer)frame.getBuffer());
        this.channelReader.recycleBuffer(index, srcFrame);
        for (int i = 1; i < nBlocks; ++i) {
            srcFrame = this.channelReader.getNextBuffer(index);
            frame.getBuffer().put(srcFrame);
            this.channelReader.recycleBuffer(index, srcFrame);
        }
        if (frame.getBuffer().hasRemaining()) {
            FrameHelper.clearRemainingFrame((ByteBuffer)frame.getBuffer(), (int)frame.getBuffer().position());
        }
        frame.getBuffer().flip();
        return true;
    }

    public synchronized void close() throws HyracksDataException {
        this.channelReader.close();
    }
}

