/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;

public abstract class AbstractGroupingProperty {
    protected Set<LogicalVariable> columnSet;

    public AbstractGroupingProperty(Set<LogicalVariable> columnSet) {
        this.columnSet = columnSet;
    }

    public Set<LogicalVariable> getColumnSet() {
        return this.columnSet;
    }

    protected Set<LogicalVariable> normalizeAndReduceGroupingColumns(Set<LogicalVariable> columns, Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        Set<LogicalVariable> normalizedColumnSet = this.getNormalizedColumnsAccordingToEqClasses(columns, equivalenceClasses);
        this.reduceGroupingColumns(normalizedColumnSet, fds);
        return normalizedColumnSet;
    }

    private Set<LogicalVariable> getNormalizedColumnsAccordingToEqClasses(Set<LogicalVariable> columns, Map<LogicalVariable, EquivalenceClass> equivalenceClasses) {
        ListSet normalizedColumns = new ListSet();
        if (equivalenceClasses == null || equivalenceClasses.isEmpty()) {
            normalizedColumns.addAll(columns);
            return normalizedColumns;
        }
        for (LogicalVariable v : columns) {
            EquivalenceClass ec = equivalenceClasses.get(v);
            if (ec == null) {
                normalizedColumns.add(v);
                continue;
            }
            if (ec.representativeIsConst()) continue;
            normalizedColumns.add(ec.getVariableRepresentative());
        }
        return normalizedColumns;
    }

    private void reduceGroupingColumns(Set<LogicalVariable> columnSet, List<FunctionalDependency> fds) {
        if (fds == null || fds.isEmpty()) {
            return;
        }
        ListSet norm = new ListSet();
        for (LogicalVariable v : columnSet) {
            boolean isImpliedByAnFD = false;
            for (FunctionalDependency fdep : fds) {
                if (!columnSet.containsAll(fdep.getHead()) || !fdep.getTail().contains(v)) continue;
                isImpliedByAnFD = true;
                norm.addAll(fdep.getHead());
                break;
            }
            if (isImpliedByAnFD) continue;
            norm.add(v);
        }
        columnSet.retainAll((Collection<?>)norm);
    }
}

