/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;

public final class DataverseName
implements Serializable,
Comparable<DataverseName> {
    private static final long serialVersionUID = 3L;
    public static final String CANONICAL_FORM_PART_SEPARATOR = "/";
    public static final char DISPLAY_FORM_SEPARATOR_CHAR = '.';
    private static final char DISPLAY_FORM_QUOTE_CHAR = '`';
    private static final char DISPLAY_FORM_ESCAPE_CHAR = '\\';
    private final String canonicalForm;
    private volatile transient String displayForm;

    private DataverseName(String canonicalForm) {
        this.canonicalForm = Objects.requireNonNull(canonicalForm);
    }

    public String getCanonicalForm() {
        return this.canonicalForm;
    }

    public List<String> getParts() {
        ArrayList<String> parts = new ArrayList<String>(4);
        this.getParts(parts);
        return parts;
    }

    public void getParts(Collection<? super String> outParts) {
        DataverseName.getPartsFromCanonicalFormImpl(this.canonicalForm, outParts);
    }

    public static void getPartsFromCanonicalForm(String canonicalForm, Collection<? super String> outParts) throws AsterixException {
        int partCount = DataverseName.getPartsFromCanonicalFormImpl(canonicalForm, outParts);
        if (partCount <= 0) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, new Serializable[]{canonicalForm});
        }
    }

    public int getPartCount() {
        return DataverseName.getPartCountFromCanonicalFormImpl(this.canonicalForm);
    }

    public static int getPartCountFromCanonicalForm(String canonicalForm) throws AsterixException {
        int partCount = DataverseName.getPartCountFromCanonicalFormImpl(canonicalForm);
        if (partCount <= 0) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, new Serializable[]{canonicalForm});
        }
        return partCount;
    }

    public String toString() {
        return this.getDisplayForm();
    }

    private String getDisplayForm() {
        String result = this.displayForm;
        if (result == null) {
            StringBuilder sb = new StringBuilder(this.canonicalForm.length() + 1);
            this.getDisplayForm(sb);
            this.displayForm = result = sb.toString();
        }
        return result;
    }

    public void getDisplayForm(StringBuilder out) {
        DataverseName.getDisplayFormFromCanonicalFormImpl(this.canonicalForm, out);
    }

    public static void getDisplayFormFromCanonicalForm(String canonicalForm, StringBuilder out) throws AsterixException {
        int partCount = DataverseName.getDisplayFormFromCanonicalFormImpl(canonicalForm, out);
        if (partCount <= 0) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, new Serializable[]{canonicalForm});
        }
    }

    private static int getPartsFromCanonicalFormImpl(String canonicalForm, Collection<? super String> outParts) {
        return DataverseName.decodeCanonicalForm(canonicalForm, DataverseName::addPartToCollection, outParts);
    }

    private static int getPartCountFromCanonicalFormImpl(String canonicalForm) {
        return DataverseName.decodeCanonicalForm(canonicalForm, null, null);
    }

    private static int getDisplayFormFromCanonicalFormImpl(String canonicalForm, StringBuilder out) {
        int partCount = DataverseName.decodeCanonicalForm(canonicalForm, DataverseName::addPartToDisplayForm, out);
        if (partCount > 0) {
            out.setLength(out.length() - 1);
        }
        return partCount;
    }

    public int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataverseName)) {
            return false;
        }
        DataverseName that = (DataverseName)obj;
        return this.canonicalForm.equals(that.canonicalForm);
    }

    @Override
    public int compareTo(DataverseName that) {
        return this.canonicalForm.compareTo(that.canonicalForm);
    }

    public static DataverseName create(List<String> parts) throws AsterixException {
        return DataverseName.create(parts, 0, parts.size());
    }

    public static DataverseName create(List<String> parts, int fromIndex, int toIndex) throws AsterixException {
        int partCount = toIndex - fromIndex;
        return partCount == 1 ? DataverseName.createSinglePartName(parts.get(fromIndex)) : DataverseName.createMultiPartName(parts, fromIndex, toIndex);
    }

    public static DataverseName createFromCanonicalForm(String canonicalForm) throws AsterixException {
        int partCount = DataverseName.getPartCountFromCanonicalFormImpl(canonicalForm);
        if (partCount <= 0) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, new Serializable[]{canonicalForm});
        }
        return new DataverseName(canonicalForm);
    }

    public static DataverseName createSinglePartName(String singlePart) throws AsterixException {
        String canonicalForm = DataverseName.encodeSinglePartNamePartIntoCanonicalForm(singlePart);
        return new DataverseName(canonicalForm);
    }

    public static DataverseName createBuiltinDataverseName(String singlePart) {
        try {
            return DataverseName.createSinglePartName(singlePart);
        }
        catch (AsterixException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private static DataverseName createMultiPartName(List<String> parts, int fromIndex, int toIndex) throws AsterixException {
        String canonicalForm = DataverseName.encodeMultiPartNameIntoCanonicalForm(parts, fromIndex, toIndex);
        return new DataverseName(canonicalForm);
    }

    private static String encodeMultiPartNameIntoCanonicalForm(List<String> parts, int fromIndex, int toIndex) throws AsterixException {
        Objects.requireNonNull(parts);
        int partCount = toIndex - fromIndex;
        if (partCount <= 0) {
            throw new IllegalArgumentException(fromIndex + "," + toIndex);
        }
        int canonicalFormLength = (partCount - 1) * CANONICAL_FORM_PART_SEPARATOR.length();
        for (int i = fromIndex; i < toIndex; ++i) {
            canonicalFormLength += parts.get(i).length();
        }
        String sep = "";
        StringBuilder sb = new StringBuilder(canonicalFormLength);
        for (int i = fromIndex; i < toIndex; ++i) {
            sb.append(sep);
            DataverseName.encodePartIntoCanonicalForm(parts.get(i), sb);
            sep = CANONICAL_FORM_PART_SEPARATOR;
        }
        return sb.toString();
    }

    private static String encodeSinglePartNamePartIntoCanonicalForm(String singlePart) throws AsterixException {
        DataverseName.validatePart(singlePart);
        return singlePart;
    }

    private static void encodePartIntoCanonicalForm(String part, StringBuilder out) throws AsterixException {
        DataverseName.validatePart(part);
        out.append(part);
    }

    private static void validatePart(String part) throws AsterixException {
        if (part.isEmpty() || part.contains(CANONICAL_FORM_PART_SEPARATOR)) {
            throw new AsterixException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, new Serializable[]{part});
        }
    }

    private static <T> int decodeCanonicalForm(String canonicalForm, DataverseNamePartConsumer<T> partConsumer, T partConsumerArg) {
        boolean hasOneMore;
        int to;
        int partCount = 0;
        int from = 0;
        while ((to = canonicalForm.indexOf(CANONICAL_FORM_PART_SEPARATOR, from)) > from) {
            if (partConsumer != null) {
                partConsumer.accept(canonicalForm, from, to, partConsumerArg);
            }
            ++partCount;
            from = to + CANONICAL_FORM_PART_SEPARATOR.length();
        }
        boolean bl = hasOneMore = from != to && from < canonicalForm.length();
        if (!hasOneMore) {
            return 0;
        }
        if (partConsumer != null) {
            partConsumer.accept(canonicalForm, from, canonicalForm.length(), partConsumerArg);
        }
        return ++partCount;
    }

    private static void addPartToCollection(String canonicalForm, int from, int to, Collection<? super String> out) {
        out.add(canonicalForm.substring(from, to));
    }

    private static void addPartToDisplayForm(String canonicalForm, int from, int to, StringBuilder out) {
        char c;
        int i;
        boolean needQuote = false;
        for (i = from; i < to; ++i) {
            boolean noQuote;
            c = canonicalForm.charAt(i);
            boolean bl = noQuote = DataverseName.isLetter(c) || c == '_' || i > 0 && (DataverseName.isDigit(c) || c == '$');
            if (noQuote) continue;
            needQuote = true;
            break;
        }
        if (needQuote) {
            out.append('`');
        }
        for (i = from; i < to; ++i) {
            c = canonicalForm.charAt(i);
            if (c == '\\' || c == '`') {
                out.append('\\');
            }
            out.append(c);
        }
        if (needQuote) {
            out.append('`');
        }
        out.append('.');
    }

    private static boolean isLetter(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    @FunctionalInterface
    private static interface DataverseNamePartConsumer<T> {
        public void accept(String var1, int var2, int var3, T var4);
    }
}

