/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTreeCursorInitialState;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.NoOpIndexCursorStats;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class BTreeRangeSearchCursor
extends EnforcedIndexCursor
implements ITreeIndexCursor {
    protected final IBTreeLeafFrame frame;
    protected final ITreeIndexTupleReference frameTuple;
    protected final boolean exclusiveLatchNodes;
    protected boolean isPageDirty;
    protected IBufferCache bufferCache = null;
    protected int fileId = -1;
    protected ICachedPage page = null;
    protected int pageId = -1;
    protected int tupleIndex = 0;
    protected int stopTupleIndex;
    protected final RangePredicate reusablePredicate;
    protected final ArrayTupleReference reconciliationTuple;
    protected IIndexAccessor accessor;
    protected ISearchOperationCallback searchCb;
    protected MultiComparator originalKeyCmp;
    protected ArrayTupleBuilder tupleBuilder;
    protected FindTupleMode lowKeyFtm;
    protected FindTupleMode highKeyFtm;
    protected FindTupleNoExactMatchPolicy lowKeyFtp;
    protected FindTupleNoExactMatchPolicy highKeyFtp;
    protected RangePredicate pred;
    protected MultiComparator lowKeyCmp;
    protected MultiComparator highKeyCmp;
    protected ITupleReference lowKey;
    protected ITupleReference highKey;
    protected final IIndexCursorStats stats;

    public BTreeRangeSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes) {
        this(frame, exclusiveLatchNodes, NoOpIndexCursorStats.INSTANCE);
    }

    public BTreeRangeSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes, IIndexCursorStats stats) {
        this.frame = frame;
        this.frameTuple = frame.createTupleReference();
        this.exclusiveLatchNodes = exclusiveLatchNodes;
        this.reusablePredicate = new RangePredicate();
        this.reconciliationTuple = new ArrayTupleReference();
        this.stats = stats;
    }

    public void doDestroy() throws HyracksDataException {
    }

    public ITupleReference doGetTuple() {
        return this.frameTuple;
    }

    public int getTupleOffset() {
        return this.frame.getTupleOffset(this.tupleIndex - 1);
    }

    public int getPageId() {
        return this.pageId;
    }

    protected void fetchNextLeafPage(int nextLeafPage) throws HyracksDataException {
        do {
            ICachedPage nextLeaf = this.acquirePage(nextLeafPage);
            this.releasePage();
            this.page = nextLeaf;
            this.isPageDirty = false;
            this.frame.setPage(this.page);
            this.pageId = nextLeafPage;
            nextLeafPage = this.frame.getNextLeaf();
        } while (this.frame.getTupleCount() == 0 && nextLeafPage > 0);
    }

    public boolean doHasNext() throws HyracksDataException {
        if (this.tupleIndex >= this.frame.getTupleCount()) {
            int nextLeafPage = this.frame.getNextLeaf();
            if (nextLeafPage >= 0) {
                this.fetchNextLeafPage(nextLeafPage);
                this.tupleIndex = 0;
                this.stopTupleIndex = this.getHighKeyIndex();
                if (this.stopTupleIndex < 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.tupleIndex > this.stopTupleIndex) {
            return false;
        }
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, this.tupleIndex);
        while (!this.searchCb.proceed((ITupleReference)this.frameTuple)) {
            if (this.tupleBuilder == null) {
                this.tupleBuilder = new ArrayTupleBuilder(this.originalKeyCmp.getKeyFieldCount());
            }
            TupleUtils.copyTuple((ArrayTupleBuilder)this.tupleBuilder, (ITupleReference)this.frameTuple, (int)this.originalKeyCmp.getKeyFieldCount());
            this.reconciliationTuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
            this.releasePage();
            this.page = null;
            this.isPageDirty = false;
            this.searchCb.reconcile((ITupleReference)this.reconciliationTuple);
            this.reusablePredicate.setLowKey((ITupleReference)this.reconciliationTuple, true);
            this.close();
            this.accessor.search((IIndexCursor)this, (ISearchPredicate)this.reusablePredicate);
            if (this.stopTupleIndex < 0 || this.tupleIndex > this.stopTupleIndex) {
                return false;
            }
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, this.tupleIndex);
            if (this.originalKeyCmp.compare((ITupleReference)this.reconciliationTuple, (ITupleReference)this.frameTuple) == 0) {
                return true;
            }
            this.searchCb.cancel((ITupleReference)this.reconciliationTuple);
        }
        return true;
    }

    public void doNext() throws HyracksDataException {
        ++this.tupleIndex;
    }

    protected int getLowKeyIndex() throws HyracksDataException {
        if (this.lowKey == null) {
            return 0;
        }
        int index = this.frame.findTupleIndex(this.lowKey, this.frameTuple, this.lowKeyCmp, this.lowKeyFtm, this.lowKeyFtp);
        if (this.pred.lowKeyInclusive) {
            ++index;
        } else if (index < 0) {
            index = this.frame.getTupleCount();
        }
        return index;
    }

    protected int getHighKeyIndex() throws HyracksDataException {
        if (this.highKey == null) {
            return this.frame.getTupleCount() - 1;
        }
        int index = this.frame.findTupleIndex(this.highKey, this.frameTuple, this.highKeyCmp, this.highKeyFtm, this.highKeyFtp);
        if (this.pred.highKeyInclusive) {
            index = index < 0 ? this.frame.getTupleCount() - 1 : --index;
        }
        return index;
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.page != null) {
            this.resetBeforeOpen();
        }
        this.accessor = ((BTreeCursorInitialState)initialState).getAccessor();
        this.searchCb = initialState.getSearchOperationCallback();
        this.originalKeyCmp = initialState.getOriginalKeyComparator();
        this.pageId = ((BTreeCursorInitialState)initialState).getPageId();
        this.page = initialState.getPage();
        this.isPageDirty = false;
        this.frame.setPage(this.page);
        this.pred = (RangePredicate)searchPred;
        this.lowKeyCmp = this.pred.getLowKeyComparator();
        this.highKeyCmp = this.pred.getHighKeyComparator();
        this.lowKey = this.pred.getLowKey();
        this.highKey = this.pred.getHighKey();
        this.reusablePredicate.setLowKeyComparator(this.originalKeyCmp);
        this.reusablePredicate.setHighKeyComparator(this.pred.getHighKeyComparator());
        this.reusablePredicate.setHighKey(this.pred.getHighKey(), this.pred.isHighKeyInclusive());
        this.lowKeyFtm = FindTupleMode.EXCLUSIVE;
        this.lowKeyFtp = this.pred.lowKeyInclusive ? FindTupleNoExactMatchPolicy.LOWER_KEY : FindTupleNoExactMatchPolicy.HIGHER_KEY;
        this.highKeyFtm = FindTupleMode.EXCLUSIVE;
        this.highKeyFtp = this.pred.highKeyInclusive ? FindTupleNoExactMatchPolicy.HIGHER_KEY : FindTupleNoExactMatchPolicy.LOWER_KEY;
        this.tupleIndex = this.getLowKeyIndex();
        this.stopTupleIndex = this.getHighKeyIndex();
    }

    protected void resetBeforeOpen() throws HyracksDataException {
        this.releasePage();
    }

    public void doClose() throws HyracksDataException {
        if (this.page != null) {
            this.releasePage();
        }
        this.tupleIndex = 0;
        this.page = null;
        this.isPageDirty = false;
        this.pred = null;
    }

    public void setBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public boolean isExclusiveLatchNodes() {
        return this.exclusiveLatchNodes;
    }

    protected void releasePage() throws HyracksDataException {
        if (this.exclusiveLatchNodes) {
            this.page.releaseWriteLatch(this.isPageDirty);
        } else {
            this.page.releaseReadLatch();
        }
        this.bufferCache.unpin(this.page);
    }

    protected ICachedPage acquirePage(int pageId) throws HyracksDataException {
        ICachedPage nextPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
        if (this.exclusiveLatchNodes) {
            nextPage.acquireWriteLatch();
        } else {
            nextPage.acquireReadLatch();
        }
        this.stats.getPageCounter().update(1L);
        return nextPage;
    }
}

