/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.file.tfile.BoundedRangeFileInputStream;
import org.apache.hadoop.io.file.tfile.CompareUtils;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.MetaBlockAlreadyExists;
import org.apache.hadoop.io.file.tfile.MetaBlockDoesNotExist;
import org.apache.hadoop.io.file.tfile.SimpleBufferedOutputStream;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.io.file.tfile.Utils;

final class BCFile {
    static final Utils.Version API_VERSION = new Utils.Version(1, 0);
    static final Log LOG = LogFactory.getLog(BCFile.class);

    private BCFile() {
    }

    static final class BlockRegion
    implements CompareUtils.Scalar {
        private final long offset;
        private final long compressedSize;
        private final long rawSize;

        public BlockRegion(DataInput in) throws IOException {
            this.offset = Utils.readVLong(in);
            this.compressedSize = Utils.readVLong(in);
            this.rawSize = Utils.readVLong(in);
        }

        public BlockRegion(long offset, long compressedSize, long rawSize) {
            this.offset = offset;
            this.compressedSize = compressedSize;
            this.rawSize = rawSize;
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeVLong(out, this.offset);
            Utils.writeVLong(out, this.compressedSize);
            Utils.writeVLong(out, this.rawSize);
        }

        public long getOffset() {
            return this.offset;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getRawSize() {
            return this.rawSize;
        }

        @Override
        public long magnitude() {
            return this.offset;
        }
    }

    static final class Magic {
        private static final byte[] AB_MAGIC_BCFILE = new byte[]{-47, 17, -45, 104, -111, -75, -41, -74, 57, -33, 65, 64, -110, -70, -31, 80};

        Magic() {
        }

        public static void readAndVerify(DataInput in) throws IOException {
            byte[] abMagic = new byte[Magic.size()];
            in.readFully(abMagic);
            if (!Arrays.equals(abMagic, AB_MAGIC_BCFILE)) {
                throw new IOException("Not a valid BCFile.");
            }
        }

        public static void write(DataOutput out) throws IOException {
            out.write(AB_MAGIC_BCFILE);
        }

        public static int size() {
            return AB_MAGIC_BCFILE.length;
        }
    }

    static class DataIndex {
        static final String BLOCK_NAME = "BCFile.index";
        private final Compression.Algorithm defaultCompressionAlgorithm;
        private final ArrayList<BlockRegion> listRegions;

        public DataIndex(DataInput in) throws IOException {
            this.defaultCompressionAlgorithm = Compression.getCompressionAlgorithmByName(Utils.readString(in));
            int n = Utils.readVInt(in);
            this.listRegions = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                BlockRegion region = new BlockRegion(in);
                this.listRegions.add(region);
            }
        }

        public DataIndex(String defaultCompressionAlgorithmName) {
            this.defaultCompressionAlgorithm = Compression.getCompressionAlgorithmByName(defaultCompressionAlgorithmName);
            this.listRegions = new ArrayList();
        }

        public Compression.Algorithm getDefaultCompressionAlgorithm() {
            return this.defaultCompressionAlgorithm;
        }

        public ArrayList<BlockRegion> getBlockRegionList() {
            return this.listRegions;
        }

        public void addBlockRegion(BlockRegion region) {
            this.listRegions.add(region);
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeString(out, this.defaultCompressionAlgorithm.getName());
            Utils.writeVInt(out, this.listRegions.size());
            for (BlockRegion region : this.listRegions) {
                region.write(out);
            }
        }
    }

    static final class MetaIndexEntry {
        private final String metaName;
        private final Compression.Algorithm compressionAlgorithm;
        private static final String defaultPrefix = "data:";
        private final BlockRegion region;

        public MetaIndexEntry(DataInput in) throws IOException {
            String fullMetaName = Utils.readString(in);
            if (!fullMetaName.startsWith(defaultPrefix)) {
                throw new IOException("Corrupted Meta region Index");
            }
            this.metaName = fullMetaName.substring(defaultPrefix.length(), fullMetaName.length());
            this.compressionAlgorithm = Compression.getCompressionAlgorithmByName(Utils.readString(in));
            this.region = new BlockRegion(in);
        }

        public MetaIndexEntry(String metaName, Compression.Algorithm compressionAlgorithm, BlockRegion region) {
            this.metaName = metaName;
            this.compressionAlgorithm = compressionAlgorithm;
            this.region = region;
        }

        public String getMetaName() {
            return this.metaName;
        }

        public Compression.Algorithm getCompressionAlgorithm() {
            return this.compressionAlgorithm;
        }

        public BlockRegion getRegion() {
            return this.region;
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeString(out, defaultPrefix + this.metaName);
            Utils.writeString(out, this.compressionAlgorithm.getName());
            this.region.write(out);
        }
    }

    static class MetaIndex {
        final Map<String, MetaIndexEntry> index;

        public MetaIndex() {
            this.index = new TreeMap<String, MetaIndexEntry>();
        }

        public MetaIndex(DataInput in) throws IOException {
            int count = Utils.readVInt(in);
            this.index = new TreeMap<String, MetaIndexEntry>();
            for (int nx = 0; nx < count; ++nx) {
                MetaIndexEntry indexEntry = new MetaIndexEntry(in);
                this.index.put(indexEntry.getMetaName(), indexEntry);
            }
        }

        public void addEntry(MetaIndexEntry indexEntry) {
            this.index.put(indexEntry.getMetaName(), indexEntry);
        }

        public MetaIndexEntry getMetaByName(String name) {
            return this.index.get(name);
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeVInt(out, this.index.size());
            for (MetaIndexEntry indexEntry : this.index.values()) {
                indexEntry.write(out);
            }
        }
    }

    public static class Reader
    implements Closeable {
        private final FSDataInputStream in;
        private final Configuration conf;
        final DataIndex dataIndex;
        final MetaIndex metaIndex;
        final Utils.Version version;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reader(FSDataInputStream fin, long fileLength, Configuration conf) throws IOException {
            this.in = fin;
            this.conf = conf;
            fin.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size() - 8L);
            long offsetIndexMeta = fin.readLong();
            this.version = new Utils.Version(fin);
            Magic.readAndVerify(fin);
            if (!this.version.compatibleWith(API_VERSION)) {
                throw new RuntimeException("Incompatible BCFile fileBCFileVersion.");
            }
            fin.seek(offsetIndexMeta);
            this.metaIndex = new MetaIndex(fin);
            try (BlockReader blockR = this.getMetaBlock("BCFile.index");){
                this.dataIndex = new DataIndex(blockR);
            }
        }

        public String getDefaultCompressionName() {
            return this.dataIndex.getDefaultCompressionAlgorithm().getName();
        }

        public Utils.Version getBCFileVersion() {
            return this.version;
        }

        public Utils.Version getAPIVersion() {
            return API_VERSION;
        }

        @Override
        public void close() {
        }

        public int getBlockCount() {
            return this.dataIndex.getBlockRegionList().size();
        }

        public BlockReader getMetaBlock(String name) throws IOException, MetaBlockDoesNotExist {
            MetaIndexEntry imeBCIndex = this.metaIndex.getMetaByName(name);
            if (imeBCIndex == null) {
                throw new MetaBlockDoesNotExist("name=" + name);
            }
            BlockRegion region = imeBCIndex.getRegion();
            return this.createReader(imeBCIndex.getCompressionAlgorithm(), region);
        }

        public BlockReader getDataBlock(int blockIndex) throws IOException {
            if (blockIndex < 0 || blockIndex >= this.getBlockCount()) {
                throw new IndexOutOfBoundsException(String.format("blockIndex=%d, numBlocks=%d", blockIndex, this.getBlockCount()));
            }
            BlockRegion region = this.dataIndex.getBlockRegionList().get(blockIndex);
            return this.createReader(this.dataIndex.getDefaultCompressionAlgorithm(), region);
        }

        private BlockReader createReader(Compression.Algorithm compressAlgo, BlockRegion region) throws IOException {
            RBlockState rbs = new RBlockState(compressAlgo, this.in, region, this.conf);
            return new BlockReader(rbs);
        }

        public int getBlockIndexNear(long offset) {
            ArrayList<BlockRegion> list = this.dataIndex.getBlockRegionList();
            int idx = Utils.lowerBound(list, new CompareUtils.ScalarLong(offset), new CompareUtils.ScalarComparator());
            if (idx == list.size()) {
                return -1;
            }
            return idx;
        }

        public static class BlockReader
        extends DataInputStream {
            private final RBlockState rBlkState;
            private boolean closed = false;

            BlockReader(RBlockState rbs) {
                super(rbs.getInputStream());
                this.rBlkState = rbs;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    this.rBlkState.finish();
                }
                finally {
                    this.closed = true;
                }
            }

            public String getCompressionName() {
                return this.rBlkState.getCompressionName();
            }

            public long getRawSize() {
                return this.rBlkState.getBlockRegion().getRawSize();
            }

            public long getCompressedSize() {
                return this.rBlkState.getBlockRegion().getCompressedSize();
            }

            public long getStartPos() {
                return this.rBlkState.getBlockRegion().getOffset();
            }
        }

        private static final class RBlockState {
            private final Compression.Algorithm compressAlgo;
            private Decompressor decompressor;
            private final BlockRegion region;
            private final InputStream in;

            public RBlockState(Compression.Algorithm compressionAlgo, FSDataInputStream fsin, BlockRegion region, Configuration conf) throws IOException {
                this.compressAlgo = compressionAlgo;
                this.region = region;
                this.decompressor = compressionAlgo.getDecompressor();
                try {
                    this.in = this.compressAlgo.createDecompressionStream(new BoundedRangeFileInputStream(fsin, this.region.getOffset(), this.region.getCompressedSize()), this.decompressor, TFile.getFSInputBufferSize(conf));
                }
                catch (IOException e) {
                    this.compressAlgo.returnDecompressor(this.decompressor);
                    throw e;
                }
            }

            public InputStream getInputStream() {
                return this.in;
            }

            public String getCompressionName() {
                return this.compressAlgo.getName();
            }

            public BlockRegion getBlockRegion() {
                return this.region;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finish() throws IOException {
                try {
                    this.in.close();
                }
                finally {
                    this.compressAlgo.returnDecompressor(this.decompressor);
                    this.decompressor = null;
                }
            }
        }
    }

    public static class Writer
    implements Closeable {
        private final FSDataOutputStream out;
        private final Configuration conf;
        final DataIndex dataIndex;
        final MetaIndex metaIndex;
        boolean blkInProgress = false;
        private boolean metaBlkSeen = false;
        private boolean closed = false;
        long errorCount = 0L;
        private BytesWritable fsOutputBuffer;

        public Writer(FSDataOutputStream fout, String compressionName, Configuration conf) throws IOException {
            if (fout.getPos() != 0L) {
                throw new IOException("Output file not at zero offset.");
            }
            this.out = fout;
            this.conf = conf;
            this.dataIndex = new DataIndex(compressionName);
            this.metaIndex = new MetaIndex();
            this.fsOutputBuffer = new BytesWritable();
            Magic.write(fout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            block8: {
                if (this.closed) {
                    return;
                }
                try {
                    if (this.errorCount != 0L) break block8;
                    if (this.blkInProgress) {
                        throw new IllegalStateException("Close() called with active block appender.");
                    }
                    try (BlockAppender appender = this.prepareMetaBlock("BCFile.index", this.getDefaultCompressionAlgorithm());){
                        this.dataIndex.write(appender);
                    }
                    long offsetIndexMeta = this.out.getPos();
                    this.metaIndex.write(this.out);
                    this.out.writeLong(offsetIndexMeta);
                    API_VERSION.write(this.out);
                    Magic.write(this.out);
                    this.out.flush();
                }
                finally {
                    this.closed = true;
                }
            }
        }

        private Compression.Algorithm getDefaultCompressionAlgorithm() {
            return this.dataIndex.getDefaultCompressionAlgorithm();
        }

        private BlockAppender prepareMetaBlock(String name, Compression.Algorithm compressAlgo) throws IOException, MetaBlockAlreadyExists {
            if (this.blkInProgress) {
                throw new IllegalStateException("Cannot create Meta Block until previous block is closed.");
            }
            if (this.metaIndex.getMetaByName(name) != null) {
                throw new MetaBlockAlreadyExists("name=" + name);
            }
            MetaBlockRegister mbr = new MetaBlockRegister(name, compressAlgo);
            WBlockState wbs = new WBlockState(compressAlgo, this.out, this.fsOutputBuffer, this.conf);
            BlockAppender ba = new BlockAppender(mbr, wbs);
            this.blkInProgress = true;
            this.metaBlkSeen = true;
            return ba;
        }

        public BlockAppender prepareMetaBlock(String name, String compressionName) throws IOException, MetaBlockAlreadyExists {
            return this.prepareMetaBlock(name, Compression.getCompressionAlgorithmByName(compressionName));
        }

        public BlockAppender prepareMetaBlock(String name) throws IOException, MetaBlockAlreadyExists {
            return this.prepareMetaBlock(name, this.getDefaultCompressionAlgorithm());
        }

        public BlockAppender prepareDataBlock() throws IOException {
            if (this.blkInProgress) {
                throw new IllegalStateException("Cannot create Data Block until previous block is closed.");
            }
            if (this.metaBlkSeen) {
                throw new IllegalStateException("Cannot create Data Block after Meta Blocks.");
            }
            DataBlockRegister dbr = new DataBlockRegister();
            WBlockState wbs = new WBlockState(this.getDefaultCompressionAlgorithm(), this.out, this.fsOutputBuffer, this.conf);
            BlockAppender ba = new BlockAppender(dbr, wbs);
            this.blkInProgress = true;
            return ba;
        }

        private class DataBlockRegister
        implements BlockRegister {
            DataBlockRegister() {
            }

            @Override
            public void register(long raw, long begin, long end) {
                Writer.this.dataIndex.addBlockRegion(new BlockRegion(begin, end - begin, raw));
            }
        }

        private class MetaBlockRegister
        implements BlockRegister {
            private final String name;
            private final Compression.Algorithm compressAlgo;

            MetaBlockRegister(String name, Compression.Algorithm compressAlgo) {
                this.name = name;
                this.compressAlgo = compressAlgo;
            }

            @Override
            public void register(long raw, long begin, long end) {
                Writer.this.metaIndex.addEntry(new MetaIndexEntry(this.name, this.compressAlgo, new BlockRegion(begin, end - begin, raw)));
            }
        }

        public class BlockAppender
        extends DataOutputStream {
            private final BlockRegister blockRegister;
            private final WBlockState wBlkState;
            private boolean closed;

            BlockAppender(BlockRegister register, WBlockState wbs) {
                super(wbs.getOutputStream());
                this.closed = false;
                this.blockRegister = register;
                this.wBlkState = wbs;
            }

            public long getRawSize() throws IOException {
                return (long)this.size() & 0xFFFFFFFFL;
            }

            public long getCompressedSize() throws IOException {
                return this.wBlkState.getCompressedSize();
            }

            @Override
            public void flush() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    ++Writer.this.errorCount;
                    this.wBlkState.finish();
                    this.blockRegister.register(this.getRawSize(), this.wBlkState.getStartPos(), this.wBlkState.getCurrentPos());
                    --Writer.this.errorCount;
                }
                finally {
                    this.closed = true;
                    Writer.this.blkInProgress = false;
                }
            }
        }

        private static final class WBlockState {
            private final Compression.Algorithm compressAlgo;
            private Compressor compressor;
            private final FSDataOutputStream fsOut;
            private final long posStart;
            private final SimpleBufferedOutputStream fsBufferedOutput;
            private OutputStream out;

            public WBlockState(Compression.Algorithm compressionAlgo, FSDataOutputStream fsOut, BytesWritable fsOutputBuffer, Configuration conf) throws IOException {
                this.compressAlgo = compressionAlgo;
                this.fsOut = fsOut;
                this.posStart = fsOut.getPos();
                fsOutputBuffer.setCapacity(TFile.getFSOutputBufferSize(conf));
                this.fsBufferedOutput = new SimpleBufferedOutputStream(this.fsOut, fsOutputBuffer.getBytes());
                this.compressor = this.compressAlgo.getCompressor();
                try {
                    this.out = compressionAlgo.createCompressionStream(this.fsBufferedOutput, this.compressor, 0);
                }
                catch (IOException e) {
                    this.compressAlgo.returnCompressor(this.compressor);
                    throw e;
                }
            }

            OutputStream getOutputStream() {
                return this.out;
            }

            long getCurrentPos() throws IOException {
                return this.fsOut.getPos() + (long)this.fsBufferedOutput.size();
            }

            long getStartPos() {
                return this.posStart;
            }

            long getCompressedSize() throws IOException {
                long ret = this.getCurrentPos() - this.posStart;
                return ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finish() throws IOException {
                try {
                    if (this.out != null) {
                        this.out.flush();
                        this.out = null;
                    }
                }
                finally {
                    this.compressAlgo.returnCompressor(this.compressor);
                    this.compressor = null;
                }
            }
        }

        private static interface BlockRegister {
            public void register(long var1, long var3, long var5);
        }
    }
}

