/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.interval.utils.memory;

import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.om.pointables.nonvisitor.AIntervalPointable;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;

public class IntervalJoinUtil {
    private IntervalJoinUtil() {
    }

    public static void getIntervalPointable(IFrameTupleAccessor accessor, int tupleId, int fieldId, AIntervalPointable ip) {
        int start = IntervalJoinUtil.getIntervalOffset(accessor, tupleId, fieldId);
        int length = accessor.getFieldLength(tupleId, fieldId) - 1;
        ip.set(accessor.getBuffer().array(), start, length);
    }

    public static int getIntervalOffset(IFrameTupleAccessor accessor, int tupleId, int fieldId) {
        return IntervalJoinUtil.getIntervalOffsetWithTag(accessor, tupleId, fieldId) + 1;
    }

    public static int getIntervalOffsetWithTag(IFrameTupleAccessor accessor, int tupleId, int fieldId) {
        int start = accessor.getTupleStartOffset(tupleId) + accessor.getFieldSlotsLength() + accessor.getFieldStartOffset(tupleId, fieldId);
        return start;
    }

    public static long getIntervalStart(IFrameTupleAccessor accessor, int tupleId, int fieldId) {
        int start = IntervalJoinUtil.getIntervalOffset(accessor, tupleId, fieldId);
        long intervalStart = AIntervalSerializerDeserializer.getIntervalStart((byte[])accessor.getBuffer().array(), (int)start);
        return intervalStart;
    }

    public static long getIntervalEnd(IFrameTupleAccessor accessor, int tupleId, int fieldId) {
        int start = IntervalJoinUtil.getIntervalOffset(accessor, tupleId, fieldId);
        long intervalEnd = AIntervalSerializerDeserializer.getIntervalEnd((byte[])accessor.getBuffer().array(), (int)start);
        return intervalEnd;
    }
}

