/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;

public class WebHCatJTShim23
implements HadoopShims.WebHCatJTShim {
    private JobClient jc;

    public WebHCatJTShim23(final Configuration conf, final UserGroupInformation ugi) throws IOException {
        try {
            this.jc = (JobClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobClient>(){

                @Override
                public JobClient run() throws IOException, InterruptedException {
                    return (JobClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobClient>(){

                        @Override
                        public JobClient run() throws IOException {
                            return new JobClient(conf);
                        }
                    });
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Failed to create JobClient", ex);
        }
    }

    public JobProfile getJobProfile(JobID jobid) throws IOException {
        RunningJob rj = this.jc.getJob(jobid);
        JobStatus jobStatus = rj.getJobStatus();
        JobProfile jobProfile = new JobProfile(jobStatus.getUsername(), (org.apache.hadoop.mapreduce.JobID)jobStatus.getJobID(), jobStatus.getJobFile(), jobStatus.getTrackingUrl(), jobStatus.getJobName());
        return jobProfile;
    }

    public JobStatus getJobStatus(JobID jobid) throws IOException {
        RunningJob rj = this.jc.getJob(jobid);
        JobStatus jobStatus = rj.getJobStatus();
        return jobStatus;
    }

    public void killJob(JobID jobid) throws IOException {
        RunningJob rj = this.jc.getJob(jobid);
        rj.killJob();
    }

    public JobStatus[] getAllJobs() throws IOException {
        return this.jc.getAllJobs();
    }

    public void close() {
        try {
            this.jc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addCacheFile(URI uri, Job job) {
        job.addCacheFile(uri);
    }
}

