/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Strings;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.GlobalMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFileWriter.class);
    private static ParquetMetadataConverter metadataConverter = new ParquetMetadataConverter();
    public static final String PARQUET_METADATA_FILE = "_metadata";
    public static final String PARQUET_COMMON_METADATA_FILE = "_common_metadata";
    public static final byte[] MAGIC = "PAR1".getBytes(Charset.forName("ASCII"));
    public static final int CURRENT_VERSION = 1;
    private static final int DFS_BUFFER_SIZE_DEFAULT = 4096;
    static final Set<String> BLOCK_FS_SCHEMES = new HashSet<String>();
    private final MessageType schema;
    private final FSDataOutputStream out;
    private final AlignmentStrategy alignment;
    private List<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
    private BlockMetaData currentBlock;
    private long currentRecordCount;
    private EncodingStats.Builder encodingStatsBuilder;
    private Set<Encoding> currentEncodings;
    private long uncompressedLength;
    private long compressedLength;
    private Statistics currentStatistics;
    private CompressionCodecName currentChunkCodec;
    private ColumnPath currentChunkPath;
    private PrimitiveType.PrimitiveTypeName currentChunkType;
    private long currentChunkValueCount;
    private long currentChunkFirstDataPage;
    private long currentChunkDictionaryPageOffset;
    private STATE state = STATE.NOT_STARTED;
    private static final ThreadLocal<byte[]> COPY_BUFFER;

    private static boolean supportsBlockSize(FileSystem fs) {
        return BLOCK_FS_SCHEMES.contains(fs.getUri().getScheme());
    }

    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file) throws IOException {
        this(configuration, schema, file, Mode.CREATE, 0x8000000L, 0);
    }

    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file, Mode mode) throws IOException {
        this(configuration, schema, file, mode, 0x8000000L, 0);
    }

    public ParquetFileWriter(Configuration configuration, MessageType schema, Path file, Mode mode, long rowGroupSize, int maxPaddingSize) throws IOException {
        boolean overwriteFlag;
        TypeUtil.checkValidWriteSchema((GroupType)schema);
        this.schema = schema;
        FileSystem fs = file.getFileSystem(configuration);
        boolean bl = overwriteFlag = mode == Mode.OVERWRITE;
        if (ParquetFileWriter.supportsBlockSize(fs)) {
            long dfsBlockSize = Math.max(fs.getDefaultBlockSize(file), rowGroupSize);
            this.alignment = PaddingAlignment.get(dfsBlockSize, rowGroupSize, maxPaddingSize);
            this.out = fs.create(file, overwriteFlag, 4096, fs.getDefaultReplication(file), dfsBlockSize);
        } else {
            this.alignment = NoAlignment.get(rowGroupSize);
            this.out = fs.create(file, overwriteFlag);
        }
        this.encodingStatsBuilder = new EncodingStats.Builder();
    }

    ParquetFileWriter(Configuration configuration, MessageType schema, Path file, long rowAndBlockSize, int maxPaddingSize) throws IOException {
        FileSystem fs = file.getFileSystem(configuration);
        this.schema = schema;
        this.alignment = PaddingAlignment.get(rowAndBlockSize, rowAndBlockSize, maxPaddingSize);
        this.out = fs.create(file, true, 4096, fs.getDefaultReplication(file), rowAndBlockSize);
        this.encodingStatsBuilder = new EncodingStats.Builder();
    }

    public void start() throws IOException {
        this.state = this.state.start();
        LOG.debug("{}: start", (Object)this.out.getPos());
        this.out.write(MAGIC);
    }

    public void startBlock(long recordCount) throws IOException {
        this.state = this.state.startBlock();
        LOG.debug("{}: start block", (Object)this.out.getPos());
        this.alignment.alignForRowGroup(this.out);
        this.currentBlock = new BlockMetaData();
        this.currentRecordCount = recordCount;
    }

    public void startColumn(ColumnDescriptor descriptor, long valueCount, CompressionCodecName compressionCodecName) throws IOException {
        this.state = this.state.startColumn();
        this.encodingStatsBuilder.clear();
        this.currentEncodings = new HashSet<Encoding>();
        this.currentChunkPath = ColumnPath.get((String[])descriptor.getPath());
        this.currentChunkType = descriptor.getType();
        this.currentChunkCodec = compressionCodecName;
        this.currentChunkValueCount = valueCount;
        this.currentChunkFirstDataPage = this.out.getPos();
        this.compressedLength = 0L;
        this.uncompressedLength = 0L;
        this.currentStatistics = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)this.currentChunkType);
    }

    public void writeDictionaryPage(DictionaryPage dictionaryPage) throws IOException {
        this.state = this.state.write();
        LOG.debug("{}: write dictionary page: {} values", (Object)this.out.getPos(), (Object)dictionaryPage.getDictionarySize());
        this.currentChunkDictionaryPageOffset = this.out.getPos();
        int uncompressedSize = dictionaryPage.getUncompressedSize();
        int compressedPageSize = (int)dictionaryPage.getBytes().size();
        metadataConverter.writeDictionaryPageHeader(uncompressedSize, compressedPageSize, dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding(), (OutputStream)this.out);
        long headerSize = this.out.getPos() - this.currentChunkDictionaryPageOffset;
        this.uncompressedLength += (long)uncompressedSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        LOG.debug("{}: write dictionary page content {}", (Object)this.out.getPos(), (Object)compressedPageSize);
        dictionaryPage.getBytes().writeAllTo((OutputStream)this.out);
        this.encodingStatsBuilder.addDictEncoding(dictionaryPage.getEncoding());
        this.currentEncodings.add(dictionaryPage.getEncoding());
    }

    @Deprecated
    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        this.state = this.state.write();
        long beforeHeader = this.out.getPos();
        LOG.debug("{}: write data page: {} values", (Object)beforeHeader, (Object)valueCount);
        int compressedPageSize = (int)bytes.size();
        metadataConverter.writeDataPageHeader(uncompressedPageSize, compressedPageSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, (OutputStream)this.out);
        long headerSize = this.out.getPos() - beforeHeader;
        this.uncompressedLength += (long)uncompressedPageSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        LOG.debug("{}: write data page content {}", (Object)this.out.getPos(), (Object)compressedPageSize);
        bytes.writeAllTo((OutputStream)this.out);
        this.encodingStatsBuilder.addDataEncoding(valuesEncoding);
        this.currentEncodings.add(rlEncoding);
        this.currentEncodings.add(dlEncoding);
        this.currentEncodings.add(valuesEncoding);
    }

    public void writeDataPage(int valueCount, int uncompressedPageSize, BytesInput bytes, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        this.state = this.state.write();
        long beforeHeader = this.out.getPos();
        LOG.debug("{}: write data page: {} values", (Object)beforeHeader, (Object)valueCount);
        int compressedPageSize = (int)bytes.size();
        metadataConverter.writeDataPageHeader(uncompressedPageSize, compressedPageSize, valueCount, statistics, rlEncoding, dlEncoding, valuesEncoding, (OutputStream)this.out);
        long headerSize = this.out.getPos() - beforeHeader;
        this.uncompressedLength += (long)uncompressedPageSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        LOG.debug("{}: write data page content {}", (Object)this.out.getPos(), (Object)compressedPageSize);
        bytes.writeAllTo((OutputStream)this.out);
        this.currentStatistics.mergeStatistics(statistics);
        this.encodingStatsBuilder.addDataEncoding(valuesEncoding);
        this.currentEncodings.add(rlEncoding);
        this.currentEncodings.add(dlEncoding);
        this.currentEncodings.add(valuesEncoding);
    }

    void writeDataPages(BytesInput bytes, long uncompressedTotalPageSize, long compressedTotalPageSize, Statistics totalStats, Set<Encoding> rlEncodings, Set<Encoding> dlEncodings, List<Encoding> dataEncodings) throws IOException {
        this.state = this.state.write();
        LOG.debug("{}: write data pages", (Object)this.out.getPos());
        long headersSize = bytes.size() - compressedTotalPageSize;
        this.uncompressedLength += uncompressedTotalPageSize + headersSize;
        this.compressedLength += compressedTotalPageSize + headersSize;
        LOG.debug("{}: write data pages content", (Object)this.out.getPos());
        bytes.writeAllTo((OutputStream)this.out);
        this.encodingStatsBuilder.addDataEncodings(dataEncodings);
        if (rlEncodings.isEmpty()) {
            this.encodingStatsBuilder.withV2Pages();
        }
        this.currentEncodings.addAll(rlEncodings);
        this.currentEncodings.addAll(dlEncodings);
        this.currentEncodings.addAll(dataEncodings);
        this.currentStatistics = totalStats;
    }

    public void endColumn() throws IOException {
        this.state = this.state.endColumn();
        LOG.debug("{}: end column", (Object)this.out.getPos());
        this.currentBlock.addColumn(ColumnChunkMetaData.get(this.currentChunkPath, this.currentChunkType, this.currentChunkCodec, this.encodingStatsBuilder.build(), this.currentEncodings, this.currentStatistics, this.currentChunkFirstDataPage, this.currentChunkDictionaryPageOffset, this.currentChunkValueCount, this.compressedLength, this.uncompressedLength));
        this.currentBlock.setTotalByteSize(this.currentBlock.getTotalByteSize() + this.uncompressedLength);
        this.uncompressedLength = 0L;
        this.compressedLength = 0L;
    }

    public void endBlock() throws IOException {
        this.state = this.state.endBlock();
        LOG.debug("{}: end block", (Object)this.out.getPos());
        this.currentBlock.setRowCount(this.currentRecordCount);
        this.blocks.add(this.currentBlock);
        this.currentBlock = null;
    }

    public void appendFile(Configuration conf, Path file) throws IOException {
        ParquetFileReader.open(conf, file).appendTo(this);
    }

    public void appendRowGroups(FSDataInputStream file, List<BlockMetaData> rowGroups, boolean dropColumns) throws IOException {
        this.appendRowGroups(HadoopStreams.wrap(file), rowGroups, dropColumns);
    }

    public void appendRowGroups(SeekableInputStream file, List<BlockMetaData> rowGroups, boolean dropColumns) throws IOException {
        for (BlockMetaData block : rowGroups) {
            this.appendRowGroup(file, block, dropColumns);
        }
    }

    public void appendRowGroup(FSDataInputStream from, BlockMetaData rowGroup, boolean dropColumns) throws IOException {
        this.appendRowGroup(from, rowGroup, dropColumns);
    }

    public void appendRowGroup(SeekableInputStream from, BlockMetaData rowGroup, boolean dropColumns) throws IOException {
        this.startBlock(rowGroup.getRowCount());
        HashMap<String, ColumnChunkMetaData> columnsToCopy = new HashMap<String, ColumnChunkMetaData>();
        for (ColumnChunkMetaData chunk : rowGroup.getColumns()) {
            columnsToCopy.put(chunk.getPath().toDotString(), chunk);
        }
        ArrayList<ColumnChunkMetaData> columnsInOrder = new ArrayList<ColumnChunkMetaData>();
        for (ColumnDescriptor descriptor : this.schema.getColumns()) {
            String path = ColumnPath.get((String[])descriptor.getPath()).toDotString();
            ColumnChunkMetaData chunk = (ColumnChunkMetaData)columnsToCopy.remove(path);
            if (chunk != null) {
                columnsInOrder.add(chunk);
                continue;
            }
            throw new IllegalArgumentException(String.format("Missing column '%s', cannot copy row group: %s", path, rowGroup));
        }
        if (!dropColumns && !columnsToCopy.isEmpty()) {
            throw new IllegalArgumentException(String.format("Columns cannot be copied (missing from target schema): %s", Strings.join(columnsToCopy.keySet(), (String)", ")));
        }
        long start = -1L;
        long length = 0L;
        long blockCompressedSize = 0L;
        for (int i = 0; i < columnsInOrder.size(); ++i) {
            ColumnChunkMetaData chunk = (ColumnChunkMetaData)columnsInOrder.get(i);
            long newChunkStart = this.out.getPos() + length;
            if (start < 0L) {
                start = chunk.getStartingPos();
            }
            if (i + 1 == columnsInOrder.size() || ((ColumnChunkMetaData)columnsInOrder.get(i + 1)).getStartingPos() != start + (length += chunk.getTotalSize())) {
                ParquetFileWriter.copy(from, this.out, start, length);
                start = -1L;
                length = 0L;
            }
            this.currentBlock.addColumn(ColumnChunkMetaData.get(chunk.getPath(), chunk.getType(), chunk.getCodec(), chunk.getEncodingStats(), chunk.getEncodings(), chunk.getStatistics(), newChunkStart, newChunkStart, chunk.getValueCount(), chunk.getTotalSize(), chunk.getTotalUncompressedSize()));
            blockCompressedSize += chunk.getTotalSize();
        }
        this.currentBlock.setTotalByteSize(blockCompressedSize);
        this.endBlock();
    }

    private static void copy(SeekableInputStream from, FSDataOutputStream to, long start, long length) throws IOException {
        int bytesRead;
        LOG.debug("Copying {} bytes at {} to {}", new Object[]{length, start, to.getPos()});
        from.seek(start);
        byte[] buffer = COPY_BUFFER.get();
        for (long bytesCopied = 0L; bytesCopied < length; bytesCopied += (long)bytesRead) {
            long bytesLeft = length - bytesCopied;
            bytesRead = from.read(buffer, 0, (long)buffer.length < bytesLeft ? buffer.length : (int)bytesLeft);
            if (bytesRead < 0) {
                throw new IllegalArgumentException("Unexpected end of input file at " + start + bytesCopied);
            }
            to.write(buffer, 0, bytesRead);
        }
    }

    public void end(Map<String, String> extraMetaData) throws IOException {
        this.state = this.state.end();
        LOG.debug("{}: end", (Object)this.out.getPos());
        ParquetMetadata footer = new ParquetMetadata(new FileMetaData(this.schema, extraMetaData, "parquet-mr version 1.8.2 (build c6522788629e590a53eb79874b95f6c3ff11f16c)"), this.blocks);
        ParquetFileWriter.serializeFooter(footer, this.out);
        this.out.close();
    }

    private static void serializeFooter(ParquetMetadata footer, FSDataOutputStream out) throws IOException {
        long footerIndex = out.getPos();
        org.apache.parquet.format.FileMetaData parquetMetadata = metadataConverter.toParquetMetadata(1, footer);
        Util.writeFileMetaData((org.apache.parquet.format.FileMetaData)parquetMetadata, (OutputStream)out);
        LOG.debug("{}: footer length = {}", (Object)out.getPos(), (Object)(out.getPos() - footerIndex));
        BytesUtils.writeIntLittleEndian((OutputStream)out, (int)((int)(out.getPos() - footerIndex)));
        out.write(MAGIC);
    }

    public static void writeMetadataFile(Configuration configuration, Path outputPath, List<Footer> footers) throws IOException {
        FileSystem fs = outputPath.getFileSystem(configuration);
        outputPath = outputPath.makeQualified(fs);
        ParquetMetadata metadataFooter = ParquetFileWriter.mergeFooters(outputPath, footers);
        ParquetFileWriter.writeMetadataFile(outputPath, metadataFooter, fs, PARQUET_METADATA_FILE);
        metadataFooter.getBlocks().clear();
        ParquetFileWriter.writeMetadataFile(outputPath, metadataFooter, fs, PARQUET_COMMON_METADATA_FILE);
    }

    private static void writeMetadataFile(Path outputPath, ParquetMetadata metadataFooter, FileSystem fs, String parquetMetadataFile) throws IOException {
        Path metaDataPath = new Path(outputPath, parquetMetadataFile);
        FSDataOutputStream metadata = fs.create(metaDataPath);
        metadata.write(MAGIC);
        ParquetFileWriter.serializeFooter(metadataFooter, metadata);
        metadata.close();
    }

    static ParquetMetadata mergeFooters(Path root, List<Footer> footers) {
        String rootPath = root.toUri().getPath();
        GlobalMetaData fileMetaData = null;
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        for (Footer footer : footers) {
            String footerPath = footer.getFile().toUri().getPath();
            if (!footerPath.startsWith(rootPath)) {
                throw new ParquetEncodingException(footerPath + " invalid: all the files must be contained in the root " + root);
            }
            footerPath = footerPath.substring(rootPath.length());
            while (footerPath.startsWith("/")) {
                footerPath = footerPath.substring(1);
            }
            fileMetaData = ParquetFileWriter.mergeInto(footer.getParquetMetadata().getFileMetaData(), fileMetaData);
            for (BlockMetaData block : footer.getParquetMetadata().getBlocks()) {
                block.setPath(footerPath);
                blocks.add(block);
            }
        }
        return new ParquetMetadata(fileMetaData.merge(), blocks);
    }

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    public long getNextRowGroupSize() throws IOException {
        return this.alignment.nextRowGroupSize(this.out);
    }

    static GlobalMetaData getGlobalMetaData(List<Footer> footers) {
        return ParquetFileWriter.getGlobalMetaData(footers, true);
    }

    static GlobalMetaData getGlobalMetaData(List<Footer> footers, boolean strict) {
        GlobalMetaData fileMetaData = null;
        for (Footer footer : footers) {
            ParquetMetadata currentMetadata = footer.getParquetMetadata();
            fileMetaData = ParquetFileWriter.mergeInto(currentMetadata.getFileMetaData(), fileMetaData, strict);
        }
        return fileMetaData;
    }

    static GlobalMetaData mergeInto(FileMetaData toMerge, GlobalMetaData mergedMetadata) {
        return ParquetFileWriter.mergeInto(toMerge, mergedMetadata, true);
    }

    static GlobalMetaData mergeInto(FileMetaData toMerge, GlobalMetaData mergedMetadata, boolean strict) {
        MessageType schema = null;
        HashMap<String, Set<String>> newKeyValues = new HashMap<String, Set<String>>();
        HashSet<String> createdBy = new HashSet<String>();
        if (mergedMetadata != null) {
            schema = mergedMetadata.getSchema();
            newKeyValues.putAll(mergedMetadata.getKeyValueMetaData());
            createdBy.addAll(mergedMetadata.getCreatedBy());
        }
        if (schema == null && toMerge.getSchema() != null || schema != null && !schema.equals((Object)toMerge.getSchema())) {
            schema = ParquetFileWriter.mergeInto(toMerge.getSchema(), schema, strict);
        }
        for (Map.Entry<String, String> entry : toMerge.getKeyValueMetaData().entrySet()) {
            LinkedHashSet<String> values = (LinkedHashSet<String>)newKeyValues.get(entry.getKey());
            if (values == null) {
                values = new LinkedHashSet<String>();
                newKeyValues.put(entry.getKey(), values);
            }
            values.add(entry.getValue());
        }
        createdBy.add(toMerge.getCreatedBy());
        return new GlobalMetaData(schema, newKeyValues, createdBy);
    }

    static MessageType mergeInto(MessageType toMerge, MessageType mergedSchema) {
        return ParquetFileWriter.mergeInto(toMerge, mergedSchema, true);
    }

    static MessageType mergeInto(MessageType toMerge, MessageType mergedSchema, boolean strict) {
        if (mergedSchema == null) {
            return toMerge;
        }
        return mergedSchema.union(toMerge, strict);
    }

    static {
        BLOCK_FS_SCHEMES.add("hdfs");
        BLOCK_FS_SCHEMES.add("webhdfs");
        BLOCK_FS_SCHEMES.add("viewfs");
        COPY_BUFFER = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[8192];
            }
        };
    }

    private static class PaddingAlignment
    implements AlignmentStrategy {
        private static final byte[] zeros = new byte[4096];
        protected final long dfsBlockSize;
        protected final long rowGroupSize;
        protected final int maxPaddingSize;

        public static PaddingAlignment get(long dfsBlockSize, long rowGroupSize, int maxPaddingSize) {
            return new PaddingAlignment(dfsBlockSize, rowGroupSize, maxPaddingSize);
        }

        private PaddingAlignment(long dfsBlockSize, long rowGroupSize, int maxPaddingSize) {
            this.dfsBlockSize = dfsBlockSize;
            this.rowGroupSize = rowGroupSize;
            this.maxPaddingSize = maxPaddingSize;
        }

        @Override
        public void alignForRowGroup(FSDataOutputStream out) throws IOException {
            long remaining = this.dfsBlockSize - out.getPos() % this.dfsBlockSize;
            if (this.isPaddingNeeded(remaining)) {
                LOG.debug("Adding {} bytes of padding (row group size={}B, block size={}B)", new Object[]{remaining, this.rowGroupSize, this.dfsBlockSize});
                while (remaining > 0L) {
                    out.write(zeros, 0, (int)Math.min((long)zeros.length, remaining));
                    remaining -= (long)zeros.length;
                }
            }
        }

        @Override
        public long nextRowGroupSize(FSDataOutputStream out) throws IOException {
            if (this.maxPaddingSize <= 0) {
                return this.rowGroupSize;
            }
            long remaining = this.dfsBlockSize - out.getPos() % this.dfsBlockSize;
            if (this.isPaddingNeeded(remaining)) {
                return this.rowGroupSize;
            }
            return Math.min(remaining, this.rowGroupSize);
        }

        protected boolean isPaddingNeeded(long remaining) {
            return remaining <= (long)this.maxPaddingSize;
        }
    }

    private static class NoAlignment
    implements AlignmentStrategy {
        private final long rowGroupSize;

        public static NoAlignment get(long rowGroupSize) {
            return new NoAlignment(rowGroupSize);
        }

        private NoAlignment(long rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
        }

        @Override
        public void alignForRowGroup(FSDataOutputStream out) {
        }

        @Override
        public long nextRowGroupSize(FSDataOutputStream out) {
            return this.rowGroupSize;
        }
    }

    private static interface AlignmentStrategy {
        public void alignForRowGroup(FSDataOutputStream var1) throws IOException;

        public long nextRowGroupSize(FSDataOutputStream var1) throws IOException;
    }

    private static enum STATE {
        NOT_STARTED{

            @Override
            STATE start() {
                return STARTED;
            }
        }
        ,
        STARTED{

            @Override
            STATE startBlock() {
                return BLOCK;
            }

            @Override
            STATE end() {
                return ENDED;
            }
        }
        ,
        BLOCK{

            @Override
            STATE startColumn() {
                return COLUMN;
            }

            @Override
            STATE endBlock() {
                return STARTED;
            }
        }
        ,
        COLUMN{

            @Override
            STATE endColumn() {
                return BLOCK;
            }

            @Override
            STATE write() {
                return this;
            }
        }
        ,
        ENDED;


        STATE start() throws IOException {
            return this.error();
        }

        STATE startBlock() throws IOException {
            return this.error();
        }

        STATE startColumn() throws IOException {
            return this.error();
        }

        STATE write() throws IOException {
            return this.error();
        }

        STATE endColumn() throws IOException {
            return this.error();
        }

        STATE endBlock() throws IOException {
            return this.error();
        }

        STATE end() throws IOException {
            return this.error();
        }

        private final STATE error() throws IOException {
            throw new IOException("The file being written is in an invalid state. Probably caused by an error thrown previously. Current state: " + this.name());
        }
    }

    public static enum Mode {
        CREATE,
        OVERWRITE;

    }
}

