/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class RecordMergeTypeComputer
implements IResultTypeComputer {
    public static final RecordMergeTypeComputer INSTANCE = new RecordMergeTypeComputer(false);
    public static final RecordMergeTypeComputer INSTANCE_IGNORE_DUPLICATES = new RecordMergeTypeComputer(true);
    private final boolean isIgnoreDuplicates;

    private RecordMergeTypeComputer(boolean isIgnoreDuplicates) {
        this.isIgnoreDuplicates = isIgnoreDuplicates;
    }

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
        FunctionIdentifier funcId = f.getFunctionIdentifier();
        IAType t0 = (IAType)env.getType((ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue());
        IAType t1 = (IAType)env.getType((ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue());
        boolean unknownable = TypeHelper.canBeUnknown(t0) || TypeHelper.canBeUnknown(t1);
        ARecordType recType0 = TypeComputeUtils.extractRecordType(t0);
        if (recType0 == null) {
            throw new TypeMismatchException(f.getSourceLocation(), funcId, 0, t0.getTypeTag(), ATypeTag.OBJECT);
        }
        ARecordType recType1 = TypeComputeUtils.extractRecordType(t1);
        if (recType1 == null) {
            throw new TypeMismatchException(f.getSourceLocation(), funcId, 1, t1.getTypeTag(), ATypeTag.OBJECT);
        }
        ArrayList<String> resultFieldNames = new ArrayList<String>();
        for (String fieldName : recType0.getFieldNames()) {
            resultFieldNames.add(fieldName);
        }
        Collections.sort(resultFieldNames);
        ArrayList<IAType> resultFieldTypes = new ArrayList<IAType>();
        for (String fieldName : resultFieldNames) {
            if (recType0.getFieldType(fieldName).getTypeTag() == ATypeTag.OBJECT) {
                ARecordType nestedType = (ARecordType)recType0.getFieldType(fieldName);
                resultFieldTypes.add(nestedType.deepCopy(nestedType));
                continue;
            }
            resultFieldTypes.add(recType0.getFieldType(fieldName));
        }
        ArrayList<String> additionalFieldNames = new ArrayList<String>();
        ArrayList<IAType> additionalFieldTypes = new ArrayList<IAType>();
        String[] fieldNames = recType1.getFieldNames();
        IAType[] fieldTypes = recType1.getFieldTypes();
        for (int i = 0; i < fieldNames.length; ++i) {
            int pos = Collections.binarySearch(resultFieldNames, fieldNames[i]);
            if (pos >= 0) {
                IAType resultFieldType = (IAType)resultFieldTypes.get(pos);
                if (resultFieldType.getTypeTag() != fieldTypes[i].getTypeTag()) {
                    if (this.isIgnoreDuplicates) continue;
                    throw new CompilationException(ErrorCode.COMPILATION_DUPLICATE_FIELD_NAME, f.getSourceLocation(), new Serializable[]{fieldNames[i]});
                }
                if (fieldTypes[i].getTypeTag() != ATypeTag.OBJECT) continue;
                resultFieldTypes.set(pos, this.mergedNestedType(fieldNames[i], fieldTypes[i], resultFieldType, f.getSourceLocation()));
                continue;
            }
            additionalFieldNames.add(fieldNames[i]);
            additionalFieldTypes.add(fieldTypes[i]);
        }
        resultFieldNames.addAll(additionalFieldNames);
        resultFieldTypes.addAll(additionalFieldTypes);
        String resultTypeName = "merged(" + recType0.getTypeName() + ", " + recType1.getTypeName() + ")";
        boolean isOpen = recType0.isOpen() || recType1.isOpen();
        IAType resultType = new ARecordType(resultTypeName, resultFieldNames.toArray(new String[0]), resultFieldTypes.toArray(new IAType[0]), isOpen);
        if (unknownable) {
            resultType = AUnionType.createUnknownableType(resultType);
        }
        return resultType;
    }

    private IAType mergedNestedType(String fieldName, IAType fieldType1, IAType fieldType0, SourceLocation sourceLoc) throws AlgebricksException {
        if (fieldType1.getTypeTag() != ATypeTag.OBJECT || fieldType0.getTypeTag() != ATypeTag.OBJECT) {
            throw new CompilationException(ErrorCode.COMPILATION_DUPLICATE_FIELD_NAME, sourceLoc, new Serializable[]{fieldName});
        }
        ARecordType resultType = (ARecordType)fieldType0;
        ARecordType fieldType1Copy = (ARecordType)fieldType1;
        for (int i = 0; i < fieldType1Copy.getFieldTypes().length; ++i) {
            String fname = fieldType1Copy.getFieldNames()[i];
            int pos = resultType.getFieldIndex(fname);
            if (pos >= 0) {
                if (fieldType1Copy.getFieldTypes()[i].getTypeTag() != ATypeTag.OBJECT) continue;
                IAType[] oldTypes = resultType.getFieldTypes();
                oldTypes[pos] = this.mergedNestedType(fname, fieldType1Copy.getFieldTypes()[i], resultType.getFieldTypes()[pos], sourceLoc);
                resultType = new ARecordType(resultType.getTypeName(), resultType.getFieldNames(), oldTypes, resultType.isOpen());
                continue;
            }
            IAType[] combinedFieldTypes = (IAType[])ArrayUtils.addAll((Object[])((IAType[])resultType.getFieldTypes().clone()), (Object[])new IAType[]{fieldType1Copy.getFieldTypes()[i]});
            resultType = new ARecordType(resultType.getTypeName(), (String[])ArrayUtils.addAll((Object[])resultType.getFieldNames(), (Object[])new String[]{fieldType1Copy.getFieldNames()[i]}), combinedFieldTypes, resultType.isOpen());
        }
        return resultType;
    }
}

