/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.ipc.impl.HandleState;
import org.apache.hyracks.ipc.impl.IPCHandle;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.Message;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPCConnectionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INITIAL_RETRY_DELAY_MILLIS = 100;
    private static final int MAX_RETRY_DELAY_MILLIS = 15000;
    private static final int MAX_STOP_JOIN_WAIT_MILLIS = 30000;
    private final IPCSystem system;
    private final NetworkThread networkThread;
    private final ServerSocketChannel serverSocketChannel;
    private final Map<InetSocketAddress, IPCHandle> ipcHandleMap;
    private final List<IPCHandle> pendingConnections;
    private final List<IPCHandle> workingPendingConnections;
    private final List<Message> sendList;
    private final List<Message> workingSendList;
    private final InetSocketAddress address;
    private volatile boolean stopped;
    private final ISocketChannelFactory socketChannelFactory;

    IPCConnectionManager(IPCSystem system, InetSocketAddress socketAddress, ISocketChannelFactory socketChannelFactory) throws IOException {
        this.system = system;
        this.socketChannelFactory = socketChannelFactory;
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.socket().setReuseAddress(true);
        this.serverSocketChannel.configureBlocking(false);
        ServerSocket socket = this.serverSocketChannel.socket();
        socket.bind(socketAddress);
        this.address = new InetSocketAddress(socket.getInetAddress(), socket.getLocalPort());
        this.networkThread = new NetworkThread();
        this.networkThread.setPriority(10);
        this.ipcHandleMap = new HashMap<InetSocketAddress, IPCHandle>();
        this.pendingConnections = new ArrayList<IPCHandle>();
        this.workingPendingConnections = new ArrayList<IPCHandle>();
        this.sendList = new ArrayList<Message>();
        this.workingSendList = new ArrayList<Message>();
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    void start() {
        this.stopped = false;
        this.networkThread.start();
    }

    void stop() {
        this.stopped = true;
        NetworkUtil.closeQuietly((Closeable)this.serverSocketChannel);
        this.networkThread.selector.wakeup();
        InvokeUtil.doUninterruptibly(() -> this.networkThread.join(30000L));
        if (this.networkThread.isAlive()) {
            LOGGER.warn("giving up after waiting {}s for networkThread to exit", (Object)TimeUnit.MILLISECONDS.toSeconds(30000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPCHandle getIPCHandle(InetSocketAddress remoteAddress, int maxRetries) throws IOException, InterruptedException {
        int retries = 0;
        int delay = 100;
        while (true) {
            IPCHandle handle;
            IPCConnectionManager iPCConnectionManager = this;
            synchronized (iPCConnectionManager) {
                handle = this.ipcHandleMap.get(remoteAddress);
                if (handle == null || !handle.isConnected()) {
                    handle = new IPCHandle(this.system, remoteAddress);
                    this.pendingConnections.add(handle);
                    this.networkThread.selector.wakeup();
                }
            }
            if (handle.waitTillConnected()) {
                return handle;
            }
            if (maxRetries >= 0 && retries++ >= maxRetries) break;
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Connection to " + remoteAddress + " failed; retrying" + (String)(maxRetries <= 0 ? "" : " (retry attempt " + retries + " of " + maxRetries + ") after " + delay + "ms"));
            }
            Thread.sleep(delay);
            delay = Math.min(15000, (int)((double)delay * 1.5));
        }
        throw new IOException("Connection failed to " + remoteAddress);
    }

    synchronized void registerHandle(IPCHandle handle) {
        this.ipcHandleMap.put(handle.getRemoteAddress(), handle);
    }

    synchronized void unregisterHandle(IPCHandle handle) {
        IPCHandle ipcHandle;
        InetSocketAddress remoteAddress = handle.getRemoteAddress();
        if (remoteAddress != null && (ipcHandle = this.ipcHandleMap.get(remoteAddress)) != null && ipcHandle.getState() == HandleState.CLOSED) {
            this.ipcHandleMap.remove(remoteAddress);
        }
    }

    synchronized void send(Message msg) throws IPCException {
        if (this.stopped) {
            throw new IPCException("ipc system has been stopped");
        }
        this.write(msg);
    }

    private synchronized void write(Message msg) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Enqueued message: " + msg);
        }
        this.sendList.add(msg);
        this.networkThread.selector.wakeup();
    }

    private Message createInitialAckMessage(IPCHandle handle, Message req) {
        Message msg = new Message(handle);
        msg.setMessageId(this.system.createMessageId());
        msg.setRequestMessageId(req.getMessageId());
        msg.setFlag((byte)2);
        msg.setPayload(null);
        return msg;
    }

    void ack(IPCHandle handle, Message req) {
        this.write(this.createInitialAckMessage(handle, req));
    }

    private class NetworkThread
    extends Thread {
        private final Selector selector;
        private final Set<SocketChannel> openChannels;
        private final BitSet unsentMessagesBitmap;
        private final List<Message> tempUnsentMessages;

        NetworkThread() {
            super("IPC Network Listener Thread [" + IPCConnectionManager.this.address + "]");
            this.openChannels = new HashSet<SocketChannel>();
            this.unsentMessagesBitmap = new BitSet();
            this.tempUnsentMessages = new ArrayList<Message>();
            this.setDaemon(true);
            try {
                this.selector = Selector.open();
                IPCConnectionManager.this.serverSocketChannel.register(this.selector, 16);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            finally {
                this.cleanup();
            }
        }

        private void doRun() {
            int n;
            while (!IPCConnectionManager.this.stopped) {
                try {
                    n = this.selector.select();
                    this.collectOutstandingWork();
                    if (!IPCConnectionManager.this.workingPendingConnections.isEmpty()) {
                        this.establishPendingConnections();
                    }
                    if (!IPCConnectionManager.this.workingSendList.isEmpty()) {
                        this.sendPendingMessages();
                    }
                    if (n <= 0) continue;
                    this.processSelectedKeys();
                }
                catch (Exception e) {
                    LOGGER.error("Exception processing message", (Throwable)e);
                }
            }
            this.collectOutstandingWork();
            LOGGER.trace("had {} pending messages at stop time!", (Object)IPCConnectionManager.this.workingSendList.size());
            if (!IPCConnectionManager.this.workingSendList.isEmpty()) {
                this.sendPendingMessages();
            }
            try {
                n = this.selector.selectNow();
                LOGGER.trace("had {} keys remaining at stop time!", (Object)n);
                if (n > 0) {
                    this.processSelectedKeys();
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception processing message", (Throwable)e);
            }
        }

        private void processSelectedKeys() {
            Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
            while (i.hasNext()) {
                SelectionKey key = i.next();
                i.remove();
                SelectableChannel sc = key.channel();
                if (key.isReadable() && key.attachment() != null) {
                    this.read(key);
                    continue;
                }
                if (key.isWritable() && key.attachment() != null) {
                    this.write(key);
                    continue;
                }
                if (key.isAcceptable()) {
                    assert (sc == IPCConnectionManager.this.serverSocketChannel);
                    this.accept();
                    continue;
                }
                if (!key.isConnectable()) continue;
                this.finishConnect(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishConnect(SelectionKey connectableKey) {
            SocketChannel channel = (SocketChannel)connectableKey.channel();
            IPCHandle handle = (IPCHandle)connectableKey.attachment();
            boolean connected = false;
            try {
                connected = channel.finishConnect();
                if (connected) {
                    SelectionKey channelKey = channel.register(this.selector, 1);
                    ISocketChannel clientChannel = IPCConnectionManager.this.socketChannelFactory.createClientChannel(channel);
                    if (clientChannel.requiresHandshake()) {
                        this.asyncHandshake(clientChannel, handle, channelKey);
                    } else {
                        this.connectionEstablished(handle, channelKey, clientChannel);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception finishing connect", (Throwable)e);
            }
            finally {
                if (!connected) {
                    LOGGER.warn("Failed to finish connect to {}", (Object)handle.getRemoteAddress());
                    this.close(connectableKey, channel);
                }
            }
        }

        private void accept() {
            SocketChannel channel = null;
            SelectionKey channelKey = null;
            try {
                channel = IPCConnectionManager.this.serverSocketChannel.accept();
                this.register(channel);
                ISocketChannel serverChannel = IPCConnectionManager.this.socketChannelFactory.createServerChannel(channel);
                channelKey = channel.register(this.selector, 1);
                if (serverChannel.requiresHandshake()) {
                    this.asyncHandshake(serverChannel, null, channelKey);
                } else {
                    this.connectionReceived(serverChannel, channelKey);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to accept channel ", (Throwable)e);
                this.close(channelKey, channel);
            }
        }

        private void establishPendingConnections() {
            for (IPCHandle handle : IPCConnectionManager.this.workingPendingConnections) {
                SocketChannel channel = null;
                SelectionKey channelKey = null;
                try {
                    channel = SocketChannel.open();
                    this.register(channel);
                    if (channel.connect(handle.getRemoteAddress())) {
                        channelKey = channel.register(this.selector, 1);
                        ISocketChannel clientChannel = IPCConnectionManager.this.socketChannelFactory.createClientChannel(channel);
                        if (clientChannel.requiresHandshake()) {
                            this.asyncHandshake(clientChannel, handle, channelKey);
                            continue;
                        }
                        this.connectionEstablished(handle, channelKey, clientChannel);
                        continue;
                    }
                    channelKey = channel.register(this.selector, 8);
                    handle.setKey(channelKey);
                    channelKey.attach(handle);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to accept channel ", (Throwable)e);
                    this.close(channelKey, channel);
                    handle.setState(HandleState.CLOSED);
                }
            }
            IPCConnectionManager.this.workingPendingConnections.clear();
        }

        private void connectionEstablished(IPCHandle handle, SelectionKey channelKey, ISocketChannel channel) {
            handle.setSocketChannel(channel);
            handle.setState(HandleState.CONNECT_SENT);
            handle.setKey(channelKey);
            IPCConnectionManager.this.registerHandle(handle);
            IPCConnectionManager.this.write(this.createInitialReqMessage(handle));
            channelKey.attach(handle);
        }

        private void sendPendingMessages() {
            this.unsentMessagesBitmap.clear();
            int len = IPCConnectionManager.this.workingSendList.size();
            for (int i = 0; i < len; ++i) {
                Message msg = IPCConnectionManager.this.workingSendList.get(i);
                boolean sent = this.sendMessage(msg);
                if (sent) continue;
                this.unsentMessagesBitmap.set(i);
            }
            this.copyUnsentMessages(this.unsentMessagesBitmap, this.tempUnsentMessages);
        }

        private boolean sendMessage(Message msg) {
            LOGGER.trace("Processing send of message: {}", (Object)msg);
            IPCHandle handle = msg.getIPCHandle();
            if (handle.getState() == HandleState.CLOSED) {
                LOGGER.info("Could not send message: {}, due to {}", (Object)msg, (Object)handle);
                return true;
            }
            if (handle.full()) {
                return false;
            }
            try {
                while (true) {
                    ByteBuffer buffer = handle.getOutBuffer();
                    buffer.compact();
                    boolean success = msg.write(buffer);
                    buffer.flip();
                    if (success) {
                        IPCConnectionManager.this.system.getPerformanceCounters().addMessageSentCount(1L);
                        SelectionKey key = handle.getKey();
                        key.interestOps(key.interestOps() | 4);
                        return true;
                    }
                    if (buffer.hasRemaining()) break;
                    handle.resizeOutBuffer();
                }
                handle.markFull();
                return false;
            }
            catch (Exception e) {
                LOGGER.fatal("Unrecoverable networking failure; Halting...", (Throwable)e);
                ExitUtil.halt((int)16);
                return false;
            }
        }

        private void cleanup() {
            for (Channel channel : this.openChannels) {
                NetworkUtil.closeQuietly((Closeable)channel);
            }
            this.openChannels.clear();
            NetworkUtil.closeQuietly((Closeable)this.selector);
        }

        private void copyUnsentMessages(BitSet unsentMessagesBitmap, List<Message> tempUnsentMessages) {
            assert (tempUnsentMessages.isEmpty());
            int i = unsentMessagesBitmap.nextSetBit(0);
            while (i >= 0) {
                tempUnsentMessages.add(IPCConnectionManager.this.workingSendList.get(i));
                i = unsentMessagesBitmap.nextSetBit(i + 1);
            }
            IPCConnectionManager.this.workingSendList.clear();
            this.moveAll(tempUnsentMessages, IPCConnectionManager.this.workingSendList);
        }

        private void register(SocketChannel channel) throws IOException {
            this.openChannels.add(channel);
            NetworkUtil.configure((SocketChannel)channel);
            channel.configureBlocking(false);
        }

        private void read(SelectionKey readableKey) {
            SocketChannel channel = (SocketChannel)readableKey.channel();
            IPCHandle handle = (IPCHandle)readableKey.attachment();
            ByteBuffer readBuffer = handle.getInBuffer();
            try {
                int len = handle.getSocketChannel().read(readBuffer);
                if (len < 0) {
                    this.close(readableKey, channel);
                    return;
                }
                IPCConnectionManager.this.system.getPerformanceCounters().addMessageBytesReceived(len);
                handle.processIncomingMessages();
                if (!readBuffer.hasRemaining()) {
                    handle.resizeInBuffer();
                }
            }
            catch (Exception e) {
                LOGGER.error("TCP read error from {}", (Object)handle.getRemoteAddress(), (Object)e);
                this.close(readableKey, channel);
            }
        }

        private void write(SelectionKey writableKey) {
            SocketChannel channel = (SocketChannel)writableKey.channel();
            IPCHandle handle = (IPCHandle)writableKey.attachment();
            ISocketChannel socketChannel = handle.getSocketChannel();
            ByteBuffer writeBuffer = handle.getOutBuffer();
            try {
                int len = socketChannel.write(writeBuffer);
                if (len < 0) {
                    this.close(writableKey, channel);
                    return;
                }
                IPCConnectionManager.this.system.getPerformanceCounters().addMessageBytesSent(len);
                if (!writeBuffer.hasRemaining() && !socketChannel.isPendingWrite()) {
                    writableKey.interestOps(writableKey.interestOps() & 0xFFFFFFFB);
                }
                if (handle.full()) {
                    handle.clearFull();
                    this.selector.wakeup();
                }
            }
            catch (Exception e) {
                LOGGER.error("TCP write error to {}", (Object)handle.getRemoteAddress(), (Object)e);
                this.close(writableKey, channel);
            }
        }

        private void close(SelectionKey key, SocketChannel sc) {
            if (key != null) {
                Object attachment = key.attachment();
                if (attachment != null) {
                    IPCHandle handle = (IPCHandle)attachment;
                    this.closeHandle(handle);
                }
                key.cancel();
            }
            if (sc != null) {
                NetworkUtil.closeQuietly((Closeable)sc);
                this.openChannels.remove(sc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectOutstandingWork() {
            IPCConnectionManager iPCConnectionManager = IPCConnectionManager.this;
            synchronized (iPCConnectionManager) {
                if (!IPCConnectionManager.this.pendingConnections.isEmpty()) {
                    this.moveAll(IPCConnectionManager.this.pendingConnections, IPCConnectionManager.this.workingPendingConnections);
                }
                if (!IPCConnectionManager.this.sendList.isEmpty()) {
                    this.moveAll(IPCConnectionManager.this.sendList, IPCConnectionManager.this.workingSendList);
                }
            }
        }

        private Message createInitialReqMessage(IPCHandle handle) {
            Message msg = new Message(handle);
            msg.setMessageId(IPCConnectionManager.this.system.createMessageId());
            msg.setRequestMessageId(-1L);
            msg.setFlag((byte)1);
            msg.setPayload(IPCConnectionManager.this.address);
            return msg;
        }

        private <T> void moveAll(List<T> source, List<T> target) {
            target.addAll(source);
            source.clear();
        }

        private void asyncHandshake(ISocketChannel socketChannel, IPCHandle handle, SelectionKey channelKey) {
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> ((ISocketChannel)socketChannel).handshake()).exceptionally(ex -> false)).thenAccept(handshakeSuccess -> this.handleHandshakeCompletion((Boolean)handshakeSuccess, socketChannel, handle, channelKey));
        }

        private void handleHandshakeCompletion(Boolean handshakeSuccess, ISocketChannel socketChannel, IPCHandle handle, SelectionKey channelKey) {
            if (handshakeSuccess.booleanValue()) {
                if (handle == null) {
                    this.connectionReceived(socketChannel, channelKey);
                } else {
                    this.connectionEstablished(handle, channelKey, socketChannel);
                }
            } else {
                this.closeHandle(handle);
                this.close(channelKey, socketChannel.getSocketChannel());
            }
        }

        private void connectionReceived(ISocketChannel channel, SelectionKey channelKey) {
            IPCHandle handle = new IPCHandle(IPCConnectionManager.this.system, null);
            handle.setState(HandleState.CONNECT_RECEIVED);
            handle.setSocketChannel(channel);
            handle.setKey(channelKey);
            channelKey.attach(handle);
        }

        private void closeHandle(IPCHandle handle) {
            if (handle != null) {
                handle.close();
                IPCConnectionManager.this.unregisterHandle(handle);
            }
        }
    }
}

