/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.aggregators;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IFieldAggregateDescriptor;
import org.apache.hyracks.dataflow.std.group.IFieldAggregateDescriptorFactory;

public class AvgFieldGroupAggregatorFactory
implements IFieldAggregateDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final int aggField;
    private final boolean useObjectState;

    public AvgFieldGroupAggregatorFactory(int aggField, boolean useObjectState) {
        this.aggField = aggField;
        this.useObjectState = useObjectState;
    }

    @Override
    public IFieldAggregateDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor) throws HyracksDataException {
        return new IFieldAggregateDescriptor(){

            @Override
            public void reset() {
            }

            @Override
            public void outputPartialResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int count;
                int sum;
                if (!AvgFieldGroupAggregatorFactory.this.useObjectState) {
                    sum = IntegerPointable.getInteger((byte[])data, (int)offset);
                    count = IntegerPointable.getInteger((byte[])data, (int)(offset + 4));
                } else {
                    Integer[] fields = (Integer[])state.state;
                    sum = fields[0];
                    count = fields[1];
                }
                try {
                    fieldOutput.writeInt(sum);
                    fieldOutput.writeInt(count);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void outputFinalResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int count;
                int sum;
                if (!AvgFieldGroupAggregatorFactory.this.useObjectState) {
                    sum = IntegerPointable.getInteger((byte[])data, (int)offset);
                    count = IntegerPointable.getInteger((byte[])data, (int)(offset + 4));
                } else {
                    Integer[] fields = (Integer[])state.state;
                    sum = fields[0];
                    count = fields[1];
                }
                try {
                    fieldOutput.writeFloat((float)sum / (float)count);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void init(IFrameTupleAccessor accessor, int tIndex, DataOutput fieldOutput, AggregateState state) throws HyracksDataException {
                int sum = 0;
                int count = 0;
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, AvgFieldGroupAggregatorFactory.this.aggField);
                sum += IntegerPointable.getInteger((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart));
                ++count;
                if (!AvgFieldGroupAggregatorFactory.this.useObjectState) {
                    try {
                        fieldOutput.writeInt(sum);
                        fieldOutput.writeInt(count);
                    }
                    catch (IOException e) {
                        throw new HyracksDataException("I/O exception when initializing the aggregator.");
                    }
                } else {
                    state.state = new Integer[]{sum, count};
                }
            }

            @Override
            public void close() {
            }

            @Override
            public void aggregate(IFrameTupleAccessor accessor, int tIndex, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int sum = 0;
                int count = 0;
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, AvgFieldGroupAggregatorFactory.this.aggField);
                sum += IntegerPointable.getInteger((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart));
                ++count;
                if (!AvgFieldGroupAggregatorFactory.this.useObjectState) {
                    ByteBuffer buf = ByteBuffer.wrap(data);
                    buf.putInt(offset, sum += buf.getInt(offset));
                    buf.putInt(offset + 4, count += buf.getInt(offset + 4));
                } else {
                    Integer[] fields = (Integer[])state.state;
                    state.state = new Integer[]{sum += fields[0].intValue(), count += fields[1].intValue()};
                }
            }

            @Override
            public boolean needsObjectState() {
                return AvgFieldGroupAggregatorFactory.this.useObjectState;
            }

            @Override
            public boolean needsBinaryState() {
                return !AvgFieldGroupAggregatorFactory.this.useObjectState;
            }

            @Override
            public AggregateState createState() {
                return new AggregateState(new Integer[]{0, 0});
            }
        };
    }
}

