/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group;

import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFamily;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.FramePoolBackedFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IDeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.IPartitionedTupleBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.ITuplePointerAccessor;
import org.apache.hyracks.dataflow.std.buffermanager.PreferToSpillFullyOccupiedFramePolicy;
import org.apache.hyracks.dataflow.std.buffermanager.VPartitionTupleBufferManager;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.AggregateType;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptor;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.ISpillableTable;
import org.apache.hyracks.dataflow.std.group.ISpillableTableFactory;
import org.apache.hyracks.dataflow.std.structures.ISerializableTable;
import org.apache.hyracks.dataflow.std.structures.SerializableHashTable;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;
import org.apache.hyracks.dataflow.std.util.FrameTuplePairComparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HashSpillableTableFactory
implements ISpillableTableFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double FUDGE_FACTOR = 1.1;
    private static final long serialVersionUID = 1L;
    private final IBinaryHashFunctionFamily[] hashFunctionFamilies;
    private static final int MIN_DATA_TABLE_FRAME_LIMT = 1;
    private static final int MIN_HASH_TABLE_FRAME_LIMT = 2;
    private static final int OUTPUT_FRAME_LIMT = 1;
    private static final int MIN_FRAME_LIMT = 4;

    public HashSpillableTableFactory(IBinaryHashFunctionFamily[] hashFunctionFamilies) {
        this.hashFunctionFamilies = hashFunctionFamilies;
    }

    @Override
    public ISpillableTable buildSpillableTable(final IHyracksTaskContext ctx, int suggestTableSize, long inputDataBytesSize, int[] gbyFields, int[] fdFields, IBinaryComparator[] comparators, INormalizedKeyComputer firstKeyNormalizerFactory, IAggregatorDescriptorFactory aggregateFactory, RecordDescriptor inRecordDescriptor, final RecordDescriptor outRecordDescriptor, final int framesLimit, int seed) throws HyracksDataException {
        int[] intermediateResultAllFields;
        int[] allFields;
        final int tableSize = suggestTableSize;
        if (framesLimit < 4) {
            throw new HyracksDataException("The given frame limit is too small to partition the data.");
        }
        int[] intermediateResultGbyFields = new int[gbyFields.length];
        for (int i = 0; i < gbyFields.length; ++i) {
            intermediateResultGbyFields[i] = i;
        }
        if (fdFields == null) {
            allFields = gbyFields;
            intermediateResultAllFields = intermediateResultGbyFields;
        } else {
            allFields = new int[gbyFields.length + fdFields.length];
            intermediateResultAllFields = new int[gbyFields.length + fdFields.length];
            int k = 0;
            int position = 0;
            int i = 0;
            while (i < gbyFields.length) {
                allFields[k] = gbyFields[i];
                intermediateResultAllFields[k] = position++;
                ++i;
                ++k;
            }
            i = 0;
            while (i < fdFields.length) {
                allFields[k] = fdFields[i];
                intermediateResultAllFields[k] = position++;
                ++i;
                ++k;
            }
        }
        final FrameTuplePairComparator ftpcInputCompareToAggregate = new FrameTuplePairComparator(gbyFields, intermediateResultGbyFields, comparators);
        final ITuplePartitionComputer tpc = new FieldHashPartitionComputerFamily(gbyFields, this.hashFunctionFamilies).createPartitioner(seed);
        final ITuplePartitionComputer tpcIntermediate = new FieldHashPartitionComputerFamily(intermediateResultGbyFields, this.hashFunctionFamilies).createPartitioner(seed);
        final IAggregatorDescriptor aggregator = aggregateFactory.createAggregator(ctx, inRecordDescriptor, outRecordDescriptor, allFields, intermediateResultAllFields, null, -1L);
        final AggregateState aggregateState = aggregator.createAggregateStates();
        final ArrayTupleBuilder stateTupleBuilder = new ArrayTupleBuilder(outRecordDescriptor.getFields().length);
        long memoryBudget = Math.max(3, framesLimit - 1 - 2);
        final int numPartitions = this.getNumOfPartitions(inputDataBytesSize / (long)ctx.getInitialFrameSize(), memoryBudget);
        final int entriesPerPartition = (int)Math.ceil(1.0 * (double)tableSize / (double)numPartitions);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("created hashtable, table size:" + tableSize + " file size:" + inputDataBytesSize + "  #partitions:" + numPartitions);
        }
        final ArrayTupleBuilder outputTupleBuilder = new ArrayTupleBuilder(outRecordDescriptor.getFields().length);
        return new ISpillableTable(){
            private final TuplePointer pointer = new TuplePointer();
            private final BitSet spilledSet = new BitSet(numPartitions);
            private final IDeallocatableFramePool framePool = new DeallocatableFramePool((IHyracksFrameMgrContext)ctx, framesLimit * ctx.getInitialFrameSize());
            private final ISimpleFrameBufferManager bufferManagerForHashTable = new FramePoolBackedFrameBufferManager(this.framePool);
            private final ISerializableTable hashTableForTuplePointer = new SerializableHashTable(tableSize, (IHyracksFrameMgrContext)ctx, this.bufferManagerForHashTable);
            final IPartitionedTupleBufferManager bufferManager = new VPartitionTupleBufferManager(PreferToSpillFullyOccupiedFramePolicy.createAtMostOneFrameForSpilledPartitionConstrain(this.spilledSet), numPartitions, this.framePool);
            final ITuplePointerAccessor bufferAccessor = this.bufferManager.getTuplePointerAccessor(outRecordDescriptor);
            private final PreferToSpillFullyOccupiedFramePolicy spillPolicy = new PreferToSpillFullyOccupiedFramePolicy(this.bufferManager, this.spilledSet);
            private final FrameTupleAppender outputAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));

            @Override
            public void close() throws HyracksDataException {
                this.hashTableForTuplePointer.close();
                aggregator.close();
            }

            @Override
            public void clear(int partition) throws HyracksDataException {
                for (int p = this.getFirstEntryInHashTable(partition); p < this.getLastEntryInHashTable(partition); ++p) {
                    this.hashTableForTuplePointer.delete(p);
                }
                if (this.hashTableForTuplePointer.isGarbageCollectionNeeded()) {
                    int numberOfFramesReclaimed = this.hashTableForTuplePointer.collectGarbage(this.bufferAccessor, tpcIntermediate);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Garbage Collection on Hash table is done. Deallocated frames:" + numberOfFramesReclaimed);
                    }
                }
                this.bufferManager.clearPartition(partition);
            }

            private int getPartition(int entryInHashTable) {
                return entryInHashTable / entriesPerPartition;
            }

            private int getFirstEntryInHashTable(int partition) {
                return partition * entriesPerPartition;
            }

            private int getLastEntryInHashTable(int partition) {
                return Math.min(tableSize, (partition + 1) * entriesPerPartition);
            }

            @Override
            public boolean insert(IFrameTupleAccessor accessor, int tIndex) throws HyracksDataException {
                int entryInHashTable = tpc.partition(accessor, tIndex, tableSize);
                for (int i = 0; i < this.hashTableForTuplePointer.getTupleCount(entryInHashTable); ++i) {
                    this.hashTableForTuplePointer.getTuplePointer(entryInHashTable, i, this.pointer);
                    this.bufferAccessor.reset(this.pointer);
                    int c = ftpcInputCompareToAggregate.compare(accessor, tIndex, this.bufferAccessor);
                    if (c != 0) continue;
                    this.aggregateExistingTuple(accessor, tIndex, this.bufferAccessor, this.pointer.getTupleIndex());
                    return true;
                }
                return this.insertNewAggregateEntry(entryInHashTable, accessor, tIndex);
            }

            private boolean insertNewAggregateEntry(int entryInHashTable, IFrameTupleAccessor accessor, int tIndex) throws HyracksDataException {
                this.initStateTupleBuilder(accessor, tIndex);
                int pid = this.getPartition(entryInHashTable);
                if (!this.bufferManager.insertTuple(pid, stateTupleBuilder.getByteArray(), stateTupleBuilder.getFieldEndOffsets(), 0, stateTupleBuilder.getSize(), this.pointer)) {
                    return false;
                }
                if (!this.hashTableForTuplePointer.insert(entryInHashTable, this.pointer)) {
                    this.bufferManager.cancelInsertTuple(pid);
                    return false;
                }
                return true;
            }

            private void initStateTupleBuilder(IFrameTupleAccessor accessor, int tIndex) throws HyracksDataException {
                stateTupleBuilder.reset();
                for (int k = 0; k < allFields.length; ++k) {
                    stateTupleBuilder.addField(accessor, tIndex, allFields[k]);
                }
                aggregator.init(stateTupleBuilder, accessor, tIndex, aggregateState);
            }

            private void aggregateExistingTuple(IFrameTupleAccessor accessor, int tIndex, ITuplePointerAccessor bufferAccessor, int tupleIndex) throws HyracksDataException {
                aggregator.aggregate(accessor, tIndex, bufferAccessor, tupleIndex, aggregateState);
            }

            @Override
            public int flushFrames(int partition, IFrameWriter writer, AggregateType type) throws HyracksDataException {
                int count = 0;
                for (int hashEntryPid = this.getFirstEntryInHashTable(partition); hashEntryPid < this.getLastEntryInHashTable(partition); ++hashEntryPid) {
                    count += this.hashTableForTuplePointer.getTupleCount(hashEntryPid);
                    for (int tid = 0; tid < this.hashTableForTuplePointer.getTupleCount(hashEntryPid); ++tid) {
                        this.hashTableForTuplePointer.getTuplePointer(hashEntryPid, tid, this.pointer);
                        this.bufferAccessor.reset(this.pointer);
                        outputTupleBuilder.reset();
                        for (int k = 0; k < intermediateResultAllFields.length; ++k) {
                            outputTupleBuilder.addField(this.bufferAccessor.getBuffer().array(), this.bufferAccessor.getAbsFieldStartOffset(intermediateResultAllFields[k]), this.bufferAccessor.getFieldLength(intermediateResultAllFields[k]));
                        }
                        boolean hasOutput = false;
                        switch (type) {
                            case PARTIAL: {
                                hasOutput = aggregator.outputPartialResult(outputTupleBuilder, this.bufferAccessor, this.pointer.getTupleIndex(), aggregateState);
                                break;
                            }
                            case FINAL: {
                                hasOutput = aggregator.outputFinalResult(outputTupleBuilder, this.bufferAccessor, this.pointer.getTupleIndex(), aggregateState);
                            }
                        }
                        if (!hasOutput || this.outputAppender.appendSkipEmptyField(outputTupleBuilder.getFieldEndOffsets(), outputTupleBuilder.getByteArray(), 0, outputTupleBuilder.getSize())) continue;
                        this.outputAppender.write(writer, true);
                        if (this.outputAppender.appendSkipEmptyField(outputTupleBuilder.getFieldEndOffsets(), outputTupleBuilder.getByteArray(), 0, outputTupleBuilder.getSize())) continue;
                        throw new HyracksDataException("The output item is too large to be fit into a frame.");
                    }
                }
                this.outputAppender.write(writer, true);
                this.spilledSet.set(partition);
                return count;
            }

            @Override
            public int getNumPartitions() {
                return this.bufferManager.getNumPartitions();
            }

            @Override
            public int findVictimPartition(IFrameTupleAccessor accessor, int tIndex) throws HyracksDataException {
                int entryInHashTable = tpc.partition(accessor, tIndex, tableSize);
                int partition = this.getPartition(entryInHashTable);
                return this.spillPolicy.selectVictimPartition(partition);
            }
        };
    }

    private int getNumOfPartitions(long nubmerOfInputFrames, long frameLimit) {
        if ((double)frameLimit >= (double)nubmerOfInputFrames * 1.1) {
            return 2;
        }
        long numberOfPartitions = (long)Math.ceil(((double)nubmerOfInputFrames * 1.1 - (double)frameLimit) / (double)(frameLimit - 1L));
        if ((numberOfPartitions = Math.max(2L, numberOfPartitions)) > frameLimit) {
            numberOfPartitions = (long)Math.ceil(Math.sqrt((double)nubmerOfInputFrames * 1.1));
            return (int)Math.min(Math.max(2L, Math.min(numberOfPartitions, frameLimit)), Integer.MAX_VALUE);
        }
        return (int)Math.min(numberOfPartitions, Integer.MAX_VALUE);
    }
}

