/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class PlainFileWriterOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private IFileSplitProvider fileSplitProvider;
    private String delim;

    public PlainFileWriterOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvider, String delim) {
        super(spec, 1, 0);
        this.fileSplitProvider = fileSplitProvider;
        this.delim = delim;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
        final FileSplit[] splits = this.fileSplitProvider.getFileSplits();
        final IIOManager ioManager = ctx.getIoManager();
        final FrameTupleAccessor frameTupleAccessor = new FrameTupleAccessor(recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
        final RecordDescriptor recordDescriptor = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
        return new AbstractUnaryInputSinkOperatorNodePushable(){
            private BufferedWriter out;
            private ByteBufferInputStream bbis;
            private DataInputStream di;

            public void open() throws HyracksDataException {
                try {
                    this.out = new BufferedWriter(new FileWriter(splits[partition].getFile(ioManager)));
                    this.bbis = new ByteBufferInputStream();
                    this.di = new DataInputStream((InputStream)this.bbis);
                }
                catch (Exception e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                try {
                    frameTupleAccessor.reset(buffer);
                    for (int tIndex = 0; tIndex < frameTupleAccessor.getTupleCount(); ++tIndex) {
                        int start = frameTupleAccessor.getTupleStartOffset(tIndex) + frameTupleAccessor.getFieldSlotsLength();
                        this.bbis.setByteBuffer(buffer, start);
                        Object[] record = new Object[recordDescriptor.getFieldCount()];
                        for (int i = 0; i < record.length; ++i) {
                            Object instance = recordDescriptor.getFields()[i].deserialize((DataInput)this.di);
                            if (i == 0) {
                                this.out.write(String.valueOf(instance));
                                continue;
                            }
                            this.out.write(PlainFileWriterOperatorDescriptor.this.delim + String.valueOf(instance));
                        }
                        this.out.write("\n");
                    }
                }
                catch (IOException ex) {
                    throw HyracksDataException.create((Throwable)ex);
                }
            }

            public void fail() throws HyracksDataException {
            }

            public void close() throws HyracksDataException {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }
}

