/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.IDeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;

public class FramePoolBackedFrameBufferManager
implements ISimpleFrameBufferManager {
    private final IDeallocatableFramePool framePool;

    public FramePoolBackedFrameBufferManager(IDeallocatableFramePool framePool) {
        this.framePool = framePool;
    }

    @Override
    public ByteBuffer acquireFrame(int frameSize) throws HyracksDataException {
        return this.framePool.allocateFrame(frameSize);
    }

    @Override
    public void releaseFrame(ByteBuffer frame) {
        this.framePool.deAllocateBuffer(frame);
    }
}

