/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.StaticResourceServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryWebInterfaceServlet
extends StaticResourceServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private ICcApplicationContext appCtx;

    QueryWebInterfaceServlet(ICcApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String ... paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        String requestURI = request.getHttpRequest().uri();
        if ("/".equals(requestURI)) {
            HttpUtil.setContentType((IServletResponse)response, (String)"text/html");
            this.deliverResource("/dashboard/index.html", response);
        } else {
            this.deliverResource(requestURI, response);
        }
    }

    protected void post(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        ExternalProperties externalProperties = this.appCtx.getExternalProperties();
        response.setStatus(HttpResponseStatus.OK);
        ObjectNode obj = OBJECT_MAPPER.createObjectNode();
        try {
            PrintWriter out = response.writer();
            obj.put("api_port", String.valueOf(externalProperties.getAPIServerPort()));
            out.println(obj.toString());
            return;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Failure writing response", (Throwable)e);
            try {
                response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e2) {
                LOGGER.log(Level.ERROR, "Failure setting response status", (Throwable)e2);
            }
            return;
        }
    }
}

