/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.generator.DataGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TweetGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY_DURATION = "duration";
    public static final String KEY_TPS = "tps";
    public static final String KEY_VERBOSE = "verbose";
    public static final String KEY_FIELDS = "fields";
    public static final int INFINITY = 0;
    private static final int DEFAULT_DURATION = 0;
    private final int duration;
    private DataGenerator.TweetMessageIterator tweetIterator = null;
    private final int partition;
    private long tweetCount = 0L;
    private int frameTweetCount = 0;
    private int numFlushedTweets = 0;
    private DataGenerator dataGenerator = null;
    private final ByteBuffer outputBuffer = ByteBuffer.allocate(32768);
    private final String[] fields;
    private final List<OutputStream> subscribers;
    private final Object lock = new Object();
    private final List<OutputStream> subscribersForRemoval = new ArrayList<OutputStream>();

    public TweetGenerator(Map<String, String> configuration, int partition) {
        this.partition = partition;
        String value = configuration.get(KEY_DURATION);
        this.duration = value != null ? Integer.parseInt(value) : 0;
        DataGenerator dataGenerator = this.dataGenerator = new DataGenerator();
        dataGenerator.getClass();
        this.tweetIterator = new DataGenerator.TweetMessageIterator(dataGenerator, this.duration);
        this.fields = configuration.get(KEY_FIELDS) != null ? configuration.get(KEY_FIELDS).split(",") : null;
        this.subscribers = new ArrayList<OutputStream>();
    }

    private void writeTweetString(DataGenerator.TweetMessage tweetMessage) throws IOException {
        String tweet = tweetMessage.getAdmEquivalent(this.fields) + "\n";
        ++this.tweetCount;
        byte[] b = tweet.getBytes();
        if (this.outputBuffer.position() + b.length > this.outputBuffer.limit()) {
            this.flush();
            this.numFlushedTweets += this.frameTweetCount;
            this.frameTweetCount = 0;
            this.outputBuffer.put(b);
        } else {
            this.outputBuffer.put(b);
        }
        ++this.frameTweetCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws IOException {
        this.outputBuffer.flip();
        Object object = this.lock;
        synchronized (object) {
            for (OutputStream os : this.subscribers) {
                try {
                    os.write(this.outputBuffer.array(), 0, this.outputBuffer.limit());
                }
                catch (Exception e) {
                    LOGGER.info("OutputStream failed. Add it into the removal list.");
                    this.subscribersForRemoval.add(os);
                }
            }
            if (!this.subscribersForRemoval.isEmpty()) {
                this.subscribers.removeAll(this.subscribersForRemoval);
                this.subscribersForRemoval.clear();
            }
        }
        this.outputBuffer.position(0);
        this.outputBuffer.limit(32768);
    }

    public boolean generateNextBatch(int numTweets) throws IOException {
        boolean moreData = this.tweetIterator.hasNext();
        if (!moreData) {
            if (this.outputBuffer.position() > 0) {
                this.flush();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Reached end of batch. Tweet Count: [" + this.partition + "]" + this.tweetCount);
            }
            return false;
        }
        for (int count = 0; count < numTweets; ++count) {
            this.writeTweetString(this.tweetIterator.next());
        }
        return true;
    }

    public int getNumFlushedTweets() {
        return this.numFlushedTweets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubscriber(OutputStream os) {
        Object object = this.lock;
        synchronized (object) {
            this.subscribers.add(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSubscribers(OutputStream os) {
        Object object = this.lock;
        synchronized (object) {
            this.subscribers.remove(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            for (OutputStream os : this.subscribers) {
                os.close();
            }
        }
    }

    public boolean isSubscribed() {
        return !this.subscribers.isEmpty();
    }

    public long getTweetCount() {
        return this.tweetCount;
    }
}

