/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.object.base.AdmArrayNode;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.tuple.MutablePair;

class ConfigurationTypeValidator {
    private final Set<String> unknownFieldNames = new HashSet<String>();
    private final Deque<String> path = new ArrayDeque<String>();
    private final MutablePair<ATypeTag, ATypeTag> expectedActualTypePair = new MutablePair(null, null);
    private ErrorType result;

    protected ConfigurationTypeValidator() {
    }

    public void validateType(IAType type, IAdmNode node) throws CompilationException {
        if (!this.validate(type, node)) {
            this.throwException();
        }
    }

    private boolean validate(IAType type, IAdmNode node) {
        if (type.getTypeTag().isDerivedType()) {
            return this.validateDerivedType(type, node);
        }
        if (node == null) {
            this.result = ErrorType.MISSING_UNOPTIONAL_FIELD;
            return false;
        }
        if (type.getTypeTag() != node.getType()) {
            this.setExpectedAndActualType(type.getTypeTag(), node.getType());
            return false;
        }
        return true;
    }

    private boolean validateDerivedType(IAType type, IAdmNode node) {
        ATypeTag typeTag = type.getTypeTag();
        switch (typeTag) {
            case UNION: {
                return this.validateUnionType(type, node);
            }
            case OBJECT: {
                return this.validateObject(type, node);
            }
            case ARRAY: {
                return this.validateArray(type, node);
            }
        }
        throw new IllegalStateException("Unsupported derived type: " + typeTag);
    }

    private boolean validateUnionType(IAType type, IAdmNode node) {
        if (node == null || node.getType() == ATypeTag.NULL) {
            return true;
        }
        return this.validate(((AUnionType)type).getActualType(), node);
    }

    private boolean validateObject(IAType type, IAdmNode node) {
        Set objectFieldNames;
        if (node.getType() != ATypeTag.OBJECT) {
            this.setExpectedAndActualType(ATypeTag.OBJECT, node.getType());
            return false;
        }
        ARecordType recordType = (ARecordType)type;
        AdmObjectNode objectNode = (AdmObjectNode)node;
        String[] fieldNames = recordType.getFieldNames();
        HashSet<String> definedFieldNames = new HashSet<String>(Arrays.asList(fieldNames));
        if (!definedFieldNames.containsAll(objectFieldNames = objectNode.getFieldNames())) {
            this.setUnknownFieldNames(definedFieldNames, objectFieldNames);
            return false;
        }
        IAType[] fieldTypes = recordType.getFieldTypes();
        for (int i = 0; i < fieldTypes.length; ++i) {
            if (this.validate(fieldTypes[i], objectNode.get(fieldNames[i]))) continue;
            this.addToPath(fieldNames[i]);
            return false;
        }
        return true;
    }

    private boolean validateArray(IAType type, IAdmNode node) {
        if (node.getType() != ATypeTag.ARRAY) {
            this.setExpectedAndActualType(ATypeTag.ARRAY, node.getType());
            return false;
        }
        IAType itemType = ((AOrderedListType)type).getItemType();
        AdmArrayNode array = (AdmArrayNode)node;
        for (int i = 0; i < array.size(); ++i) {
            if (this.validate(itemType, array.get(i))) continue;
            this.addToPath(i);
            return false;
        }
        return true;
    }

    private void setUnknownFieldNames(Set<String> definedFieldNames, Set<String> objectFieldNames) {
        this.unknownFieldNames.addAll(objectFieldNames);
        this.unknownFieldNames.removeAll(definedFieldNames);
        this.result = ErrorType.UNKNOWN_FIELD_NAMES;
    }

    private void setExpectedAndActualType(ATypeTag expectedTypeTag, ATypeTag actualTypeTag) {
        this.expectedActualTypePair.left = expectedTypeTag;
        this.expectedActualTypePair.right = actualTypeTag;
        this.result = ErrorType.TYPE_MISMATCH;
    }

    private void addToPath(String fieldName) {
        if (this.path.isEmpty()) {
            this.path.push(fieldName);
        } else {
            this.path.push(fieldName + ".");
        }
    }

    private void addToPath(int arrayIndex) {
        this.path.push("[" + arrayIndex + "]");
    }

    private void throwException() throws CompilationException {
        StringBuilder pathBuilder = new StringBuilder();
        while (!this.path.isEmpty()) {
            pathBuilder.append(this.path.pop());
        }
        switch (this.result) {
            case UNKNOWN_FIELD_NAMES: {
                if (pathBuilder.length() > 0) {
                    throw new CompilationException(1097, new Serializable[]{this.unknownFieldNames.toString(), pathBuilder.toString()});
                }
                throw new CompilationException(1059, new Serializable[]{this.unknownFieldNames.toString()});
            }
            case TYPE_MISMATCH: {
                throw new CompilationException(1060, new Serializable[]{pathBuilder.toString(), (Serializable)this.expectedActualTypePair.left, (Serializable)this.expectedActualTypePair.right});
            }
            case MISSING_UNOPTIONAL_FIELD: {
                throw new CompilationException(1061, new Serializable[]{pathBuilder.toString()});
            }
        }
    }

    public static enum ErrorType {
        UNKNOWN_FIELD_NAMES,
        TYPE_MISMATCH,
        MISSING_UNOPTIONAL_FIELD;

    }
}

