/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.JobSpecification;

public class DeployedJobSpecStore {
    private final Map<DeployedJobSpecId, DeployedJobSpecDescriptor> deployedJobSpecDescriptorMap = new Hashtable<DeployedJobSpecId, DeployedJobSpecDescriptor>();

    public void addDeployedJobSpecDescriptor(DeployedJobSpecId deployedJobSpecId, ActivityClusterGraph activityClusterGraph, JobSpecification jobSpecification, Set<Constraint> activityClusterGraphConstraints) throws HyracksException {
        DeployedJobSpecDescriptor descriptor = new DeployedJobSpecDescriptor(activityClusterGraph, jobSpecification, activityClusterGraphConstraints);
        this.deployedJobSpecDescriptorMap.put(deployedJobSpecId, descriptor);
    }

    public void checkForExistingDeployedJobSpecDescriptor(DeployedJobSpecId deployedJobSpecId) throws HyracksException {
        if (this.deployedJobSpecDescriptorMap.get(deployedJobSpecId) != null) {
            throw HyracksException.create((int)22, (Serializable[])new Serializable[]{deployedJobSpecId});
        }
    }

    public DeployedJobSpecDescriptor getDeployedJobSpecDescriptor(DeployedJobSpecId deployedJobSpecId) throws HyracksException {
        DeployedJobSpecDescriptor descriptor = this.deployedJobSpecDescriptorMap.get(deployedJobSpecId);
        if (descriptor == null) {
            throw HyracksException.create((int)21, (Serializable[])new Serializable[]{deployedJobSpecId});
        }
        return descriptor;
    }

    public void removeDeployedJobSpecDescriptor(DeployedJobSpecId deployedJobSpecId) throws HyracksException {
        DeployedJobSpecDescriptor descriptor = this.deployedJobSpecDescriptorMap.get(deployedJobSpecId);
        if (descriptor == null) {
            throw HyracksException.create((int)21, (Serializable[])new Serializable[]{deployedJobSpecId});
        }
        this.deployedJobSpecDescriptorMap.remove(deployedJobSpecId);
    }

    public class DeployedJobSpecDescriptor {
        private final ActivityClusterGraph activityClusterGraph;
        private final JobSpecification jobSpecification;
        private final Set<Constraint> activityClusterGraphConstraints;

        private DeployedJobSpecDescriptor(ActivityClusterGraph activityClusterGraph, JobSpecification jobSpecification, Set<Constraint> activityClusterGraphConstraints) {
            this.activityClusterGraph = activityClusterGraph;
            this.jobSpecification = jobSpecification;
            this.activityClusterGraphConstraints = activityClusterGraphConstraints;
        }

        public ActivityClusterGraph getActivityClusterGraph() {
            return this.activityClusterGraph;
        }

        public JobSpecification getJobSpecification() {
            return this.jobSpecification;
        }

        public Set<Constraint> getActivityClusterGraphConstraints() {
            return this.activityClusterGraphConstraints;
        }
    }
}

