/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.BTreeFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexFileNameMapper;

public class LSMInvertedIndexFileManager
extends AbstractLSMIndexFileManager
implements IInvertedIndexFileNameMapper {
    public static final String DICT_BTREE_SUFFIX = "b";
    public static final String INVLISTS_SUFFIX = "i";
    public static final String DELETED_KEYS_BTREE_SUFFIX = "d";
    private final BTreeFactory btreeFactory;
    private static final FilenameFilter dictBTreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith(DICT_BTREE_SUFFIX);
    private static final FilenameFilter invListFilter = (dir, name) -> !name.startsWith(".") && name.endsWith(INVLISTS_SUFFIX);
    private static final FilenameFilter deletedKeysBTreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith(DELETED_KEYS_BTREE_SUFFIX);

    public LSMInvertedIndexFileManager(IIOManager ioManager, FileReference file, BTreeFactory btreeFactory) {
        super(ioManager, file, null);
        this.btreeFactory = btreeFactory;
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String baseName = this.getNextComponentSequence(deletedKeysBTreeFilter);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + DICT_BTREE_SUFFIX), this.baseDir.getChild(baseName + "_" + DELETED_KEYS_BTREE_SUFFIX), this.baseDir.getChild(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) {
        String baseName = IndexComponentFileReference.getMergeSequence((String)firstFileName, (String)lastFileName);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + DICT_BTREE_SUFFIX), this.baseDir.getChild(baseName + "_" + DELETED_KEYS_BTREE_SUFFIX), this.baseDir.getChild(baseName + "_" + "f"));
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allDictBTreeFiles = new ArrayList();
        ArrayList allInvListsFiles = new ArrayList();
        ArrayList allDeletedKeysBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        this.cleanupAndGetValidFilesInternal(deletedKeysBTreeFilter, (TreeIndexFactory)this.btreeFactory, allDeletedKeysBTreeFiles, this.btreeFactory.getBufferCache());
        HashSet<String> deletedKeysBTreeFilesSet = new HashSet<String>();
        for (IndexComponentFileReference cmpFileName : allDeletedKeysBTreeFiles) {
            deletedKeysBTreeFilesSet.add(cmpFileName.getSequence());
        }
        this.validateFiles(deletedKeysBTreeFilesSet, allInvListsFiles, invListFilter, null, this.btreeFactory.getBufferCache());
        this.validateFiles(deletedKeysBTreeFilesSet, allDictBTreeFiles, dictBTreeFilter, (TreeIndexFactory)this.btreeFactory, this.btreeFactory.getBufferCache());
        this.validateFiles(deletedKeysBTreeFilesSet, allBloomFilterFiles, bloomFilterFilter, null, this.btreeFactory.getBufferCache());
        if (allDictBTreeFiles.size() != allInvListsFiles.size() || allDictBTreeFiles.size() != allDeletedKeysBTreeFiles.size() || allDictBTreeFiles.size() != allBloomFilterFiles.size()) {
            throw HyracksDataException.create((int)87, (Serializable[])new Serializable[]{this.baseDir});
        }
        if (allDictBTreeFiles.isEmpty() || allInvListsFiles.isEmpty() || allDeletedKeysBTreeFiles.isEmpty() || allBloomFilterFiles.isEmpty()) {
            return validFiles;
        }
        if (allDictBTreeFiles.size() == 1 && allInvListsFiles.size() == 1 && allDeletedKeysBTreeFiles.size() == 1 && allBloomFilterFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(((IndexComponentFileReference)allDictBTreeFiles.get(0)).getFileRef(), ((IndexComponentFileReference)allDeletedKeysBTreeFiles.get(0)).getFileRef(), ((IndexComponentFileReference)allBloomFilterFiles.get(0)).getFileRef()));
            return validFiles;
        }
        Collections.sort(allDeletedKeysBTreeFiles);
        Collections.sort(allDictBTreeFiles);
        Collections.sort(allBloomFilterFiles);
        ArrayList<IndexComponentFileReference> validComparableDictBTreeFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastDictBTree = (IndexComponentFileReference)allDictBTreeFiles.get(0);
        validComparableDictBTreeFiles.add(lastDictBTree);
        ArrayList<IndexComponentFileReference> validComparableDeletedKeysBTreeFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastDeletedKeysBTree = (IndexComponentFileReference)allDeletedKeysBTreeFiles.get(0);
        validComparableDeletedKeysBTreeFiles.add(lastDeletedKeysBTree);
        ArrayList<IndexComponentFileReference> validComparableBloomFilterFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(0);
        validComparableBloomFilterFiles.add(lastBloomFilter);
        for (int i = 1; i < allDictBTreeFiles.size(); ++i) {
            IndexComponentFileReference currentDeletedKeysBTree = (IndexComponentFileReference)allDeletedKeysBTreeFiles.get(i);
            IndexComponentFileReference currentDictBTree = (IndexComponentFileReference)allDictBTreeFiles.get(i);
            IndexComponentFileReference currentBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(i);
            if (currentDeletedKeysBTree.isMoreRecentThan(lastDeletedKeysBTree) && currentDictBTree.isMoreRecentThan(lastDictBTree) && currentBloomFilter.isMoreRecentThan(lastBloomFilter)) {
                validComparableDictBTreeFiles.add(currentDictBTree);
                validComparableDeletedKeysBTreeFiles.add(currentDeletedKeysBTree);
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastDictBTree = currentDictBTree;
                lastDeletedKeysBTree = currentDeletedKeysBTree;
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentDeletedKeysBTree.isWithin(lastDeletedKeysBTree) && currentDictBTree.isWithin(lastDictBTree) && currentBloomFilter.isWithin(lastBloomFilter)) {
                this.delete(this.btreeFactory.getBufferCache(), currentDeletedKeysBTree.getFileRef());
                this.delete(this.btreeFactory.getBufferCache(), currentDictBTree.getFileRef());
                this.delete(this.btreeFactory.getBufferCache(), currentBloomFilter.getFileRef());
                continue;
            }
            throw HyracksDataException.create((int)84, (Serializable[])new Serializable[]{this.baseDir});
        }
        validComparableDictBTreeFiles.sort(this.recencyCmp);
        validComparableDeletedKeysBTreeFiles.sort(this.recencyCmp);
        validComparableBloomFilterFiles.sort(this.recencyCmp);
        Iterator dictBTreeFileIter = validComparableDictBTreeFiles.iterator();
        Iterator deletedKeysBTreeIter = validComparableDeletedKeysBTreeFiles.iterator();
        Iterator bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        while (dictBTreeFileIter.hasNext() && deletedKeysBTreeIter.hasNext()) {
            IndexComponentFileReference cmpDictBTreeFile = (IndexComponentFileReference)dictBTreeFileIter.next();
            IndexComponentFileReference cmpDeletedKeysBTreeFile = (IndexComponentFileReference)deletedKeysBTreeIter.next();
            IndexComponentFileReference cmpBloomFilterFileName = (IndexComponentFileReference)bloomFilterFileIter.next();
            validFiles.add(new LSMComponentFileReferences(cmpDictBTreeFile.getFileRef(), cmpDeletedKeysBTreeFile.getFileRef(), cmpBloomFilterFileName.getFileRef()));
        }
        return validFiles;
    }

    @Override
    public String getInvListsFilePath(String dictBTreeFilePath) {
        int index = dictBTreeFilePath.lastIndexOf("_");
        String file = dictBTreeFilePath.substring(0, index);
        return file + "_" + INVLISTS_SUFFIX;
    }
}

