/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppAstVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SqlppSynonymRewriteVisitor
extends AbstractSqlppAstVisitor<Void, MetadataProvider> {
    public static final SqlppSynonymRewriteVisitor INSTANCE = new SqlppSynonymRewriteVisitor();

    private SqlppSynonymRewriteVisitor() {
    }

    public Void visit(LoadStatement loadStmt, MetadataProvider metadataProvider) throws CompilationException {
        Pair<DataverseName, String> dsName = this.resolveDatasetNameUsingSynonyms(metadataProvider, loadStmt.getDataverseName(), loadStmt.getDatasetName(), loadStmt.getSourceLocation());
        if (dsName != null) {
            loadStmt.setDataverseName((DataverseName)dsName.first);
            loadStmt.setDatasetName((String)dsName.second);
        }
        return null;
    }

    public Void visit(InsertStatement insertStmt, MetadataProvider metadataProvider) throws CompilationException {
        Pair<DataverseName, String> dsName = this.resolveDatasetNameUsingSynonyms(metadataProvider, insertStmt.getDataverseName(), insertStmt.getDatasetName(), insertStmt.getSourceLocation());
        if (dsName != null) {
            insertStmt.setDataverseName((DataverseName)dsName.first);
            insertStmt.setDatasetName((String)dsName.second);
        }
        return null;
    }

    public Void visit(DeleteStatement deleteStmt, MetadataProvider metadataProvider) throws CompilationException {
        Pair<DataverseName, String> dsName = this.resolveDatasetNameUsingSynonyms(metadataProvider, deleteStmt.getDataverseName(), deleteStmt.getDatasetName(), deleteStmt.getSourceLocation());
        if (dsName != null) {
            deleteStmt.setDataverseName((DataverseName)dsName.first);
            deleteStmt.setDatasetName((String)dsName.second);
        }
        return null;
    }

    private Pair<DataverseName, String> resolveDatasetNameUsingSynonyms(MetadataProvider metadataProvider, DataverseName dataverseName, String datasetName, SourceLocation sourceLoc) throws CompilationException {
        try {
            return metadataProvider.resolveDatasetNameUsingSynonyms(dataverseName, datasetName);
        }
        catch (AlgebricksException e) {
            throw new CompilationException(1079, (Throwable)e, sourceLoc, new Serializable[]{e.getMessage()});
        }
    }
}

