/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;

public class ExternalFunctionResultRouter
implements IIPCI {
    AtomicLong maxId = new AtomicLong(0L);
    ConcurrentHashMap<Long, MutableObject<ByteBuffer>> activeClients = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Exception> exceptionInbox = new ConcurrentHashMap();
    private static int MAX_BUF_SIZE = 0x2000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload) {
        int rewind = handle.getAttachmentLen();
        ByteBuffer buf = (ByteBuffer)payload;
        int end = buf.position();
        buf.position(end - rewind);
        ByteBuffer copyTo = (ByteBuffer)this.activeClients.get(rmid).getValue();
        if (copyTo.capacity() < handle.getAttachmentLen()) {
            int nextSize = ExternalFunctionResultRouter.closestPow2(handle.getAttachmentLen());
            if (nextSize > MAX_BUF_SIZE) {
                this.onError(handle, mid, rmid, (Exception)HyracksException.create((int)43, (Serializable[])new Serializable[0]));
                return;
            }
            copyTo = ByteBuffer.allocate(nextSize);
            this.activeClients.get(rmid).setValue((Object)copyTo);
        }
        copyTo.position(0);
        System.arraycopy(buf.array(), buf.position() + buf.arrayOffset(), copyTo.array(), copyTo.arrayOffset(), handle.getAttachmentLen());
        ByteBuffer byteBuffer = copyTo;
        synchronized (byteBuffer) {
            copyTo.limit(handle.getAttachmentLen() + 1);
            copyTo.notify();
        }
        buf.position(end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(IIPCHandle handle, long mid, long rmid, Exception exception) {
        ByteBuffer route;
        this.exceptionInbox.put(rmid, exception);
        ByteBuffer byteBuffer = route = (ByteBuffer)this.activeClients.get(rmid).getValue();
        synchronized (byteBuffer) {
            route.notify();
        }
    }

    public Long insertRoute(ByteBuffer buf) {
        Long id = this.maxId.incrementAndGet();
        this.activeClients.put(id, (MutableObject<ByteBuffer>)new MutableObject((Object)buf));
        return id;
    }

    public Exception getException(Long id) {
        return this.exceptionInbox.remove(id);
    }

    public boolean hasException(long id) {
        return this.exceptionInbox.get(id) == null;
    }

    public void removeRoute(Long id) {
        this.activeClients.remove(id);
        this.exceptionInbox.remove(id);
    }

    public static int closestPow2(int n) {
        return (int)Math.pow(2.0, Math.ceil(Math.log(n) / Math.log(2.0)));
    }

    public static class NoOpNoSerJustDe
    implements IPayloadSerializerDeserializer {
        private static byte[] noop = new byte[]{0};

        public Object deserializeObject(ByteBuffer buffer, int length, byte flag) throws Exception {
            if (flag == 1) {
                return new JavaSerializationBasedPayloadSerializerDeserializer().deserializeObject(buffer, length, flag);
            }
            return buffer;
        }

        public Exception deserializeException(ByteBuffer buffer, int length) throws Exception {
            return null;
        }

        public byte[] serializeObject(Object object) throws Exception {
            return noop;
        }

        public byte[] serializeException(Exception object) throws Exception {
            return noop;
        }
    }
}

