/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.app.function.FunctionReader;
import org.apache.asterix.common.context.DatasetResource;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;

public class DatasetResourcesReader
extends FunctionReader {
    private final List<String> components = new ArrayList<String>();
    private final Iterator<String> it;
    private final CharArrayRecord record;

    public DatasetResourcesReader(DatasetResource dsr) {
        if (dsr != null && dsr.isOpen()) {
            Map indexes = dsr.getIndexes();
            for (Map.Entry entry : indexes.entrySet()) {
                IndexInfo value = (IndexInfo)entry.getValue();
                ILSMIndex index = value.getIndex();
                this.components.add(index.toString());
            }
            this.record = new CharArrayRecord();
        } else {
            this.record = null;
        }
        this.it = this.components.iterator();
    }

    public boolean hasNext() throws Exception {
        return this.it.hasNext();
    }

    public IRawRecord<char[]> next() throws IOException, InterruptedException {
        this.record.reset();
        this.record.append(this.it.next().toCharArray());
        this.record.endRecord();
        return this.record;
    }
}

