/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ACollectionCursor;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class IndexTupleTranslator
extends AbstractTupleTranslator<Index> {
    private static final int INDEX_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    public static final String GRAM_LENGTH_FIELD_NAME = "GramLength";
    public static final String INDEX_SEARCHKEY_TYPE_FIELD_NAME = "SearchKeyType";
    public static final String INDEX_ISENFORCED_FIELD_NAME = "IsEnforced";
    public static final String INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME = "SearchKeySourceIndicator";
    protected final TxnId txnId;
    protected final MetadataNode metadataNode;
    protected OrderedListBuilder listBuilder;
    protected OrderedListBuilder primaryKeyListBuilder;
    protected AOrderedListType stringList;
    protected AOrderedListType int8List;
    protected ArrayBackedValueStorage nameValue;
    protected ArrayBackedValueStorage itemValue;
    protected AMutableInt8 aInt8;
    protected ISerializerDeserializer<AInt8> int8Serde;

    protected IndexTupleTranslator(TxnId txnId, MetadataNode metadataNode, boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.INDEX_DATASET, 3);
        this.txnId = txnId;
        this.metadataNode = metadataNode;
        if (getTuple) {
            this.listBuilder = new OrderedListBuilder();
            this.primaryKeyListBuilder = new OrderedListBuilder();
            this.stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
            this.int8List = new AOrderedListType((IAType)BuiltinType.AINT8, null);
            this.nameValue = new ArrayBackedValueStorage();
            this.itemValue = new ArrayBackedValueStorage();
            this.aInt8 = new AMutableInt8(0);
            this.int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
        }
    }

    @Override
    protected Index createMetadataEntityFromARecord(ARecord indexRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)indexRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String datasetName = ((AString)indexRecord.getValueByPos(1)).getStringValue();
        String indexName = ((AString)indexRecord.getValueByPos(2)).getStringValue();
        DatasetConfig.IndexType indexStructure = DatasetConfig.IndexType.valueOf((String)((AString)indexRecord.getValueByPos(3)).getStringValue());
        IACursor fieldNameCursor = ((AOrderedList)indexRecord.getValueByPos(4)).getCursor();
        ArrayList<List<String>> searchKey = new ArrayList<List<String>>();
        while (fieldNameCursor.next()) {
            AOrderedList fieldNameList = (AOrderedList)fieldNameCursor.get();
            IACursor nestedFieldNameCursor = fieldNameList.getCursor();
            ArrayList<String> nestedFieldName = new ArrayList<String>();
            while (nestedFieldNameCursor.next()) {
                nestedFieldName.add(((AString)nestedFieldNameCursor.get()).getStringValue());
            }
            searchKey.add(nestedFieldName);
        }
        int indexKeyTypeFieldPos = indexRecord.getType().getFieldIndex(INDEX_SEARCHKEY_TYPE_FIELD_NAME);
        ACollectionCursor fieldTypeCursor = new ACollectionCursor();
        if (indexKeyTypeFieldPos > 0) {
            fieldTypeCursor = ((AOrderedList)indexRecord.getValueByPos(indexKeyTypeFieldPos)).getCursor();
        }
        List<IAType> searchKeyType = new ArrayList<IAType>(searchKey.size());
        while (fieldTypeCursor.next()) {
            String typeName = ((AString)fieldTypeCursor.get()).getStringValue();
            IAType fieldType = BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.txnId, dataverseName, typeName);
            searchKeyType.add(fieldType);
        }
        boolean isOverridingKeyTypes = !searchKeyType.isEmpty();
        int isEnforcedFieldPos = indexRecord.getType().getFieldIndex(INDEX_ISENFORCED_FIELD_NAME);
        Boolean isEnforcingKeys = false;
        if (isEnforcedFieldPos > 0) {
            isEnforcingKeys = ((ABoolean)indexRecord.getValueByPos(isEnforcedFieldPos)).getBoolean();
        }
        Boolean isPrimaryIndex = ((ABoolean)indexRecord.getValueByPos(5)).getBoolean();
        int pendingOp = ((AInt32)indexRecord.getValueByPos(7)).getIntegerValue();
        int gramLength = -1;
        int gramLenPos = indexRecord.getType().getFieldIndex(GRAM_LENGTH_FIELD_NAME);
        if (gramLenPos >= 0) {
            gramLength = ((AInt32)indexRecord.getValueByPos(gramLenPos)).getIntegerValue();
        }
        ArrayList<Integer> keyFieldSourceIndicator = new ArrayList<Integer>();
        int keyFieldSourceIndicatorIndex = indexRecord.getType().getFieldIndex(INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME);
        if (keyFieldSourceIndicatorIndex >= 0) {
            IACursor cursor = ((AOrderedList)indexRecord.getValueByPos(keyFieldSourceIndicatorIndex)).getCursor();
            while (cursor.next()) {
                keyFieldSourceIndicator.add(Integer.valueOf(((AInt8)cursor.get()).getByteValue()));
            }
        } else {
            for (int index = 0; index < searchKey.size(); ++index) {
                keyFieldSourceIndicator.add(0);
            }
        }
        if (searchKeyType.isEmpty()) {
            Dataset dataset = this.metadataNode.getDataset(this.txnId, dataverseName, datasetName);
            String datatypeName = dataset.getItemTypeName();
            DataverseName datatypeDataverseName = dataset.getItemTypeDataverseName();
            ARecordType recordDt = (ARecordType)this.metadataNode.getDatatype(this.txnId, datatypeDataverseName, datatypeName).getDatatype();
            String metatypeName = dataset.getMetaItemTypeName();
            DataverseName metatypeDataverseName = dataset.getMetaItemTypeDataverseName();
            ARecordType metaDt = null;
            if (metatypeName != null && metatypeDataverseName != null) {
                metaDt = (ARecordType)this.metadataNode.getDatatype(this.txnId, metatypeDataverseName, metatypeName).getDatatype();
            }
            searchKeyType = KeyFieldTypeUtil.getKeyTypes(recordDt, metaDt, searchKey, keyFieldSourceIndicator);
        }
        return new Index(dataverseName, datasetName, indexName, indexStructure, searchKey, keyFieldSourceIndicator, searchKeyType, gramLength, isOverridingKeyTypes, isEnforcingKeys, isPrimaryIndex, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Index index) throws HyracksDataException {
        String dataverseCanonicalName = index.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(index.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(index.getIndexName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.INDEX_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(index.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(index.getIndexName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(index.getIndexType().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.primaryKeyListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.INDEX_RECORDTYPE.getFieldTypes()[4]));
        List<List<String>> searchKey = index.getKeyFieldNames();
        for (List<String> field : searchKey) {
            this.listBuilder.reset((AbstractCollectionType)this.stringList);
            for (String subField : field) {
                this.itemValue.reset();
                this.aString.setValue(subField);
                this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.itemValue);
            }
            this.itemValue.reset();
            this.listBuilder.write(this.itemValue.getDataOutput(), true);
            this.primaryKeyListBuilder.addItem((IValueReference)this.itemValue);
        }
        this.fieldValue.reset();
        this.primaryKeyListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        if (index.isPrimaryIndex()) {
            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
        } else {
            this.booleanSerde.serialize((Object)ABoolean.FALSE, this.fieldValue.getDataOutput());
        }
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.int32Serde.serialize((Object)new AInt32(index.getPendingOp()), this.fieldValue.getDataOutput());
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
        this.writeOpenFields(index);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(Index index) throws HyracksDataException {
        this.writeGramLength(index);
        this.writeSearchKeyType(index);
        this.writeEnforced(index);
        this.writeSearchKeySourceIndicator(index);
    }

    private void writeGramLength(Index index) throws HyracksDataException {
        if (index.getGramLength() > 0) {
            this.fieldValue.reset();
            this.nameValue.reset();
            this.aString.setValue(GRAM_LENGTH_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.int32Serde.serialize((Object)new AInt32(index.getGramLength()), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }

    private void writeSearchKeyType(Index index) throws HyracksDataException {
        if (index.isOverridingKeyFieldTypes()) {
            OrderedListBuilder typeListBuilder = new OrderedListBuilder();
            typeListBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)BuiltinType.ANY, null));
            this.nameValue.reset();
            this.aString.setValue(INDEX_SEARCHKEY_TYPE_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            List<IAType> searchKeyType = index.getKeyFieldTypes();
            for (IAType type : searchKeyType) {
                this.itemValue.reset();
                this.aString.setValue(type.getTypeName());
                this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                typeListBuilder.addItem((IValueReference)this.itemValue);
            }
            this.fieldValue.reset();
            typeListBuilder.write(this.fieldValue.getDataOutput(), true);
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }

    private void writeEnforced(Index index) throws HyracksDataException {
        if (index.isEnforced()) {
            this.fieldValue.reset();
            this.nameValue.reset();
            this.aString.setValue(INDEX_ISENFORCED_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }

    private void writeSearchKeySourceIndicator(Index index) throws HyracksDataException {
        List<Integer> keySourceIndicator = index.getKeyFieldSourceIndicators();
        boolean needSerialization = false;
        if (keySourceIndicator != null) {
            for (int source : keySourceIndicator) {
                if (source == 0) continue;
                needSerialization = true;
                break;
            }
        }
        if (needSerialization) {
            this.listBuilder.reset((AbstractCollectionType)this.int8List);
            this.nameValue.reset();
            this.aString.setValue(INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            for (int source : keySourceIndicator) {
                this.itemValue.reset();
                this.aInt8.setValue((byte)source);
                this.int8Serde.serialize((Object)this.aInt8, this.itemValue.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.itemValue);
            }
            this.fieldValue.reset();
            this.listBuilder.write(this.fieldValue.getDataOutput(), true);
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }
}

