/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import org.tranql.connector.jdbc.ConnectionHandle;
import org.tranql.connector.jdbc.ResultSetHandle;

public class DatabaseMetaDataHandle
implements DatabaseMetaData {
    private final ConnectionHandle c;
    private final DatabaseMetaData dbmd;

    public DatabaseMetaDataHandle(ConnectionHandle c, DatabaseMetaData dbmd) {
        this.c = c;
        this.dbmd = dbmd;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.c;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getBestRowIdentifier(catalog, schema, table, scope, nullable));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getCatalogs());
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getColumnPrivileges(catalog, schema, table, columnNamePattern));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getCrossReference(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getExportedKeys(catalog, schema, table));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getImportedKeys(catalog, schema, table));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getIndexInfo(catalog, schema, table, unique, approximate));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getPrimaryKeys(catalog, schema, table));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getProcedures(catalog, schemaPattern, procedureNamePattern));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getSchemas());
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getSuperTables(catalog, schemaPattern, tableNamePattern));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getSuperTypes(catalog, schemaPattern, typeNamePattern));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getTablePrivileges(catalog, schemaPattern, tableNamePattern));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getTables(catalog, schemaPattern, tableNamePattern, types));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getTableTypes());
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getTypeInfo());
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getUDTs(catalog, schemaPattern, typeNamePattern, types));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            return new ResultSetHandle(null, this.dbmd.getVersionColumns(catalog, schema, table));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this.dbmd.allProceduresAreCallable();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this.dbmd.allTablesAreSelectable();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this.dbmd.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this.dbmd.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        try {
            return this.dbmd.deletesAreDetected(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this.dbmd.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return this.dbmd.getCatalogSeparator();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this.dbmd.getCatalogTerm();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this.dbmd.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this.dbmd.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            return this.dbmd.getDatabaseProductName();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this.dbmd.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this.dbmd.getDefaultTransactionIsolation();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getDriverMajorVersion() {
        return this.dbmd.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.dbmd.getDriverMinorVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            return this.dbmd.getDriverName();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            return this.dbmd.getDriverVersion();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return this.dbmd.getExtraNameCharacters();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            return this.dbmd.getIdentifierQuoteString();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            return this.dbmd.getJDBCMajorVersion();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            return this.dbmd.getJDBCMinorVersion();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this.dbmd.getMaxBinaryLiteralLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this.dbmd.getMaxCatalogNameLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this.dbmd.getMaxCharLiteralLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this.dbmd.getMaxColumnNameLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this.dbmd.getMaxColumnsInGroupBy();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this.dbmd.getMaxColumnsInIndex();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this.dbmd.getMaxColumnsInOrderBy();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this.dbmd.getMaxColumnsInSelect();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this.dbmd.getMaxColumnsInTable();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return this.dbmd.getMaxConnections();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this.dbmd.getMaxCursorNameLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return this.dbmd.getMaxIndexLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this.dbmd.getMaxProcedureNameLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return this.dbmd.getMaxRowSize();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this.dbmd.getMaxSchemaNameLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return this.dbmd.getMaxStatementLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return this.dbmd.getMaxStatements();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return this.dbmd.getMaxTableNameLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this.dbmd.getMaxTablesInSelect();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return this.dbmd.getMaxUserNameLength();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return this.dbmd.getNumericFunctions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return this.dbmd.getProcedureTerm();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.dbmd.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            return this.dbmd.getSchemaTerm();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return this.dbmd.getSearchStringEscape();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            return this.dbmd.getSQLKeywords();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return this.dbmd.getSQLStateType();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return this.dbmd.getStringFunctions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return this.dbmd.getSystemFunctions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return this.dbmd.getTimeDateFunctions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            return this.dbmd.getURL();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            return this.dbmd.getUserName();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        try {
            return this.dbmd.insertsAreDetected(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this.dbmd.isCatalogAtStart();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.dbmd.isReadOnly();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this.dbmd.locatorsUpdateCopy();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this.dbmd.nullPlusNonNullIsNull();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this.dbmd.nullsAreSortedAtEnd();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this.dbmd.nullsAreSortedAtStart();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this.dbmd.nullsAreSortedHigh();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this.dbmd.nullsAreSortedLow();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        try {
            return this.dbmd.othersDeletesAreVisible(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        try {
            return this.dbmd.othersInsertsAreVisible(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.dbmd.othersUpdatesAreVisible(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        try {
            return this.dbmd.ownDeletesAreVisible(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        try {
            return this.dbmd.ownInsertsAreVisible(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.dbmd.ownUpdatesAreVisible(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this.dbmd.storesLowerCaseIdentifiers();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.dbmd.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this.dbmd.storesMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.dbmd.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this.dbmd.storesUpperCaseIdentifiers();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.dbmd.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this.dbmd.supportsAlterTableWithAddColumn();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this.dbmd.supportsAlterTableWithDropColumn();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this.dbmd.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this.dbmd.supportsANSI92FullSQL();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this.dbmd.supportsANSI92IntermediateSQL();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this.dbmd.supportsBatchUpdates();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this.dbmd.supportsCatalogsInDataManipulation();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this.dbmd.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this.dbmd.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this.dbmd.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this.dbmd.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this.dbmd.supportsColumnAliasing();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return this.dbmd.supportsConvert();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        try {
            return this.dbmd.supportsConvert(fromType, toType);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this.dbmd.supportsCoreSQLGrammar();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this.dbmd.supportsCorrelatedSubqueries();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this.dbmd.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this.dbmd.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this.dbmd.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this.dbmd.supportsExpressionsInOrderBy();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this.dbmd.supportsExtendedSQLGrammar();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this.dbmd.supportsFullOuterJoins();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this.dbmd.supportsGetGeneratedKeys();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return this.dbmd.supportsGroupBy();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this.dbmd.supportsGroupByBeyondSelect();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this.dbmd.supportsGroupByUnrelated();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this.dbmd.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this.dbmd.supportsLikeEscapeClause();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this.dbmd.supportsLimitedOuterJoins();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this.dbmd.supportsMinimumSQLGrammar();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this.dbmd.supportsMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.dbmd.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this.dbmd.supportsMultipleOpenResults();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this.dbmd.supportsMultipleResultSets();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this.dbmd.supportsMultipleTransactions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this.dbmd.supportsNamedParameters();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this.dbmd.supportsNonNullableColumns();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this.dbmd.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this.dbmd.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this.dbmd.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this.dbmd.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this.dbmd.supportsOrderByUnrelated();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this.dbmd.supportsOuterJoins();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this.dbmd.supportsPositionedDelete();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this.dbmd.supportsPositionedUpdate();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            return this.dbmd.supportsResultSetConcurrency(type, concurrency);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        try {
            return this.dbmd.supportsResultSetHoldability(holdability);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            return this.dbmd.supportsResultSetType(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return this.dbmd.supportsSavepoints();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this.dbmd.supportsSchemasInDataManipulation();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this.dbmd.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this.dbmd.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this.dbmd.supportsSchemasInProcedureCalls();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this.dbmd.supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this.dbmd.supportsSelectForUpdate();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            return this.dbmd.supportsStatementPooling();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        try {
            return this.dbmd.getRowIdLifetime();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getSchemas(String s, String s1) throws SQLException {
        try {
            return this.dbmd.getSchemas(s, s1);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return this.dbmd.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return this.dbmd.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try {
            return this.dbmd.getClientInfoProperties();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getFunctions(String s, String s1, String s2) throws SQLException {
        try {
            return this.dbmd.getFunctions(s, s1, s2);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getFunctionColumns(String s, String s1, String s2, String s3) throws SQLException {
        try {
            return this.dbmd.getFunctionColumns(s, s1, s2, s3);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this.dbmd.supportsStoredProcedures();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this.dbmd.supportsSubqueriesInComparisons();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this.dbmd.supportsSubqueriesInExists();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this.dbmd.supportsSubqueriesInIns();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this.dbmd.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this.dbmd.supportsTableCorrelationNames();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            return this.dbmd.supportsTransactionIsolationLevel(level);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return this.dbmd.supportsTransactions();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return this.dbmd.supportsUnion();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return this.dbmd.supportsUnionAll();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        try {
            return this.dbmd.updatesAreDetected(type);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this.dbmd.usesLocalFilePerTable();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return this.dbmd.usesLocalFiles();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        if (tClass.isInstance(this)) {
            return tClass.cast(this);
        }
        try {
            return this.dbmd.unwrap(tClass);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return true;
        }
        try {
            return this.dbmd.isWrapperFor(aClass);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }
}

