/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.ClauseTokenizer;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.TypeAttribute;
import org.apache.aries.subsystem.core.archive.VersionAttribute;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.OsgiIdentityRequirement;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class AriesSubsystemParentsHeader
implements RequirementHeader<Clause> {
    public static final String NAME = "AriesSubsystem-Parents";
    private final Set<Clause> clauses;

    private static StringBuilder appendSubsystem(BasicSubsystem subsystem, StringBuilder builder, boolean referenceCount) {
        String symbolicName = subsystem.getSymbolicName();
        Version version = subsystem.getVersion();
        String type = subsystem.getType();
        builder.append(symbolicName).append(';').append("version").append('=').append(version.toString()).append(';').append("type").append('=').append(type).append(';').append("resourceId").append('=').append(subsystem.getSubsystemId());
        return builder;
    }

    private static Collection<Clause> processHeader(String value) {
        Collection<String> clauseStrs = new ClauseTokenizer(value).getClauses();
        HashSet<Clause> clauses = new HashSet<Clause>(clauseStrs.size());
        for (String clause : new ClauseTokenizer(value).getClauses()) {
            clauses.add(new Clause(clause));
        }
        return clauses;
    }

    public AriesSubsystemParentsHeader(Collection<Clause> clauses) {
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException("A AriesSubsystem-Parents header must have at least one clause");
        }
        this.clauses = new HashSet<Clause>(clauses);
    }

    public AriesSubsystemParentsHeader(String value) {
        this(AriesSubsystemParentsHeader.processHeader(value));
    }

    public boolean contains(BasicSubsystem subsystem) {
        return this.getClause(subsystem) != null;
    }

    public Clause getClause(BasicSubsystem subsystem) {
        String symbolicName = subsystem.getSymbolicName();
        Version version = subsystem.getVersion();
        String type = subsystem.getType();
        for (Clause clause : this.clauses) {
            if (!symbolicName.equals(clause.getPath()) || !clause.getVersion().equals((Object)version) || !type.equals(clause.getType())) continue;
            return clause;
        }
        return null;
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<Requirement> toRequirements(Resource resource) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        public static final String ATTRIBUTE_VERSION = "version";
        public static final String ATTRIBUTE_RESOURCEID = "resourceId";
        public static final String ATTRIBUTE_TYPE = "type";
        private static final Pattern PATTERN_SYMBOLICNAME = Pattern.compile("((?:[0-9]|[A-Za-z]|_|-)+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)*)(?=;|\\z)");
        private static final Pattern PATTERN_PARAMETER = Pattern.compile("((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)");
        private final String path;
        private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();

        private static void fillInDefaults(Map<String, Parameter> parameters) {
            Parameter parameter = parameters.get(ATTRIBUTE_TYPE);
            if (parameter == null) {
                parameters.put(ATTRIBUTE_TYPE, TypeAttribute.newInstance("osgi.subsystem.application"));
            }
            if ((parameter = parameters.get(ATTRIBUTE_VERSION)) == null) {
                parameters.put(ATTRIBUTE_VERSION, VersionAttribute.DEFAULT);
            }
        }

        public Clause(String clause) {
            Matcher matcher = PATTERN_SYMBOLICNAME.matcher(clause);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Missing symbolic name path: " + clause);
            }
            this.path = matcher.group();
            matcher.usePattern(PATTERN_PARAMETER);
            while (matcher.find()) {
                Parameter parameter = ParameterFactory.create(matcher.group());
                if (parameter instanceof VersionAttribute) {
                    parameter = new VersionRangeAttribute(new VersionRange(String.valueOf(parameter.getValue())));
                }
                this.parameters.put(parameter.getName(), parameter);
            }
            Clause.fillInDefaults(this.parameters);
        }

        public Clause(BasicSubsystem subsystem, boolean referenceCount) {
            this(AriesSubsystemParentsHeader.appendSubsystem(subsystem, new StringBuilder(), referenceCount).toString());
        }

        public boolean contains(BasicSubsystem subsystem) {
            return this.getSymbolicName().equals(subsystem.getSymbolicName()) && this.getVersion().equals((Object)subsystem.getVersion()) && this.getType().equals(subsystem.getType());
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        public long getId() {
            Attribute attribute = this.getAttribute(ATTRIBUTE_RESOURCEID);
            if (attribute == null) {
                return -1L;
            }
            return Long.valueOf(String.valueOf(attribute.getValue()));
        }

        @Override
        public Parameter getParameter(String name) {
            return this.parameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.parameters.values());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public String getSymbolicName() {
            return this.path;
        }

        public String getType() {
            return ((TypeAttribute)this.getAttribute(ATTRIBUTE_TYPE)).getType();
        }

        public Version getVersion() {
            return ((VersionAttribute)this.getAttribute(ATTRIBUTE_VERSION)).getVersion();
        }

        public OsgiIdentityRequirement toRequirement(Resource resource) {
            return new OsgiIdentityRequirement(this.getSymbolicName(), this.getVersion(), this.getType(), false);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

