/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.jndi.url.ServiceRegistryContext;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiURLContextFactory
implements ObjectFactory {
    private BundleContext callerContext;

    public OsgiURLContextFactory(BundleContext callerContext) {
        this.callerContext = callerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj == null) {
            return new ServiceRegistryContext(this.callerContext, environment);
        }
        if (obj instanceof String) {
            Context ctx = null;
            try {
                ctx = new ServiceRegistryContext(this.callerContext, environment);
                Object object = ctx.lookup((String)obj);
                return object;
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        if (obj instanceof String[]) {
            String[] urls = (String[])obj;
            if (urls.length == 0) {
                throw new ConfigurationException("0");
            }
            ServiceRegistryContext context = new ServiceRegistryContext(this.callerContext, environment);
            try {
                NamingException ne = null;
                for (int i = 0; i < urls.length; ++i) {
                    try {
                        Object object = context.lookup(urls[i]);
                        return object;
                    }
                    catch (NamingException e) {
                        ne = e;
                        continue;
                    }
                }
                throw ne;
            }
            finally {
                context.close();
            }
        }
        return null;
    }
}

