#  Licensed to the Apache Software Foundation (ASF) under one
#  or more contributor license agreements. See the NOTICE file
#  distributed with this work for additional information
#  regarding copyright ownership. The ASF licenses this file
#  to you under the Apache License, Version 2.0 (the
#  "License"); you may not use this file except in compliance
#  with the License. You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing,
#   software distributed under the License is distributed on an
#   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#   KIND, either express or implied. See the License for the
#   specific language governing permissions and limitations
#   under the License.

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

import custos.server.core.FederatedAuthenticationService_pb2 as FederatedAuthenticationService__pb2
import custos.server.core.IamAdminService_pb2 as IamAdminService__pb2
import custos.server.core.MessagingService_pb2 as MessagingService__pb2
import custos.server.integration.TenantManagementService_pb2 as TenantManagementService__pb2
import custos.server.core.TenantProfileService_pb2 as TenantProfileService__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class TenantManagementServiceStub(object):
    """Missing associated documentation comment in .proto file."""

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.createTenant = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/createTenant',
                request_serializer=TenantProfileService__pb2.Tenant.SerializeToString,
                response_deserializer=TenantManagementService__pb2.CreateTenantResponse.FromString,
                )
        self.getTenant = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getTenant',
                request_serializer=TenantManagementService__pb2.GetTenantRequest.SerializeToString,
                response_deserializer=TenantProfileService__pb2.Tenant.FromString,
                )
        self.updateTenant = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/updateTenant',
                request_serializer=TenantManagementService__pb2.UpdateTenantRequest.SerializeToString,
                response_deserializer=TenantProfileService__pb2.Tenant.FromString,
                )
        self.deleteTenant = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/deleteTenant',
                request_serializer=TenantManagementService__pb2.DeleteTenantRequest.SerializeToString,
                response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                )
        self.validateTenant = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/validateTenant',
                request_serializer=TenantManagementService__pb2.TenantValidationRequest.SerializeToString,
                response_deserializer=IamAdminService__pb2.OperationStatus.FromString,
                )
        self.addTenantRoles = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/addTenantRoles',
                request_serializer=IamAdminService__pb2.AddRolesRequest.SerializeToString,
                response_deserializer=IamAdminService__pb2.AllRoles.FromString,
                )
        self.getTenantRoles = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getTenantRoles',
                request_serializer=IamAdminService__pb2.GetRolesRequest.SerializeToString,
                response_deserializer=IamAdminService__pb2.AllRoles.FromString,
                )
        self.deleteRole = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/deleteRole',
                request_serializer=IamAdminService__pb2.DeleteRoleRequest.SerializeToString,
                response_deserializer=IamAdminService__pb2.OperationStatus.FromString,
                )
        self.addProtocolMapper = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/addProtocolMapper',
                request_serializer=IamAdminService__pb2.AddProtocolMapperRequest.SerializeToString,
                response_deserializer=IamAdminService__pb2.OperationStatus.FromString,
                )
        self.configureEventPersistence = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/configureEventPersistence',
                request_serializer=IamAdminService__pb2.EventPersistenceRequest.SerializeToString,
                response_deserializer=IamAdminService__pb2.OperationStatus.FromString,
                )
        self.enableMessaging = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/enableMessaging',
                request_serializer=MessagingService__pb2.MessageEnablingRequest.SerializeToString,
                response_deserializer=MessagingService__pb2.MessageEnablingResponse.FromString,
                )
        self.updateTenantStatus = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/updateTenantStatus',
                request_serializer=TenantProfileService__pb2.UpdateStatusRequest.SerializeToString,
                response_deserializer=TenantProfileService__pb2.UpdateStatusResponse.FromString,
                )
        self.getAllTenants = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getAllTenants',
                request_serializer=TenantProfileService__pb2.GetTenantsRequest.SerializeToString,
                response_deserializer=TenantProfileService__pb2.GetAllTenantsResponse.FromString,
                )
        self.getChildTenants = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getChildTenants',
                request_serializer=TenantProfileService__pb2.GetTenantsRequest.SerializeToString,
                response_deserializer=TenantProfileService__pb2.GetAllTenantsResponse.FromString,
                )
        self.getAllTenantsForUser = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getAllTenantsForUser',
                request_serializer=TenantProfileService__pb2.GetAllTenantsForUserRequest.SerializeToString,
                response_deserializer=TenantProfileService__pb2.GetAllTenantsForUserResponse.FromString,
                )
        self.getTenantStatusUpdateAuditTrail = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getTenantStatusUpdateAuditTrail',
                request_serializer=TenantProfileService__pb2.GetAuditTrailRequest.SerializeToString,
                response_deserializer=TenantProfileService__pb2.GetStatusUpdateAuditTrailResponse.FromString,
                )
        self.getTenantAttributeUpdateAuditTrail = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getTenantAttributeUpdateAuditTrail',
                request_serializer=TenantProfileService__pb2.GetAuditTrailRequest.SerializeToString,
                response_deserializer=TenantProfileService__pb2.GetAttributeUpdateAuditTrailResponse.FromString,
                )
        self.addToCache = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/addToCache',
                request_serializer=FederatedAuthenticationService__pb2.CacheManipulationRequest.SerializeToString,
                response_deserializer=FederatedAuthenticationService__pb2.Status.FromString,
                )
        self.removeFromCache = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/removeFromCache',
                request_serializer=FederatedAuthenticationService__pb2.CacheManipulationRequest.SerializeToString,
                response_deserializer=FederatedAuthenticationService__pb2.Status.FromString,
                )
        self.getFromCache = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getFromCache',
                request_serializer=FederatedAuthenticationService__pb2.CacheManipulationRequest.SerializeToString,
                response_deserializer=FederatedAuthenticationService__pb2.GetInstitutionsResponse.FromString,
                )
        self.getInstitutions = channel.unary_unary(
                '/org.apache.custos.tenant.management.service.TenantManagementService/getInstitutions',
                request_serializer=FederatedAuthenticationService__pb2.CacheManipulationRequest.SerializeToString,
                response_deserializer=FederatedAuthenticationService__pb2.GetInstitutionsResponse.FromString,
                )


class TenantManagementServiceServicer(object):
    """Missing associated documentation comment in .proto file."""

    def createTenant(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getTenant(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def updateTenant(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteTenant(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def validateTenant(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def addTenantRoles(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getTenantRoles(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteRole(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def addProtocolMapper(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def configureEventPersistence(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def enableMessaging(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def updateTenantStatus(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getAllTenants(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getChildTenants(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getAllTenantsForUser(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getTenantStatusUpdateAuditTrail(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getTenantAttributeUpdateAuditTrail(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def addToCache(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def removeFromCache(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getFromCache(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getInstitutions(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_TenantManagementServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'createTenant': grpc.unary_unary_rpc_method_handler(
                    servicer.createTenant,
                    request_deserializer=TenantProfileService__pb2.Tenant.FromString,
                    response_serializer=TenantManagementService__pb2.CreateTenantResponse.SerializeToString,
            ),
            'getTenant': grpc.unary_unary_rpc_method_handler(
                    servicer.getTenant,
                    request_deserializer=TenantManagementService__pb2.GetTenantRequest.FromString,
                    response_serializer=TenantProfileService__pb2.Tenant.SerializeToString,
            ),
            'updateTenant': grpc.unary_unary_rpc_method_handler(
                    servicer.updateTenant,
                    request_deserializer=TenantManagementService__pb2.UpdateTenantRequest.FromString,
                    response_serializer=TenantProfileService__pb2.Tenant.SerializeToString,
            ),
            'deleteTenant': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteTenant,
                    request_deserializer=TenantManagementService__pb2.DeleteTenantRequest.FromString,
                    response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            ),
            'validateTenant': grpc.unary_unary_rpc_method_handler(
                    servicer.validateTenant,
                    request_deserializer=TenantManagementService__pb2.TenantValidationRequest.FromString,
                    response_serializer=IamAdminService__pb2.OperationStatus.SerializeToString,
            ),
            'addTenantRoles': grpc.unary_unary_rpc_method_handler(
                    servicer.addTenantRoles,
                    request_deserializer=IamAdminService__pb2.AddRolesRequest.FromString,
                    response_serializer=IamAdminService__pb2.AllRoles.SerializeToString,
            ),
            'getTenantRoles': grpc.unary_unary_rpc_method_handler(
                    servicer.getTenantRoles,
                    request_deserializer=IamAdminService__pb2.GetRolesRequest.FromString,
                    response_serializer=IamAdminService__pb2.AllRoles.SerializeToString,
            ),
            'deleteRole': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteRole,
                    request_deserializer=IamAdminService__pb2.DeleteRoleRequest.FromString,
                    response_serializer=IamAdminService__pb2.OperationStatus.SerializeToString,
            ),
            'addProtocolMapper': grpc.unary_unary_rpc_method_handler(
                    servicer.addProtocolMapper,
                    request_deserializer=IamAdminService__pb2.AddProtocolMapperRequest.FromString,
                    response_serializer=IamAdminService__pb2.OperationStatus.SerializeToString,
            ),
            'configureEventPersistence': grpc.unary_unary_rpc_method_handler(
                    servicer.configureEventPersistence,
                    request_deserializer=IamAdminService__pb2.EventPersistenceRequest.FromString,
                    response_serializer=IamAdminService__pb2.OperationStatus.SerializeToString,
            ),
            'enableMessaging': grpc.unary_unary_rpc_method_handler(
                    servicer.enableMessaging,
                    request_deserializer=MessagingService__pb2.MessageEnablingRequest.FromString,
                    response_serializer=MessagingService__pb2.MessageEnablingResponse.SerializeToString,
            ),
            'updateTenantStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.updateTenantStatus,
                    request_deserializer=TenantProfileService__pb2.UpdateStatusRequest.FromString,
                    response_serializer=TenantProfileService__pb2.UpdateStatusResponse.SerializeToString,
            ),
            'getAllTenants': grpc.unary_unary_rpc_method_handler(
                    servicer.getAllTenants,
                    request_deserializer=TenantProfileService__pb2.GetTenantsRequest.FromString,
                    response_serializer=TenantProfileService__pb2.GetAllTenantsResponse.SerializeToString,
            ),
            'getChildTenants': grpc.unary_unary_rpc_method_handler(
                    servicer.getChildTenants,
                    request_deserializer=TenantProfileService__pb2.GetTenantsRequest.FromString,
                    response_serializer=TenantProfileService__pb2.GetAllTenantsResponse.SerializeToString,
            ),
            'getAllTenantsForUser': grpc.unary_unary_rpc_method_handler(
                    servicer.getAllTenantsForUser,
                    request_deserializer=TenantProfileService__pb2.GetAllTenantsForUserRequest.FromString,
                    response_serializer=TenantProfileService__pb2.GetAllTenantsForUserResponse.SerializeToString,
            ),
            'getTenantStatusUpdateAuditTrail': grpc.unary_unary_rpc_method_handler(
                    servicer.getTenantStatusUpdateAuditTrail,
                    request_deserializer=TenantProfileService__pb2.GetAuditTrailRequest.FromString,
                    response_serializer=TenantProfileService__pb2.GetStatusUpdateAuditTrailResponse.SerializeToString,
            ),
            'getTenantAttributeUpdateAuditTrail': grpc.unary_unary_rpc_method_handler(
                    servicer.getTenantAttributeUpdateAuditTrail,
                    request_deserializer=TenantProfileService__pb2.GetAuditTrailRequest.FromString,
                    response_serializer=TenantProfileService__pb2.GetAttributeUpdateAuditTrailResponse.SerializeToString,
            ),
            'addToCache': grpc.unary_unary_rpc_method_handler(
                    servicer.addToCache,
                    request_deserializer=FederatedAuthenticationService__pb2.CacheManipulationRequest.FromString,
                    response_serializer=FederatedAuthenticationService__pb2.Status.SerializeToString,
            ),
            'removeFromCache': grpc.unary_unary_rpc_method_handler(
                    servicer.removeFromCache,
                    request_deserializer=FederatedAuthenticationService__pb2.CacheManipulationRequest.FromString,
                    response_serializer=FederatedAuthenticationService__pb2.Status.SerializeToString,
            ),
            'getFromCache': grpc.unary_unary_rpc_method_handler(
                    servicer.getFromCache,
                    request_deserializer=FederatedAuthenticationService__pb2.CacheManipulationRequest.FromString,
                    response_serializer=FederatedAuthenticationService__pb2.GetInstitutionsResponse.SerializeToString,
            ),
            'getInstitutions': grpc.unary_unary_rpc_method_handler(
                    servicer.getInstitutions,
                    request_deserializer=FederatedAuthenticationService__pb2.CacheManipulationRequest.FromString,
                    response_serializer=FederatedAuthenticationService__pb2.GetInstitutionsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'org.apache.custos.tenant.management.service.TenantManagementService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class TenantManagementService(object):
    """Missing associated documentation comment in .proto file."""

    @staticmethod
    def createTenant(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/createTenant',
            TenantProfileService__pb2.Tenant.SerializeToString,
            TenantManagementService__pb2.CreateTenantResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getTenant(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getTenant',
            TenantManagementService__pb2.GetTenantRequest.SerializeToString,
            TenantProfileService__pb2.Tenant.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def updateTenant(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/updateTenant',
            TenantManagementService__pb2.UpdateTenantRequest.SerializeToString,
            TenantProfileService__pb2.Tenant.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteTenant(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/deleteTenant',
            TenantManagementService__pb2.DeleteTenantRequest.SerializeToString,
            google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def validateTenant(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/validateTenant',
            TenantManagementService__pb2.TenantValidationRequest.SerializeToString,
            IamAdminService__pb2.OperationStatus.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def addTenantRoles(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/addTenantRoles',
            IamAdminService__pb2.AddRolesRequest.SerializeToString,
            IamAdminService__pb2.AllRoles.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getTenantRoles(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getTenantRoles',
            IamAdminService__pb2.GetRolesRequest.SerializeToString,
            IamAdminService__pb2.AllRoles.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def deleteRole(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/deleteRole',
            IamAdminService__pb2.DeleteRoleRequest.SerializeToString,
            IamAdminService__pb2.OperationStatus.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def addProtocolMapper(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/addProtocolMapper',
            IamAdminService__pb2.AddProtocolMapperRequest.SerializeToString,
            IamAdminService__pb2.OperationStatus.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def configureEventPersistence(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/configureEventPersistence',
            IamAdminService__pb2.EventPersistenceRequest.SerializeToString,
            IamAdminService__pb2.OperationStatus.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def enableMessaging(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/enableMessaging',
            MessagingService__pb2.MessageEnablingRequest.SerializeToString,
            MessagingService__pb2.MessageEnablingResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def updateTenantStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/updateTenantStatus',
            TenantProfileService__pb2.UpdateStatusRequest.SerializeToString,
            TenantProfileService__pb2.UpdateStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getAllTenants(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getAllTenants',
            TenantProfileService__pb2.GetTenantsRequest.SerializeToString,
            TenantProfileService__pb2.GetAllTenantsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getChildTenants(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getChildTenants',
            TenantProfileService__pb2.GetTenantsRequest.SerializeToString,
            TenantProfileService__pb2.GetAllTenantsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getAllTenantsForUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getAllTenantsForUser',
            TenantProfileService__pb2.GetAllTenantsForUserRequest.SerializeToString,
            TenantProfileService__pb2.GetAllTenantsForUserResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getTenantStatusUpdateAuditTrail(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getTenantStatusUpdateAuditTrail',
            TenantProfileService__pb2.GetAuditTrailRequest.SerializeToString,
            TenantProfileService__pb2.GetStatusUpdateAuditTrailResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getTenantAttributeUpdateAuditTrail(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getTenantAttributeUpdateAuditTrail',
            TenantProfileService__pb2.GetAuditTrailRequest.SerializeToString,
            TenantProfileService__pb2.GetAttributeUpdateAuditTrailResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def addToCache(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/addToCache',
            FederatedAuthenticationService__pb2.CacheManipulationRequest.SerializeToString,
            FederatedAuthenticationService__pb2.Status.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def removeFromCache(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/removeFromCache',
            FederatedAuthenticationService__pb2.CacheManipulationRequest.SerializeToString,
            FederatedAuthenticationService__pb2.Status.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getFromCache(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getFromCache',
            FederatedAuthenticationService__pb2.CacheManipulationRequest.SerializeToString,
            FederatedAuthenticationService__pb2.GetInstitutionsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getInstitutions(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/org.apache.custos.tenant.management.service.TenantManagementService/getInstitutions',
            FederatedAuthenticationService__pb2.CacheManipulationRequest.SerializeToString,
            FederatedAuthenticationService__pb2.GetInstitutionsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
