/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CopyUtils {
    private static Log log = LogFactory.getLog(CopyUtils.class);
    private static final boolean IS_DEBUG_ENABLED = log.isDebugEnabled();

    private CopyUtils() {
    }

    public static SOAPEnvelope copy(SOAPEnvelope sourceEnv) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start copy SOAPEnvelope");
        }
        SOAPFactory factory = (SOAPFactory)sourceEnv.getOMFactory();
        SOAPEnvelope targetEnv = factory.createSOAPEnvelope(sourceEnv.getNamespace());
        CopyUtils.copyTagData(sourceEnv, targetEnv);
        Iterator i = sourceEnv.getChildren();
        while (i.hasNext()) {
            OMNode child;
            Iterator j;
            OMNode node = (OMNode)i.next();
            if (node instanceof SOAPHeader) {
                SOAPHeader targetHeader = factory.createSOAPHeader(targetEnv);
                j = ((SOAPHeader)node).getChildren();
                while (j.hasNext()) {
                    child = (OMNode)j.next();
                    CopyUtils.copy(factory, targetHeader, child);
                }
                continue;
            }
            if (node instanceof SOAPBody) {
                SOAPBody targetBody = factory.createSOAPBody(targetEnv);
                j = ((SOAPBody)node).getChildren();
                while (j.hasNext()) {
                    child = (OMNode)j.next();
                    CopyUtils.copy(factory, targetBody, child);
                }
                continue;
            }
            CopyUtils.copy(factory, targetEnv, node);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end copy SOAPEnvelope");
        }
        return targetEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reader2writer(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        builder.releaseParserOnClose(true);
        try {
            OMDocument omDocument = builder.getDocument();
            Iterator it = omDocument.getChildren();
            while (it.hasNext()) {
                OMNode omNode = (OMNode)it.next();
                omNode.serializeAndConsume(writer);
            }
        }
        finally {
            builder.close();
        }
    }

    private static void copy(SOAPFactory factory, OMContainer targetParent, OMNode sourceNode) {
        if (sourceNode instanceof SOAPHeaderBlock) {
            CopyUtils.copySOAPHeaderBlock(factory, targetParent, (SOAPHeaderBlock)sourceNode);
        } else if (sourceNode instanceof SOAPFault) {
            CopyUtils.copySOAPFault(factory, targetParent, (SOAPFault)sourceNode);
        } else if (sourceNode instanceof OMSourcedElement) {
            CopyUtils.copyOMSourcedElement(factory, targetParent, (OMSourcedElement)sourceNode);
        } else {
            int type = sourceNode.getType();
            switch (type) {
                case 1: {
                    CopyUtils.copyOMElement(factory, targetParent, (OMElement)sourceNode);
                    break;
                }
                case 4: {
                    CopyUtils.copyOMText(factory, targetParent, (OMText)sourceNode);
                    break;
                }
                case 5: {
                    CopyUtils.copyOMComment(factory, targetParent, (OMComment)sourceNode);
                    break;
                }
                default: {
                    throw new OMException("Internal Failure: Cannot make a copy of " + sourceNode.getClass().getName());
                }
            }
        }
    }

    private static void copyOMComment(SOAPFactory factory, OMContainer targetParent, OMComment sourceComment) {
        factory.createOMComment(targetParent, sourceComment.getValue());
    }

    private static void copyOMText(SOAPFactory factory, OMContainer targetParent, OMText sourceText) {
        if (IS_DEBUG_ENABLED) {
            log.debug((Object)"start copyOMText");
        }
        if (sourceText.isBinary()) {
            Object dh = sourceText.getDataHandler();
            if (IS_DEBUG_ENABLED) {
                String dhclass = dh == null ? "null" : dh.getClass().toString();
                log.debug((Object)("The source text's binary data handler is " + dhclass));
            }
        }
        factory.createOMText(targetParent, sourceText);
        if (IS_DEBUG_ENABLED) {
            log.debug((Object)"end copyOMText");
        }
    }

    private static void copyOMElement(SOAPFactory factory, OMContainer targetParent, OMElement sourceElement) {
        targetParent.addChild(sourceElement.cloneOMElement());
    }

    private static void copyOMSourcedElement(SOAPFactory factory, OMContainer targetParent, OMSourcedElement sourceOMSE) {
        OMDataSource ds = sourceOMSE.getDataSource();
        if (ds == null || sourceOMSE.isExpanded() || !(ds instanceof OMDataSourceExt)) {
            CopyUtils.copyOMElement(factory, targetParent, sourceOMSE);
            return;
        }
        OMDataSourceExt sourceDS = (OMDataSourceExt)ds;
        if (sourceDS.isDestructiveRead() || sourceDS.isDestructiveWrite()) {
            CopyUtils.copyOMElement(factory, targetParent, sourceOMSE);
            return;
        }
        OMDataSourceExt targetDS = ((OMDataSourceExt)ds).copy();
        if (targetDS == null) {
            CopyUtils.copyOMElement(factory, targetParent, sourceOMSE);
            return;
        }
        OMSourcedElement targetOMSE = factory.createOMElement(targetDS, sourceOMSE.getLocalName(), sourceOMSE.getNamespace());
        targetParent.addChild(targetOMSE);
    }

    private static void copySOAPHeaderBlock(SOAPFactory factory, OMContainer targetParent, SOAPHeaderBlock sourceSHB) {
        OMDataSource ds = sourceSHB.getDataSource();
        if (ds == null || sourceSHB.isExpanded() || !(ds instanceof OMDataSourceExt)) {
            CopyUtils.copySOAPHeaderBlock_NoDataSource(factory, targetParent, sourceSHB);
            return;
        }
        OMDataSourceExt sourceDS = (OMDataSourceExt)ds;
        if (sourceDS.isDestructiveRead() || sourceDS.isDestructiveWrite()) {
            CopyUtils.copySOAPHeaderBlock_NoDataSource(factory, targetParent, sourceSHB);
            return;
        }
        OMDataSourceExt targetDS = ((OMDataSourceExt)ds).copy();
        SOAPHeaderBlock targetSHB = factory.createSOAPHeaderBlock(sourceSHB.getLocalName(), sourceSHB.getNamespace(), targetDS);
        targetParent.addChild(targetSHB);
        CopyUtils.copySOAPHeaderBlockData(sourceSHB, targetSHB);
    }

    private static void copySOAPHeaderBlock_NoDataSource(SOAPFactory factory, OMContainer targetParent, SOAPHeaderBlock sourceSHB) {
        SOAPHeader header = (SOAPHeader)targetParent;
        String localName = sourceSHB.getLocalName();
        OMNamespace ns = sourceSHB.getNamespace();
        SOAPHeaderBlock targetSHB = factory.createSOAPHeaderBlock(localName, ns, header);
        CopyUtils.copyTagData(sourceSHB, targetSHB);
        CopyUtils.copySOAPHeaderBlockData(sourceSHB, targetSHB);
        Iterator i = sourceSHB.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            CopyUtils.copy(factory, targetSHB, node);
        }
    }

    private static void copySOAPFault(SOAPFactory factory, OMContainer targetParent, SOAPFault sourceSOAPFault) {
        Exception e = sourceSOAPFault.getException();
        SOAPFault newSOAPFault = e == null ? factory.createSOAPFault((SOAPBody)targetParent) : factory.createSOAPFault((SOAPBody)targetParent, e);
        CopyUtils.copyTagData(sourceSOAPFault, newSOAPFault);
        Iterator i = sourceSOAPFault.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            CopyUtils.copyFaultData(factory, newSOAPFault, node);
        }
    }

    private static void copyFaultData(SOAPFactory factory, SOAPFault targetFault, OMNode sourceNode) {
        if (sourceNode instanceof SOAPFaultCode) {
            CopyUtils.copySOAPFaultCode(factory, targetFault, (SOAPFaultCode)sourceNode);
        } else if (sourceNode instanceof SOAPFaultDetail) {
            CopyUtils.copySOAPFaultDetail(factory, targetFault, (SOAPFaultDetail)sourceNode);
        } else if (sourceNode instanceof SOAPFaultNode) {
            CopyUtils.copySOAPFaultNode(factory, targetFault, (SOAPFaultNode)sourceNode);
        } else if (sourceNode instanceof SOAPFaultReason) {
            CopyUtils.copySOAPFaultReason(factory, targetFault, (SOAPFaultReason)sourceNode);
        } else if (sourceNode instanceof SOAPFaultRole) {
            CopyUtils.copySOAPFaultRole(factory, targetFault, (SOAPFaultRole)sourceNode);
        } else if (sourceNode.getType() == 4) {
            CopyUtils.copyOMText(factory, targetFault, (OMText)sourceNode);
        } else if (sourceNode.getType() == 5) {
            CopyUtils.copyOMComment(factory, targetFault, (OMComment)sourceNode);
        } else {
            throw new OMException("Internal Failure: Cannot make a copy of " + sourceNode.getClass().getName() + " object found in a SOAPFault.");
        }
    }

    private static void copySOAPFaultRole(SOAPFactory factory, SOAPFault targetFault, SOAPFaultRole sourceRole) {
        SOAPFaultRole targetRole = factory.createSOAPFaultRole(targetFault);
        CopyUtils.copyTagData(sourceRole, targetRole);
        targetRole.setRoleValue(sourceRole.getRoleValue());
    }

    private static void copySOAPFaultNode(SOAPFactory factory, SOAPFault targetFault, SOAPFaultNode sourceNode) {
        SOAPFaultNode targetNode = factory.createSOAPFaultNode(targetFault);
        CopyUtils.copyTagData(sourceNode, targetNode);
        targetNode.setNodeValue(sourceNode.getNodeValue());
    }

    private static void copySOAPFaultDetail(SOAPFactory factory, SOAPFault targetFault, SOAPFaultDetail sourceDetail) {
        SOAPFaultDetail targetDetail = factory.createSOAPFaultDetail(targetFault);
        CopyUtils.copyTagData(sourceDetail, targetDetail);
        Iterator i = sourceDetail.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            CopyUtils.copy(factory, targetDetail, node);
        }
    }

    private static void copySOAPFaultReason(SOAPFactory factory, SOAPFault targetFault, SOAPFaultReason sourceReason) {
        SOAPFaultReason targetReason = factory.createSOAPFaultReason(targetFault);
        CopyUtils.copyTagData(sourceReason, targetReason);
        Iterator i = sourceReason.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            if (node instanceof SOAPFaultText) {
                SOAPFaultText oldText = (SOAPFaultText)node;
                SOAPFaultText newText = factory.createSOAPFaultText(targetReason);
                CopyUtils.copyTagData(oldText, newText);
                continue;
            }
            CopyUtils.copy(factory, targetReason, node);
        }
    }

    private static void copySOAPFaultCode(SOAPFactory factory, SOAPFault targetFault, SOAPFaultCode sourceCode) {
        SOAPFaultCode targetCode = factory.createSOAPFaultCode(targetFault);
        CopyUtils.copyTagData(sourceCode, targetCode);
        SOAPFaultValue sourceValue = sourceCode.getValue();
        SOAPFaultValue targetValue = factory.createSOAPFaultValue(targetCode);
        CopyUtils.copyTagData(sourceValue, targetValue);
        Iterator i = sourceValue.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            CopyUtils.copy(factory, targetValue, node);
        }
        SOAPFaultSubCode sourceSubCode = sourceCode.getSubCode();
        if (sourceSubCode != null) {
            CopyUtils.copySOAPFaultSubCode(factory, targetCode, sourceSubCode);
        }
    }

    private static void copySOAPFaultSubCode(SOAPFactory factory, OMElement targetParent, SOAPFaultSubCode sourceSubCode) {
        SOAPFaultSubCode targetSubCode = targetParent instanceof SOAPFaultSubCode ? factory.createSOAPFaultSubCode((SOAPFaultSubCode)targetParent) : factory.createSOAPFaultSubCode((SOAPFaultCode)targetParent);
        CopyUtils.copyTagData(sourceSubCode, targetSubCode);
        SOAPFaultValue sourceValue = sourceSubCode.getValue();
        SOAPFaultValue targetValue = factory.createSOAPFaultValue(targetSubCode);
        CopyUtils.copyTagData(sourceValue, targetValue);
        Iterator i = sourceValue.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            CopyUtils.copy(factory, targetValue, node);
        }
        SOAPFaultSubCode sourceSubSubCode = sourceSubCode.getSubCode();
        if (sourceSubSubCode != null) {
            CopyUtils.copySOAPFaultSubCode(factory, targetSubCode, sourceSubSubCode);
        }
    }

    private static void copyTagData(OMElement sourceElement, OMElement targetElement) {
        Iterator i = sourceElement.getAllDeclaredNamespaces();
        while (i.hasNext()) {
            OMNamespace ns = (OMNamespace)i.next();
            targetElement.declareNamespace(ns);
        }
        i = sourceElement.getAllAttributes();
        while (i.hasNext()) {
            OMAttribute attr = (OMAttribute)i.next();
            targetElement.addAttribute(attr);
        }
    }

    private static void copySOAPHeaderBlockData(SOAPHeaderBlock sourceSHB, SOAPHeaderBlock targetSHB) {
        if (sourceSHB.isProcessed()) {
            targetSHB.setProcessed();
        }
    }
}

