/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.server;

import java.net.InetSocketAddress;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.sharing.registry.messaging.SharingServiceDBEventMessagingFactory;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.server.SharingRegistryServerHandler;
import org.apache.airavata.sharing.registry.service.cpi.SharingRegistryService;
import org.apache.airavata.sharing.registry.utils.Constants;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingRegistryServer
implements IServer {
    private static final Logger logger = LoggerFactory.getLogger(SharingRegistryServer.class);
    public static final String SHARING_REG_SERVER_HOST = "sharing.registry.server.host";
    public static final String SHARING_REG_SERVER_PORT = "sharing.registry.server.port";
    private static final String SERVER_NAME = "Sharing Registry Server";
    private static final String SERVER_VERSION = "1.0";
    private IServer.ServerStatus status;
    private TServer server;

    public SharingRegistryServer() {
        this.setStatus(IServer.ServerStatus.STOPPED);
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }

    public void start() throws Exception {
        try {
            TServerSocket serverTransport;
            this.setStatus(IServer.ServerStatus.STARTING);
            final int serverPort = Integer.parseInt(ServerSettings.getSetting((String)SHARING_REG_SERVER_PORT));
            String serverHost = ServerSettings.getSetting((String)SHARING_REG_SERVER_HOST);
            SharingRegistryService.Processor processor = new SharingRegistryService.Processor((SharingRegistryService.Iface)new SharingRegistryServerHandler());
            if (serverHost == null) {
                serverTransport = new TServerSocket(serverPort);
            } else {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(serverHost, serverPort);
                serverTransport = new TServerSocket(inetSocketAddress);
            }
            TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)serverTransport);
            options.minWorkerThreads = 30;
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)options.processor((TProcessor)processor));
            new Thread(){

                @Override
                public void run() {
                    SharingRegistryServer.this.server.serve();
                    SharingRegistryServer.this.setStatus(IServer.ServerStatus.STOPPED);
                    logger.info("Sharing Registry Server Stopped.");
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    while (!SharingRegistryServer.this.server.isServing()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (SharingRegistryServer.this.server.isServing()) {
                        try {
                            logger.info("Register sharing service with DB Event publishers");
                            SharingServiceDBEventMessagingFactory.registerSharingServiceWithPublishers(Constants.PUBLISHERS);
                            logger.info("Start sharing service DB Event subscriber");
                            SharingServiceDBEventMessagingFactory.getDBEventSubscriber();
                        }
                        catch (AiravataException | SharingRegistryException e) {
                            logger.error("Error starting sharing service. Error setting up DB event services.");
                            SharingRegistryServer.this.server.stop();
                        }
                        SharingRegistryServer.this.setStatus(IServer.ServerStatus.STARTED);
                        logger.info("Starting Sharing Registry Server on Port " + serverPort);
                        logger.info("Listening to Sharing Registry server clients ....");
                    }
                }
            }.start();
        }
        catch (TTransportException e) {
            this.setStatus(IServer.ServerStatus.FAILED);
            throw new Exception("Error while starting the Sharing Registry service", e);
        }
    }

    public void stop() throws Exception {
        if (this.server != null && this.server.isServing()) {
            this.setStatus(IServer.ServerStatus.STOPING);
            this.server.stop();
        }
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }

    public TServer getServer() {
        return this.server;
    }

    public void setServer(TServer server) {
        this.server = server;
    }
}

