/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports.util;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.core.transports.util.XsdUtil;

public class XsdProcessor
implements HttpGetRequestProcessor {
    @Override
    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configCtx) throws Exception {
        String requestURI = request.getRequestURI();
        String contextPath = configCtx.getServiceContextPath();
        String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
        AxisService axisService = configCtx.getAxisConfiguration().getServiceForActivation(serviceName);
        if (axisService == null) {
            axisService = TenantAxisUtils.getAxisService(serviceName, configCtx);
            XsdUtil.printXsd(request, response, TenantAxisUtils.getTenantConfigurationContextFromUrl(requestURI, configCtx), serviceName, axisService);
        } else {
            XsdUtil.printXsd(request, response, configCtx, serviceName, axisService);
        }
    }
}

