/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.CarbonAxisConfigurator;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.TenantAxisConfigurator;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SynchronizeRepositoryRequest
extends ClusteringMessage {
    private static final transient Log log = LogFactory.getLog(SynchronizeRepositoryRequest.class);
    private int tenantId;
    private String tenantDomain;

    public SynchronizeRepositoryRequest() {
    }

    public SynchronizeRepositoryRequest(int tenantId, String tenantDomain) {
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        log.info((Object)("Received [" + (Object)((Object)this) + "] "));
        if (this.tenantId == -1234 || TenantAxisUtils.getTenantConfigurationContexts(configContext).get(this.tenantDomain) != null) {
            log.info((Object)"Going to synchronize artifacts... ");
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain(this.tenantDomain);
                carbonContext.setTenantId(this.tenantId);
                this.updateDeploymentRepository(configContext);
                log.info((Object)"Artifact synchronization complete... ");
                this.doDeployment(configContext);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        } else {
            log.info((Object)"Tenant is not loaded. ");
        }
    }

    private void doDeployment(ConfigurationContext configContext) {
        AxisConfigurator axisConfigurator;
        if (!"carbon.super".equals(this.tenantDomain)) {
            configContext = TenantAxisUtils.getTenantConfigurationContext(this.tenantDomain, configContext);
        }
        if ((axisConfigurator = configContext.getAxisConfiguration().getConfigurator()) instanceof CarbonAxisConfigurator) {
            ((CarbonAxisConfigurator)axisConfigurator).runDeployment();
        } else if (axisConfigurator instanceof TenantAxisConfigurator) {
            ((TenantAxisConfigurator)axisConfigurator).runDeployment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeploymentRepository(ConfigurationContext configContext) {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(DeploymentSynchronizer.class.getName());
        if (reference != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, DeploymentSynchronizer.class.getName(), null);
            try {
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    if (GhostDeployerUtils.isGhostOn() && GhostDeployerUtils.isPartialUpdateEnabled() && CarbonUtils.isWorkerNode() && this.tenantId > 0) {
                        String repoPath = MultitenantUtils.getAxis2RepositoryPath((int)this.tenantId);
                        ((DeploymentSynchronizer)obj).update(repoPath, repoPath, 3);
                        continue;
                    }
                    ((DeploymentSynchronizer)obj).update(this.tenantId);
                }
            }
            catch (Exception e) {
                log.error((Object)("Repository update failed for tenant " + this.tenantId), (Throwable)e);
                this.setRepoUpdateFailed(configContext);
            }
            finally {
                serviceTracker.close();
            }
        }
    }

    private void setRepoUpdateFailed(ConfigurationContext configContext) {
        AxisConfigurator axisConfigurator = configContext.getAxisConfiguration().getConfigurator();
        if (axisConfigurator instanceof CarbonAxisConfigurator) {
            ((CarbonAxisConfigurator)axisConfigurator).setRepoUpdateFailed();
        } else if (axisConfigurator instanceof TenantAxisConfigurator) {
            ((TenantAxisConfigurator)axisConfigurator).setRepoUpdateFailed();
        }
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public String toString() {
        return "SynchronizeRepositoryRequest{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", messageId=" + this.getUuid() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SynchronizeRepositoryRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SynchronizeRepositoryRequest that = (SynchronizeRepositoryRequest)((Object)o);
        return this.tenantId == that.tenantId && this.tenantDomain.equals(that.tenantDomain);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.tenantId;
        result = 31 * result + this.tenantDomain.hashCode();
        return result;
    }
}

