/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.ClearBackupOperation;
import com.hazelcast.collection.operations.CollectionOperation;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.util.Collection;
import java.util.Map;

public class ClearOperation
extends CollectionOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    transient Map<Data, Collection<CollectionRecord>> objects;

    public ClearOperation() {
    }

    public ClearOperation(CollectionProxyId proxyId) {
        super(proxyId);
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.hasListener()) {
            CollectionContainer container = this.getOrCreateContainer();
            this.objects = container.copyCollections();
        }
    }

    @Override
    public void run() throws Exception {
        CollectionContainer container = this.getOrCreateContainer();
        container.clearCollections();
        this.response = true;
    }

    @Override
    public void afterRun() throws Exception {
        if (this.objects != null && !this.objects.isEmpty()) {
            CollectionContainer container = this.getOrCreateContainer();
            for (Map.Entry<Data, Collection<CollectionRecord>> entry : this.objects.entrySet()) {
                Data key = entry.getKey();
                if (container.isLocked(key)) continue;
                Collection<CollectionRecord> coll = entry.getValue();
                for (CollectionRecord record : coll) {
                    this.publishEvent(EntryEventType.REMOVED, key, record.getObject());
                }
            }
            this.objects.clear();
        }
        this.objects = null;
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.objects != null && !this.objects.isEmpty());
    }

    @Override
    public Operation getBackupOperation() {
        return new ClearBackupOperation(this.proxyId);
    }

    @Override
    public int getId() {
        return 3;
    }
}

