/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.multimap.tx.TxnRollbackBackupOperation;
import com.hazelcast.collection.operations.CollectionBackupAwareOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.transaction.TransactionException;

public class TxnRollbackOperation
extends CollectionBackupAwareOperation
implements Notifier {
    public TxnRollbackOperation() {
    }

    public TxnRollbackOperation(CollectionProxyId proxyId, Data dataKey, int threadId) {
        super(proxyId, dataKey, threadId);
    }

    @Override
    public void run() throws Exception {
        CollectionContainer container = this.getOrCreateContainer();
        if (container.isLocked(this.dataKey) && !container.unlock(this.dataKey, this.getCallerUuid(), this.threadId)) {
            throw new TransactionException("Lock is not owned by the transaction! Owner: " + container.getLockOwnerInfo(this.dataKey));
        }
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnRollbackBackupOperation(this.proxyId, this.dataKey, this.getCallerUuid(), this.threadId);
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getWaitKey();
    }

    @Override
    public int getId() {
        return 37;
    }
}

