/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.infoset.xpath.impl;

import java.util.HashMap;
import java.util.Iterator;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlCharacters;
import org.xmlpull.infoset.XmlComment;
import org.xmlpull.infoset.XmlContainer;
import org.xmlpull.infoset.XmlDocument;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.XmlProcessingInstruction;
import org.xmlpull.infoset.xpath.XisXPath;
import org.xmlpull.infoset.xpath.impl.XPathNamespace;
import org.xmlpull.infoset.xpath.jaxen.DefaultNavigator;
import org.xmlpull.infoset.xpath.jaxen.FunctionCallException;
import org.xmlpull.infoset.xpath.jaxen.XPath;
import org.xmlpull.infoset.xpath.jaxen.util.SingleObjectIterator;
import org.xmlpull.infoset.xpath.saxpath.SAXPathException;

public class DocumentNavigator
extends DefaultNavigator {
    private static DocumentNavigator instance = new DocumentNavigator();

    public static DocumentNavigator getInstance() {
        return instance;
    }

    @Override
    public boolean isElement(Object obj) {
        return obj instanceof XmlElement;
    }

    @Override
    public boolean isComment(Object obj) {
        return obj instanceof XmlComment;
    }

    @Override
    public boolean isText(Object obj) {
        return obj instanceof String || obj instanceof XmlCharacters;
    }

    @Override
    public boolean isAttribute(Object obj) {
        return obj instanceof XmlAttribute;
    }

    @Override
    public boolean isProcessingInstruction(Object obj) {
        return obj instanceof XmlProcessingInstruction;
    }

    @Override
    public boolean isDocument(Object obj) {
        return obj instanceof XmlDocument;
    }

    @Override
    public boolean isNamespace(Object obj) {
        return obj instanceof XmlNamespace || obj instanceof XPathNamespace;
    }

    @Override
    public String getElementName(Object obj) {
        XmlElement elem = (XmlElement)obj;
        return elem.getName();
    }

    @Override
    public String getElementNamespaceUri(Object obj) {
        XmlElement elem = (XmlElement)obj;
        String uri = elem.getNamespaceName();
        if (uri != null && uri.length() == 0) {
            return null;
        }
        return uri;
    }

    @Override
    public String getAttributeName(Object obj) {
        XmlAttribute attr = (XmlAttribute)obj;
        return attr.getName();
    }

    @Override
    public String getAttributeNamespaceUri(Object obj) {
        XmlAttribute attr = (XmlAttribute)obj;
        String uri = attr.getNamespaceName();
        if (uri != null && uri.length() == 0) {
            return null;
        }
        return uri;
    }

    @Override
    public Iterator getChildAxisIterator(Object contextNode) {
        if (contextNode instanceof XmlElement) {
            return ((XmlElement)contextNode).children().iterator();
        }
        if (contextNode instanceof XmlDocument) {
            return ((XmlDocument)contextNode).children().iterator();
        }
        return null;
    }

    @Override
    public Iterator getNamespaceAxisIterator(Object contextNode) {
        if (!(contextNode instanceof XmlElement)) {
            return null;
        }
        XmlElement elem = (XmlElement)contextNode;
        HashMap<String, XPathNamespace> nsMap = new HashMap<String, XPathNamespace>();
        XmlElement current = elem;
        while (current != null) {
            XmlNamespace ns = current.getNamespace();
            if (ns != null && ns.getPrefix() != null && !nsMap.containsKey(ns.getPrefix())) {
                nsMap.put(ns.getPrefix(), new XPathNamespace(elem, ns));
            }
            for (XmlNamespace declaredInThisElNs : current.namespaces()) {
                if (nsMap.containsKey(declaredInThisElNs.getPrefix())) continue;
                nsMap.put(declaredInThisElNs.getPrefix(), new XPathNamespace(elem, declaredInThisElNs));
            }
            if (current.getParent() instanceof XmlElement) {
                current = (XmlElement)current.getParent();
                continue;
            }
            current = null;
        }
        return nsMap.values().iterator();
    }

    @Override
    public Iterator getParentAxisIterator(Object contextNode) {
        Object parent = null;
        if (contextNode instanceof XmlDocument) {
            parent = contextNode;
        } else if (contextNode instanceof XmlElement) {
            parent = ((XmlElement)contextNode).getParent();
        } else if (contextNode instanceof XmlAttribute) {
            parent = ((XmlAttribute)contextNode).getOwner();
        } else if (contextNode instanceof XPathNamespace) {
            parent = ((XPathNamespace)contextNode).getElement();
        } else if (contextNode instanceof XmlProcessingInstruction) {
            parent = ((XmlProcessingInstruction)contextNode).getParent();
        } else {
            if (contextNode instanceof XmlComment) {
                throw new IllegalStateException("XB1 XML tree does not support comments for XPath");
            }
            if (contextNode instanceof XmlCharacters) {
                parent = ((XmlCharacters)contextNode).getParent();
            } else if (contextNode instanceof String) {
                throw new IllegalStateException("XB1 XML tree should not contain Strings directly");
            }
        }
        if (parent != null) {
            return new SingleObjectIterator(parent);
        }
        return null;
    }

    @Override
    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (!(contextNode instanceof XmlElement)) {
            return null;
        }
        XmlElement elem = (XmlElement)contextNode;
        return elem.attributes().iterator();
    }

    @Override
    public XPath parseXPath(String xpath) throws SAXPathException {
        return new XisXPath(xpath);
    }

    private static XmlDocument getDocument(XmlElement el) {
        XmlElement root = el;
        while (root.getParent() instanceof XmlElement) {
            root = (XmlElement)root.getParent();
        }
        return (XmlDocument)root.getParent();
    }

    @Override
    public Object getDocumentNode(Object contextNode) {
        if (contextNode instanceof XmlDocument) {
            return contextNode;
        }
        XmlElement elem = (XmlElement)contextNode;
        return DocumentNavigator.getDocument(elem);
    }

    @Override
    public String getElementQName(Object obj) {
        XmlElement elem = (XmlElement)obj;
        String prefix = null;
        if (elem.getNamespace() != null) {
            prefix = elem.getNamespace().getPrefix();
        }
        if (prefix == null || "".equals(prefix)) {
            return elem.getName();
        }
        return prefix + ":" + elem.getName();
    }

    @Override
    public String getAttributeQName(Object obj) {
        XmlAttribute attr = (XmlAttribute)obj;
        String prefix = null;
        if (attr.getNamespace() != null) {
            prefix = attr.getNamespace().getPrefix();
        }
        if (prefix == null || "".equals(prefix)) {
            return attr.getName();
        }
        return prefix + ":" + attr.getName();
    }

    @Override
    public String getNamespaceStringValue(Object obj) {
        if (obj instanceof XmlNamespace) {
            XmlNamespace ns = (XmlNamespace)obj;
            return ns.getName();
        }
        XPathNamespace ns = (XPathNamespace)obj;
        return ns.getNamespace().getName();
    }

    @Override
    public String getNamespacePrefix(Object obj) {
        if (obj instanceof XmlNamespace) {
            XmlNamespace ns = (XmlNamespace)obj;
            return ns.getPrefix();
        }
        XPathNamespace ns = (XPathNamespace)obj;
        return ns.getNamespace().getPrefix();
    }

    @Override
    public String getTextStringValue(Object obj) {
        if (obj instanceof XmlCharacters) {
            return ((XmlCharacters)obj).getText();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    @Override
    public String getAttributeStringValue(Object obj) {
        XmlAttribute attr = (XmlAttribute)obj;
        return attr.getValue();
    }

    @Override
    public String getElementStringValue(Object obj) {
        XmlElement elem = (XmlElement)obj;
        StringBuffer buf = new StringBuffer();
        Iterator contentIter = elem.children().iterator();
        Object each = null;
        while (contentIter.hasNext()) {
            each = contentIter.next();
            if (each instanceof String) {
                buf.append((String)each);
                continue;
            }
            if (each instanceof XmlCharacters) {
                buf.append(((XmlCharacters)each).getText());
                continue;
            }
            if (!(each instanceof XmlElement)) continue;
            buf.append(this.getElementStringValue(each));
        }
        return buf.toString();
    }

    @Override
    public String getProcessingInstructionTarget(Object obj) {
        XmlProcessingInstruction pi = (XmlProcessingInstruction)obj;
        return pi.getTarget();
    }

    @Override
    public String getProcessingInstructionData(Object obj) {
        XmlProcessingInstruction pi = (XmlProcessingInstruction)obj;
        return pi.getContent();
    }

    @Override
    public String getCommentStringValue(Object obj) {
        XmlComment cmt = (XmlComment)obj;
        return cmt.getContent();
    }

    @Override
    public String translateNamespacePrefixToUri(String prefix, Object context) {
        XmlNamespace namespace;
        XmlElement element = null;
        if (context instanceof XmlElement) {
            element = (XmlElement)context;
        } else if (context instanceof XmlCharacters) {
            element = (XmlElement)((XmlCharacters)context).getParent();
        } else if (context instanceof XmlAttribute) {
            element = ((XmlAttribute)context).getOwner();
        } else if (context instanceof XPathNamespace) {
            element = ((XPathNamespace)context).getElement();
        } else {
            if (context instanceof XmlComment) {
                throw new IllegalArgumentException("could not determine parent of comment in " + context);
            }
            if (context instanceof XmlProcessingInstruction) {
                XmlContainer container = ((XmlProcessingInstruction)context).getParent();
                if (container instanceof XmlElement) {
                    element = (XmlElement)container;
                }
            } else if (context instanceof String) {
                throw new IllegalArgumentException("could not determine parent of string in " + context);
            }
        }
        if (element != null && (namespace = element.lookupNamespaceByPrefix(prefix)) != null) {
            return namespace.getName();
        }
        return null;
    }

    @Override
    public Object getDocument(String url) throws FunctionCallException {
        try {
            XmlInfosetBuilder builder = XmlInfosetBuilder.newInstance();
            return builder.parseLocation(url);
        }
        catch (Exception e) {
            throw new FunctionCallException(e.getMessage());
        }
    }
}

