/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cluster.monitoring;

import org.apache.airavata.cluster.monitoring.ClusterStatusMonitorJob;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStatusMonitorJobScheduler {
    private static final Logger logger = LoggerFactory.getLogger(ClusterStatusMonitorJobScheduler.class);
    Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();

    public ClusterStatusMonitorJobScheduler() throws SchedulerException {
        this.scheduler.start();
    }

    public void scheduleClusterStatusMonitoring() throws SchedulerException, ApplicationSettingsException {
        JobDetail job = JobBuilder.newJob(ClusterStatusMonitorJob.class).withIdentity("cluster-status-monitoring", "airavata").build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("cluster-status-monitoring-trigger", "airavata").startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(Integer.parseInt(ServerSettings.getClusterStatusMonitoringRepatTime())).repeatForever()).build();
        this.scheduler.scheduleJob(job, trigger);
    }

    public static void main(String[] args) throws SchedulerException, ApplicationSettingsException {
        ClusterStatusMonitorJobScheduler jobScheduler = new ClusterStatusMonitorJobScheduler();
        jobScheduler.scheduleClusterStatusMonitoring();
    }
}

