/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SignatureTrustValidator;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;

public class SamlAssertionValidator
extends SignatureTrustValidator {
    private static Log LOG = LogFactory.getLog(SamlAssertionValidator.class);

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getAssertion() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        AssertionWrapper assertion = credential.getAssertion();
        String confirmMethod = null;
        List<String> methods = assertion.getConfirmationMethods();
        if (methods != null && methods.size() > 0) {
            confirmMethod = methods.get(0);
        }
        if (OpenSAMLUtil.isMethodHolderOfKey(confirmMethod)) {
            if (assertion.getSubjectKeyInfo() == null) {
                LOG.debug((Object)"There is no Subject KeyInfo to match the holder-of-key subject conf method");
                throw new WSSecurityException(0, "noKeyInSAMLToken");
            }
            if (!assertion.isSigned()) {
                LOG.debug((Object)"A holder-of-key assertion must be signed");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        this.checkConditions(assertion);
        this.validateAssertion(assertion);
        if (assertion.isSigned()) {
            this.verifySignedAssertion(assertion, data);
        }
        return credential;
    }

    protected Credential verifySignedAssertion(AssertionWrapper assertion, RequestData data) throws WSSecurityException {
        Credential trustCredential = new Credential();
        SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
        trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
        trustCredential.setCertificates(samlKeyInfo.getCerts());
        return super.validate(trustCredential, data);
    }

    protected void checkConditions(AssertionWrapper assertion) throws WSSecurityException {
        DateTime validFrom = null;
        DateTime validTill = null;
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && assertion.getSaml2().getConditions() != null) {
            validFrom = assertion.getSaml2().getConditions().getNotBefore();
            validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
        } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11) && assertion.getSaml1().getConditions() != null) {
            validFrom = assertion.getSaml1().getConditions().getNotBefore();
            validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
        }
        if (validFrom != null && validFrom.isAfterNow()) {
            LOG.debug((Object)"SAML Token condition (Not Before) not met");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (validTill != null && validTill.isBeforeNow()) {
            LOG.debug((Object)"SAML Token condition (Not On Or After) not met");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    protected void validateAssertion(AssertionWrapper assertion) throws WSSecurityException {
        if (assertion.getSaml1() != null) {
            ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml1-schema-validator");
            ValidatorSuite specValidators = Configuration.getValidatorSuite((String)"saml1-spec-validator");
            try {
                schemaValidators.validate((XMLObject)assertion.getSaml1());
                specValidators.validate((XMLObject)assertion.getSaml1());
            }
            catch (ValidationException e) {
                LOG.debug((Object)("Saml Validation error: " + e.getMessage()), (Throwable)e);
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        if (assertion.getSaml2() != null) {
            ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml2-core-schema-validator");
            ValidatorSuite specValidators = Configuration.getValidatorSuite((String)"saml2-core-spec-validator");
            try {
                schemaValidators.validate((XMLObject)assertion.getSaml2());
                specValidators.validate((XMLObject)assertion.getSaml2());
            }
            catch (ValidationException e) {
                LOG.debug((Object)("Saml Validation error: " + e.getMessage()), (Throwable)e);
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
    }
}

