/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeAlarmHistoryRequestMarshaller
implements Marshaller<Request<DescribeAlarmHistoryRequest>, DescribeAlarmHistoryRequest> {
    public Request<DescribeAlarmHistoryRequest> marshall(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        if (describeAlarmHistoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmHistoryRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarmHistory");
        request.addParameter("Version", "2010-08-01");
        if (describeAlarmHistoryRequest.getAlarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)describeAlarmHistoryRequest.getAlarmName()));
        }
        if (describeAlarmHistoryRequest.getHistoryItemType() != null) {
            request.addParameter("HistoryItemType", StringUtils.fromString((String)describeAlarmHistoryRequest.getHistoryItemType()));
        }
        if (describeAlarmHistoryRequest.getStartDate() != null) {
            request.addParameter("StartDate", StringUtils.fromDate((Date)describeAlarmHistoryRequest.getStartDate()));
        }
        if (describeAlarmHistoryRequest.getEndDate() != null) {
            request.addParameter("EndDate", StringUtils.fromDate((Date)describeAlarmHistoryRequest.getEndDate()));
        }
        if (describeAlarmHistoryRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAlarmHistoryRequest.getMaxRecords()));
        }
        if (describeAlarmHistoryRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAlarmHistoryRequest.getNextToken()));
        }
        return request;
    }
}

