/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.api.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.error.AiravataSystemException;
import org.apache.derby.drda.NetworkServerControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataDerbyServer
implements IServer {
    private static final Logger logger = LoggerFactory.getLogger(AiravataDerbyServer.class);
    private static final String SERVER_NAME = "Airavata Derby Server";
    private static final String SERVER_VERSION = "1.0";
    public static final String CONFIGURATION_TABLE = "CONFIGURATION";
    public static final String REGISTRY_JDBC_DRIVER = "registry.jdbc.driver";
    public static final String REGISTRY_JDBC_URL = "registry.jdbc.url";
    public static final String REGISTRY_JDBC_USER = "registry.jdbc.user";
    public static final String REGISTRY_JDBC_PASSWORD = "registry.jdbc.password";
    public static final String START_DERBY_ENABLE = "start.derby.server.mode";
    public static final String DERBY_SERVER_MODE_SYS_PROPERTY = "derby.drda.startNetworkServer";
    public static final String DEFAULT_PROJECT_NAME = "default";
    private NetworkServerControl server;
    private String jdbcURl;
    private String jdbcUser;
    private String jdbcPassword;
    private IServer.ServerStatus status;

    public AiravataDerbyServer() {
        this.setStatus(IServer.ServerStatus.STOPPED);
    }

    public static int getPort(String jdbcURL) {
        try {
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getPort();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public void startDerbyInServerMode() {
        try {
            System.setProperty(DERBY_SERVER_MODE_SYS_PROPERTY, "true");
            this.server = new NetworkServerControl(InetAddress.getByName("0.0.0.0"), AiravataDerbyServer.getPort(this.jdbcURl), this.jdbcUser, this.jdbcPassword);
            PrintWriter consoleWriter = new PrintWriter(System.out, true);
            this.server.start(consoleWriter);
        }
        catch (IOException e) {
            logger.error("Unable to start Apache derby in the server mode! Check whether specified port is available");
        }
        catch (Exception e) {
            logger.error("Unable to start Apache derby in the server mode! Check whether specified port is available");
        }
    }

    public void stopDerbyInServerMode() {
        System.setProperty(DERBY_SERVER_MODE_SYS_PROPERTY, "false");
        if (this.server != null) {
            try {
                this.server.shutdown();
            }
            catch (Exception e) {
                logger.error("Error when stopping the derby server : " + e.getLocalizedMessage());
            }
        }
    }

    public void startDerbyServer() throws AiravataSystemException {
        this.startDerbyServer();
        this.setStatus(IServer.ServerStatus.STARTED);
    }

    public static void main(String[] args) {
        try {
            AiravataDerbyServer server = new AiravataDerbyServer();
            server.start();
        }
        catch (Exception e) {
            logger.error("Error while initializing derby server", (Throwable)e);
        }
    }

    public void start() throws Exception {
        this.setStatus(IServer.ServerStatus.STARTING);
        this.startDerbyServer();
    }

    public void stop() throws Exception {
        if (this.getStatus() == IServer.ServerStatus.STARTED) {
            this.setStatus(IServer.ServerStatus.STOPING);
            this.stopDerbyInServerMode();
            this.setStatus(IServer.ServerStatus.STOPPED);
        }
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
        try {
            this.jdbcURl = ServerSettings.getSetting((String)REGISTRY_JDBC_URL);
            this.jdbcUser = ServerSettings.getSetting((String)REGISTRY_JDBC_USER);
            this.jdbcPassword = ServerSettings.getSetting((String)REGISTRY_JDBC_PASSWORD);
            this.jdbcURl = this.jdbcURl + "?user=" + this.jdbcUser + "&password=" + this.jdbcPassword;
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to read airavata server properties", (Object)e.getMessage());
        }
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }
}

