/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.transport.http.AbstractAgent;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.IOUtils;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.OnDemandLogger;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyRegistry;

public class ListingAgent
extends AbstractAgent {
    private static final OnDemandLogger log = new OnDemandLogger(ListingAgent.class);
    private static final String LIST_MULTIPLE_SERVICE_JSP_NAME = "listServices.jsp";
    private static final String LIST_SINGLE_SERVICE_JSP_NAME = "listSingleService.jsp";
    private static final String LIST_FAULTY_SERVICES_JSP_NAME = "listFaultyService.jsp";

    public ListingAgent(ConfigurationContext aConfigContext) {
        super(aConfigContext);
    }

    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String query = httpServletRequest.getQueryString();
        if (query != null) {
            if (query.indexOf("wsdl2") > 0 || query.indexOf("wsdl") > 0 || query.indexOf("xsd") > 0 || query.indexOf("policy") > 0) {
                this.processListService(httpServletRequest, httpServletResponse);
            } else {
                super.handle(httpServletRequest, httpServletResponse);
            }
        } else {
            super.handle(httpServletRequest, httpServletResponse);
        }
    }

    protected void processListFaultyServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String serviceName = req.getParameter("serviceName");
        if (serviceName != null) {
            AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
            req.getSession().setAttribute("singleservice", (Object)service);
        }
        this.renderView(LIST_FAULTY_SERVICES_JSP_NAME, req, res);
    }

    protected void processIndex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.processListServices(httpServletRequest, httpServletResponse);
    }

    private String extractHost(String filePart) {
        int ipindex = filePart.indexOf("//");
        String ip = null;
        if (ipindex >= 0) {
            ip = filePart.substring(ipindex + 2, filePart.length());
            int seperatorIndex = ip.indexOf(":");
            int slashIndex = ip.indexOf("/");
            ip = seperatorIndex >= 0 ? ip.substring(0, seperatorIndex) : ip.substring(0, slashIndex);
        }
        return ip;
    }

    public void processExplicitSchemaAndWSDL(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap<String, AxisService> services = this.configContext.getAxisConfiguration().getServices();
        String filePart = req.getRequestURL().toString();
        String schema = filePart.substring(filePart.lastIndexOf("/") + 1, filePart.length());
        if (services != null && !services.isEmpty()) {
            for (AxisService service : services.values()) {
                InputStream stream = service.getClassLoader().getResourceAsStream("META-INF/" + schema);
                if (stream == null) continue;
                ServletOutputStream out = res.getOutputStream();
                res.setContentType("text/xml");
                IOUtils.copy(stream, (OutputStream)out, true);
                return;
            }
        }
    }

    public static void copy(InputStream stream, OutputStream ostream) throws IOException {
        IOUtils.copy(stream, ostream, false);
    }

    public String extractServiceName(String urlString) {
        String serviceName;
        int n = urlString.indexOf(this.configContext.getServiceContextPath());
        if (n != -1 && (serviceName = urlString.substring(n + this.configContext.getServiceContextPath().length(), urlString.length())).length() > 0) {
            if (serviceName.charAt(0) == '/') {
                serviceName = serviceName.substring(1);
            }
            return serviceName;
        }
        return urlString.substring(urlString.lastIndexOf("/") + 1, urlString.length());
    }

    public void processListService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String url = req.getRequestURL().toString();
        String serviceName = this.extractServiceName(url);
        HashMap<String, AxisService> services = this.configContext.getAxisConfiguration().getServices();
        String query = req.getQueryString();
        int wsdl2 = query.indexOf("wsdl2");
        int wsdl = query.indexOf("wsdl");
        int xsd = query.indexOf("xsd");
        int policy = query.indexOf("policy");
        if (services != null && !services.isEmpty()) {
            AxisService serviceObj = services.get(serviceName);
            if (serviceObj != null) {
                AxisService axisService = serviceObj;
                if (wsdl2 >= 0) {
                    this.handleWSDL2Request(req, res, url, axisService);
                    return;
                }
                if (wsdl >= 0) {
                    this.handleWSDLRequest(req, res, url, axisService);
                    return;
                }
                if (xsd >= 0) {
                    this.handleXSDRequest(req, res, axisService);
                    return;
                }
                if (policy >= 0) {
                    this.handlePolicyRequest(req, res, serviceName, axisService);
                    return;
                }
                req.getSession().setAttribute("singleservice", (Object)serviceObj);
            } else {
                req.getSession().setAttribute("singleservice", null);
                res.sendError(404, url);
            }
        }
        this.renderView(LIST_SINGLE_SERVICE_JSP_NAME, req, res);
    }

    private void handlePolicyRequest(HttpServletRequest req, HttpServletResponse res, String serviceName, AxisService axisService) throws IOException, ServletException {
        if (!this.canExposeServiceMetadata(axisService)) {
            res.sendError(403);
            return;
        }
        ExternalPolicySerializer serializer = new ExternalPolicySerializer();
        serializer.setAssertionsToFilter(this.configContext.getAxisConfiguration().getLocalPolicyAssertions());
        String idParam = req.getParameter("id");
        if (idParam != null) {
            Policy targetPolicy = this.findPolicy(idParam, axisService);
            if (targetPolicy != null) {
                try {
                    ServletOutputStream out = res.getOutputStream();
                    XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)out);
                    res.setContentType("application/wspolicy+xml");
                    targetPolicy.serialize(writer);
                    writer.flush();
                }
                catch (XMLStreamException e) {
                    throw new ServletException("Error occured when serializing the Policy", (Throwable)e);
                }
                catch (FactoryConfigurationError e) {
                    throw new ServletException("Error occured when serializing the Policy", (Throwable)e);
                }
            } else {
                ServletOutputStream out = res.getOutputStream();
                res.setContentType("text/html");
                String outStr = "<b>No policy found for id=" + idParam + "</b>";
                out.write(outStr.getBytes());
            }
        } else {
            PolicyInclude policyInclude = axisService.getPolicyInclude();
            Policy effecPolicy = policyInclude.getEffectivePolicy();
            if (effecPolicy != null) {
                try {
                    ServletOutputStream out = res.getOutputStream();
                    XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)out);
                    res.setContentType("application/wspolicy+xml");
                    effecPolicy.serialize(writer);
                    writer.flush();
                }
                catch (XMLStreamException e) {
                    throw new ServletException("Error occured when serializing the Policy", (Throwable)e);
                }
                catch (FactoryConfigurationError e) {
                    throw new ServletException("Error occured when serializing the Policy", (Throwable)e);
                }
            } else {
                ServletOutputStream out = res.getOutputStream();
                res.setContentType("text/html");
                String outStr = "<b>No effective policy for " + serviceName + " service</b>";
                out.write(outStr.getBytes());
            }
        }
    }

    private void handleXSDRequest(HttpServletRequest req, HttpServletResponse res, AxisService axisService) throws IOException {
        if (!this.canExposeServiceMetadata(axisService)) {
            res.sendError(403);
            return;
        }
        res.setContentType("text/xml");
        int ret = axisService.printXSD((OutputStream)res.getOutputStream(), req.getParameter("xsd"));
        if (ret == 0) {
            res.sendRedirect("");
        } else if (ret == -1) {
            res.sendError(404);
        }
    }

    private void handleWSDLRequest(HttpServletRequest req, HttpServletResponse res, String url, AxisService axisService) throws IOException {
        if (!this.canExposeServiceMetadata(axisService)) {
            res.sendError(403);
            return;
        }
        ServletOutputStream out = res.getOutputStream();
        res.setContentType("text/xml");
        String ip = this.extractHost(url);
        String wsdlName = req.getParameter("wsdl");
        if (wsdlName != null && wsdlName.length() > 0) {
            axisService.printUserWSDL((OutputStream)out, wsdlName, ip);
        } else {
            axisService.printWSDL((OutputStream)out, ip);
        }
    }

    private void handleWSDL2Request(HttpServletRequest req, HttpServletResponse res, String url, AxisService axisService) throws IOException {
        if (!this.canExposeServiceMetadata(axisService)) {
            res.sendError(403);
            return;
        }
        res.setContentType("text/xml");
        String ip = this.extractHost(url);
        String wsdlName = req.getParameter("wsdl2");
        int ret = axisService.printWSDL2((OutputStream)res.getOutputStream(), ip, wsdlName);
        if (ret == 0) {
            res.sendRedirect("");
        } else if (ret == -1) {
            res.sendError(404);
        }
    }

    private boolean canExposeServiceMetadata(AxisService service) {
        Parameter exposeServiceMetadata = service.getParameter("exposeServiceMetadata");
        return exposeServiceMetadata == null || !JavaUtils.isFalseExplicitly(exposeServiceMetadata.getValue());
    }

    protected void processListServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.listServiceDisabled()) {
            return;
        }
        this.populateSessionInformation(req);
        req.getSession().setAttribute("errprservicemap", this.configContext.getAxisConfiguration().getFaultyServices());
        this.renderView(LIST_MULTIPLE_SERVICE_JSP_NAME, req, res);
    }

    private Policy findPolicy(String id, AxisDescription des) {
        ArrayList policyElements = des.getPolicyInclude().getPolicyElements();
        PolicyRegistry registry = des.getPolicyInclude().getPolicyRegistry();
        Policy policy = registry.lookup(id);
        if (policy != null) {
            return policy;
        }
        for (Object policyComponent : policyElements) {
            if (!(policyComponent instanceof Policy) || !id.equals(((Policy)policyComponent).getId())) continue;
            return (Policy)policyComponent;
        }
        Iterator<? extends AxisDescription> iterator = des.getChildren();
        while (iterator.hasNext()) {
            AxisDescription child = iterator.next();
            policy = this.findPolicy(id, child);
            if (policy == null) continue;
            return policy;
        }
        return null;
    }

    private boolean listServiceDisabled() {
        Parameter parameter = this.configContext.getAxisConfiguration().getParameter("disableServiceList");
        return parameter != null && "true".equals(parameter.getValue());
    }
}

