/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportHeadersAdapter
implements Map {
    private static final Log log = LogFactory.getLog(TransportHeadersAdapter.class);
    MessageContext mc;
    String propertyName;

    private TransportHeadersAdapter(MessageContext mc, String propertyName) {
        this.mc = mc;
        this.propertyName = propertyName;
    }

    public static void install(MessageContext mc) {
        Object map;
        String propertyName;
        boolean isRequest = mc.getMEPContext().getRequestMessageContext() == mc;
        String string = propertyName = isRequest ? "javax.xml.ws.http.request.headers" : "javax.xml.ws.http.response.headers";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Installing TransportHeadersAdapter for " + propertyName));
        }
        if ((map = mc.getProperty(propertyName)) instanceof TransportHeadersAdapter) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"An TransportHeadersAdapter is already installed.  Reusing the existing one.");
            }
            return;
        }
        TransportHeadersAdapter tha = new TransportHeadersAdapter(mc, propertyName);
        if (map != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The TransportHeaders in the existing map (" + propertyName + ") are copied to the TransportHeadersAdapter."));
            }
            tha.putAll((Map)map);
        }
        mc.setPropertyNoReturn(propertyName, tha);
        if (!isRequest) {
            Object value = mc.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
            mc.setProperty("javax.xml.ws.http.response.code", value);
        }
    }

    private static Map getDelegateMap(MessageContext mc) {
        HashMap map = (HashMap)mc.getProperty("TRANSPORT_HEADERS");
        if (map == null) {
            map = new HashMap();
            mc.setProperty("TRANSPORT_HEADERS", map);
        }
        return map;
    }

    private static List<String> convertToList(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            String[] values = s.split(", ");
            ArrayList<String> l = new ArrayList<String>();
            l.addAll(Arrays.asList(values));
            return l;
        }
        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("inputConvertionErr", o.getClass().toString()));
    }

    private static String convertToString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof List) {
            List l = (List)o;
            if (l.size() == 0) {
                return null;
            }
            String s = "";
            for (int i = 0; i < l.size(); ++i) {
                s = s + l.get(i);
                if (i == l.size() - 1) continue;
                s = s + ", ";
            }
            return s;
        }
        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("inputConvertionErr1", o.getClass().toString()));
    }

    @Override
    public int size() {
        return TransportHeadersAdapter.getDelegateMap(this.mc).size();
    }

    @Override
    public boolean isEmpty() {
        return TransportHeadersAdapter.getDelegateMap(this.mc).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return TransportHeadersAdapter.getDelegateMap(this.mc).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        String valueString = TransportHeadersAdapter.convertToString(value);
        return TransportHeadersAdapter.getDelegateMap(this.mc).containsValue(valueString);
    }

    public Object get(Object key) {
        List<String> value = TransportHeadersAdapter.convertToList(TransportHeadersAdapter.getDelegateMap(this.mc).get(key));
        if (log.isDebugEnabled()) {
            log.debug((Object)("get(" + key + ") returns value=" + value));
        }
        return value;
    }

    public Object put(Object key, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(" + key + " , " + value + ")"));
        }
        String valueString = TransportHeadersAdapter.convertToString(value);
        return TransportHeadersAdapter.convertToList(TransportHeadersAdapter.getDelegateMap(this.mc).put(key, valueString));
    }

    public Object remove(Object key) {
        return TransportHeadersAdapter.convertToList(TransportHeadersAdapter.getDelegateMap(this.mc).remove(key));
    }

    public void putAll(Map t) {
        for (Object key : t.keySet()) {
            Object value = t.get(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("put via putAll (" + key + " , " + value + ")"));
            }
            this.put(key, value);
        }
    }

    @Override
    public void clear() {
        TransportHeadersAdapter.getDelegateMap(this.mc).clear();
    }

    public Set keySet() {
        return TransportHeadersAdapter.getDelegateMap(this.mc).keySet();
    }

    public Collection values() {
        return this.copy().values();
    }

    public Set entrySet() {
        return this.copy().entrySet();
    }

    private Map copy() {
        HashMap tempMap = new HashMap();
        for (Object key : this.keySet()) {
            List value = (List)this.get(key);
            tempMap.put(key, value);
        }
        return tempMap;
    }

    public String toString() {
        return "TransportHeadersAdapter: " + TransportHeadersAdapter.getDelegateMap(this.mc).toString();
    }
}

