/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.handler.MessageContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEPContext
implements javax.xml.ws.handler.MessageContext {
    protected MessageContext requestMC;
    protected MessageContext responseMC;
    private Map<String, MessageContext.Scope> scopes;
    private boolean ApplicationAccessLocked = false;

    public MEPContext(MessageContext requestMsgCtx) {
        this.requestMC = requestMsgCtx;
        this.scopes = new HashMap<String, MessageContext.Scope>();
        requestMsgCtx.setMEPContext(this);
    }

    public EndpointDescription getEndpointDesc() {
        if (this.responseMC != null) {
            return this.responseMC.getEndpointDescription();
        }
        return this.requestMC.getEndpointDescription();
    }

    public MessageContext getRequestMessageContext() {
        return this.requestMC;
    }

    public MessageContext getResponseMessageContext() {
        return this.responseMC;
    }

    public MessageContext getMessageContext() {
        if (this.responseMC != null) {
            return this.responseMC;
        }
        return this.requestMC;
    }

    public void setResponseMessageContext(MessageContext responseMC) {
        if (this.responseMC != null) {
            responseMC.setProperty("javax.xml.ws.binding.attachments.outbound", this.responseMC.getProperty("javax.xml.ws.binding.attachments.outbound"));
        }
        this.responseMC = responseMC;
        this.ApplicationAccessLocked = false;
    }

    public void setMessage(Message msg) {
        if (this.responseMC != null) {
            this.responseMC.setMessage(msg);
        } else {
            this.requestMC.setMessage(msg);
        }
    }

    @Override
    public MessageContext.Scope getScope(String s) {
        if (this.scopes.get(s) == null) {
            return MessageContext.Scope.APPLICATION;
        }
        return this.scopes.get(s);
    }

    @Override
    public void setScope(String s, MessageContext.Scope scope) {
        if (this.isApplicationAccessLocked()) {
            return;
        }
        this.scopes.put(s, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.isApplicationAccessLocked()) {
            Map<String, Object> appScopedProps = this.getApplicationScopedProperties();
            for (String key : appScopedProps.keySet()) {
                this.remove(key);
            }
            return;
        }
        if (this.responseMC != null) {
            this.responseMC.getProperties().clear();
        }
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            this.requestMC.getProperties().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.isApplicationAccessLocked()) {
            return this.getApplicationScopedProperties().containsKey(key);
        }
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            if (this.responseMC != null) {
                boolean containsKey;
                boolean bl = containsKey = this.responseMC.containsKey(key) || this.requestMC.containsKey(key);
                if (this.getScope((String)key) == MessageContext.Scope.APPLICATION || !this.isApplicationAccessLocked()) {
                    return containsKey;
                }
            }
            if (this.getScope((String)key) == MessageContext.Scope.APPLICATION || !this.isApplicationAccessLocked()) {
                return this.requestMC.containsKey(key);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (this.isApplicationAccessLocked()) {
            return this.getApplicationScopedProperties().containsValue(value);
        }
        if (this.responseMC != null) {
            if (this.responseMC.getProperties().containsValue(value)) {
                return true;
            }
            MessageContext messageContext = this.requestMC;
            synchronized (messageContext) {
                return this.requestMC.getProperties().containsValue(value);
            }
        }
        return this.requestMC.getProperties().containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set entrySet() {
        if (this.isApplicationAccessLocked()) {
            return this.getApplicationScopedProperties().entrySet();
        }
        HashMap<String, Object> tempProps = new HashMap<String, Object>();
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            tempProps.putAll(this.requestMC.getProperties());
        }
        if (this.responseMC != null) {
            tempProps.putAll(this.responseMC.getProperties());
        }
        return tempProps.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object keyObject) {
        String key = (String)keyObject;
        if (!(this.responseMC == null || this.responseMC.getProperty(key) == null || this.getScope(key) != MessageContext.Scope.APPLICATION && this.isApplicationAccessLocked())) {
            return this.responseMC.getProperty(key);
        }
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            if (this.getScope(key) == MessageContext.Scope.APPLICATION || !this.isApplicationAccessLocked()) {
                return this.requestMC.getProperty(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (this.isApplicationAccessLocked()) {
            return this.getApplicationScopedProperties().isEmpty();
        }
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            if (this.responseMC != null) {
                return this.requestMC.getProperties().isEmpty() && this.requestMC.getProperties().isEmpty();
            }
            return this.requestMC.getProperties().isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set keySet() {
        if (this.isApplicationAccessLocked()) {
            return this.getApplicationScopedProperties().keySet();
        }
        HashMap<String, Object> tempProps = new HashMap<String, Object>();
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            tempProps.putAll(this.requestMC.getProperties());
        }
        if (this.responseMC != null) {
            tempProps.putAll(this.responseMC.getProperties());
        }
        return tempProps.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String key, Object value) {
        if (this.scopes.get(key) == null) {
            this.setScope(key, MessageContext.Scope.HANDLER);
        }
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            if (this.requestMC.containsKey(key)) {
                return this.requestMC.setProperty(key, value);
            }
            if (this.responseMC != null) {
                return this.responseMC.setProperty(key, value);
            }
            return this.requestMC.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            if (this.getScope((String)entry.getKey()) != null) continue;
            this.setScope((String)entry.getKey(), MessageContext.Scope.HANDLER);
        }
        if (this.responseMC != null) {
            this.responseMC.setProperties(t);
        } else {
            MessageContext messageContext = this.requestMC;
            synchronized (messageContext) {
                this.requestMC.setProperties(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        if (this.isApplicationAccessLocked() && this.getScope((String)key).equals((Object)MessageContext.Scope.HANDLER)) {
            return null;
        }
        Object retVal = null;
        if (this.responseMC != null) {
            retVal = this.responseMC.getProperties().remove(key);
        }
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            if (retVal == null) {
                return this.requestMC.getProperties().remove(key);
            }
            this.requestMC.getProperties().remove(key);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.isApplicationAccessLocked()) {
            return this.getApplicationScopedProperties().size();
        }
        HashMap<String, Object> tempProps = new HashMap<String, Object>();
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            tempProps.putAll(this.requestMC.getProperties());
        }
        if (this.responseMC != null) {
            tempProps.putAll(this.responseMC.getProperties());
        }
        return tempProps.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection values() {
        if (this.isApplicationAccessLocked()) {
            return this.getApplicationScopedProperties().values();
        }
        HashMap<String, Object> tempProps = new HashMap<String, Object>();
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            tempProps.putAll(this.requestMC.getProperties());
        }
        if (this.responseMC != null) {
            tempProps.putAll(this.responseMC.getProperties());
        }
        return tempProps.values();
    }

    public Message getMessageObject() {
        if (this.responseMC != null) {
            return this.responseMC.getMessage();
        }
        return this.requestMC.getMessage();
    }

    public boolean isApplicationAccessLocked() {
        if (this == this.requestMC.getMEPContext()) {
            return this.ApplicationAccessLocked;
        }
        if (this.responseMC == null) {
            return this.requestMC.getMEPContext().isApplicationAccessLocked();
        }
        return this.responseMC.getMEPContext().isApplicationAccessLocked() || this.requestMC.getMEPContext().isApplicationAccessLocked();
    }

    public void setApplicationAccessLocked(boolean applicationAccessLocked) {
        if (this == this.requestMC.getMEPContext()) {
            this.ApplicationAccessLocked = applicationAccessLocked;
        } else {
            this.requestMC.getMEPContext().setApplicationAccessLocked(applicationAccessLocked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getApplicationScopedProperties() {
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        if (!this.scopes.containsValue((Object)MessageContext.Scope.APPLICATION)) {
            return tempMap;
        }
        MessageContext messageContext = this.requestMC;
        synchronized (messageContext) {
            for (Map.Entry<String, Object> entry : this.requestMC.getProperties().entrySet()) {
                if (!this.getScope(entry.getKey()).equals((Object)MessageContext.Scope.APPLICATION)) continue;
                tempMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.responseMC != null) {
            for (Map.Entry<String, Object> entry : this.responseMC.getProperties().entrySet()) {
                if (!this.getScope(entry.getKey()).equals((Object)MessageContext.Scope.APPLICATION)) continue;
                tempMap.put(entry.getKey(), entry.getValue());
            }
        }
        return tempMap;
    }
}

